/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.esa.s3tbx.dataio.s3.Manifest;
import org.esa.s3tbx.dataio.s3.XfduManifest;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XfduManifestTest {
    private static Manifest manifestTest;

    @BeforeClass
    public static void setUp() throws ParserConfigurationException, IOException, SAXException {
        try (InputStream stream = XfduManifestTest.class.getResourceAsStream("xfdumanifest.xml");){
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            manifestTest = XfduManifest.createManifest((Document)doc);
        }
    }

    @Test
    public void testGetProductname() throws Exception {
        Assert.assertEquals((Object)"S3A_SL_1_RBT____20160820T201637_20160820T201937_20160820T222707_0179_007_370_4500_MAR_O_NR_001.SEN3", (Object)manifestTest.getProductName());
    }

    @Test
    public void testGetProductType() throws Exception {
        Assert.assertEquals((Object)"SL_1_RBT", (Object)manifestTest.getProductType());
    }

    @Test
    public void testGetDescription() throws Exception {
        Assert.assertEquals((Object)"Sentinel 3 SYN Level 2", (Object)manifestTest.getDescription());
    }

    @Test
    public void testGetStartTime() throws Exception {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-06-21T10:09:20.646463", (String)"yyyy-MM-dd'T'HH:mm:ss");
        ProductData.UTC startTime = manifestTest.getStartTime();
        Assert.assertTrue((boolean)expected.equalElems((ProductData)startTime));
    }

    @Test
    public void testGetStopTime() throws Exception {
        ProductData.UTC expected = ProductData.UTC.parse((String)"2013-06-21T10:14:13.646463", (String)"yyyy-MM-dd'T'HH:mm:ss");
        ProductData.UTC stopTime = manifestTest.getStopTime();
        Assert.assertTrue((boolean)expected.equalElems((ProductData)stopTime));
    }

    @Test
    public void testGetFileNames() {
        String[] excluded = new String[]{};
        List fileNames = manifestTest.getFileNames(excluded);
        Assert.assertEquals((long)67L, (long)fileNames.size());
        Assert.assertEquals((Object)"r0400.nc", fileNames.get(0));
        Assert.assertEquals((Object)"r0560.nc", fileNames.get(5));
        Assert.assertEquals((Object)"r0550n.nc", fileNames.get(18));
        Assert.assertEquals((Object)"r1375o.nc", fileNames.get(27));
        Assert.assertEquals((Object)"flags.nc", fileNames.get(66));
    }

    @Test
    public void testGetFileNames_Exclusions() {
        String[] excluded = new String[]{"aerosolModelIndex", "pixelStatusFlags"};
        List fileNames = manifestTest.getFileNames(excluded);
        Assert.assertEquals((long)65L, (long)fileNames.size());
        Assert.assertEquals((Object)false, (Object)fileNames.contains("amin.nc"));
        Assert.assertEquals((Object)false, (Object)fileNames.contains("flags.nc"));
        Assert.assertEquals((Object)"r0560.nc", fileNames.get(5));
        Assert.assertEquals((Object)"r0550n.nc", fileNames.get(18));
        Assert.assertEquals((Object)"r1375o.nc", fileNames.get(27));
    }
}

