/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import java.io.File;
import java.util.Iterator;
import org.esa.s3tbx.dataio.s3.Sentinel3ProductReaderPlugIn;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class Sentinel3ProductReaderPlugInTest {
    private Sentinel3ProductReaderPlugIn plugIn;

    @Before
    public void setup() {
        this.plugIn = new Sentinel3ProductReaderPlugIn();
    }

    @Test
    public void testIfPlugInIsLoaded() {
        ProductIOPlugInManager ioPlugInManager = ProductIOPlugInManager.getInstance();
        Iterator readerPlugIns = ioPlugInManager.getReaderPlugIns("Sen3");
        Assert.assertTrue((boolean)readerPlugIns.hasNext());
        Assert.assertTrue((boolean)(readerPlugIns.next() instanceof Sentinel3ProductReaderPlugIn));
    }

    @Test
    public void testDecodeQualification_OlciLevel1b() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("OL", "1", "ERR", "");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
        path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("OL", "1", "EFR", "");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_OlciLevel2L() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("OL", "2", "LFR", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_OlciLevel2W() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("OL", "2", "WFR", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_SlstrLevel1b() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("SL", "1", "RBT", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_SlstrWct() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("SL", "2", "WCT", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_SlstrWst() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("SL", "2", "WST", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_SlstrLst() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("SL", "2", "LST", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_SynergyLevel2() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("SY", "2", "SYN", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_VgtP() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("SY", "2", "VGP", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_VgtS() {
        String path = Sentinel3ProductReaderPlugInTest.createManifestFilePath("SY", "3", "VG1", ".SEN3");
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testDecodeQualification_WithInvalidDataSource() {
        String invalidPath = Sentinel3ProductReaderPlugInTest.createManifestFilePath("SL", "1", "XXX", "");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugIn.getDecodeQualification((Object)invalidPath));
    }

    @Test
    public void testDecodeQualificationWith_WrongFile() {
        String invalidPath = "/S3_SY_2_ERR_TTTTTTTTTTTT_instanceID_GGG_CCCC_VV/someFile.doc";
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugIn.getDecodeQualification((Object)"/S3_SY_2_ERR_TTTTTTTTTTTT_instanceID_GGG_CCCC_VV/someFile.doc"));
    }

    @Test
    public void testDecodeQualification_WithoutFile() {
        String invalidPath = "/SY_1_ERR_TTTTTTTTTTTT_instanceID_GGG_CCCC_VV";
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugIn.getDecodeQualification((Object)"/SY_1_ERR_TTTTTTTTTTTT_instanceID_GGG_CCCC_VV"));
    }

    @Test
    public void testDecodeQualificationFromXfduManifestOnly_Nonsense() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("nonsense/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_Olcil1fr() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("olcil1fr/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_Olcil1rr() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("olcil1rr/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_Olcill2fr() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("olcil2lfr/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_Olcil2lrr() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("olcil2lrr/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_Olcil2wfr() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("olcil2wfr/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_Olcil2wrr() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("olcil2wrr/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_SlstrL1() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("slstrl1/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_SlstrL2LST() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("slstrl2lst/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_SlstrL2WST() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("slstrl2wst/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_SynL2() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("synl2/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_SynVG1() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("synvg1/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    @Ignore
    public void testDecodeQualificationFromXfduManifestOnly_SynVGP() {
        String path = Sentinel3ProductReaderPlugInTest.class.getResource("synvgp/xfdumanifest.xml").getFile();
        Assert.assertEquals((Object)DecodeQualification.INTENDED, (Object)this.plugIn.getDecodeQualification((Object)path));
    }

    @Test
    public void testSupportedInputTypes() {
        Class[] inputTypes = this.plugIn.getInputTypes();
        Assert.assertEquals((long)2L, (long)inputTypes.length);
        Assert.assertEquals(String.class, (Object)inputTypes[0]);
        Assert.assertEquals(File.class, (Object)inputTypes[1]);
    }

    @Test
    public void testCreateReaderInstanceReturnsNewInstanceEachTime() {
        ProductReader firstInstance = this.plugIn.createReaderInstance();
        Assert.assertNotNull((Object)firstInstance);
        ProductReader secondInstance = this.plugIn.createReaderInstance();
        Assert.assertNotSame((Object)secondInstance, (Object)firstInstance);
    }

    private static String createManifestFilePath(String sensorId, String levelId, String productId, String suffix) {
        String validParentDirectory = String.format("/S3_%s_%s_%s_TTTTTTTTTTTT_.*%s/", sensorId, levelId, productId, suffix);
        String manifestFile = "xfdumanifest.xml";
        return validParentDirectory + manifestFile;
    }
}

