/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.s3;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import org.esa.s3tbx.dataio.s3.LonLatFunction;
import org.esa.s3tbx.dataio.s3.LonLatMultiLevelSource;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LonLatMultiLevelSourceTest {
    @Test
    @Ignore
    public void testCreate_WithNullSources() throws Exception {
        TestMultiLevelSource lonSource = new TestMultiLevelSource(10, 10);
        TestMultiLevelSource latSource = new TestMultiLevelSource(10, 10);
        TestLonLatFunction function = new TestLonLatFunction();
        try {
            LonLatMultiLevelSource.create(null, (MultiLevelSource)latSource, (LonLatFunction)function, (int)5);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            LonLatMultiLevelSource.create((MultiLevelSource)lonSource, null, (LonLatFunction)function, (int)5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Ignore
    public void testCreate_WithNullFunction() throws Exception {
        TestMultiLevelSource lonSource = new TestMultiLevelSource(10, 10);
        TestMultiLevelSource latSource = new TestMultiLevelSource(10, 10);
        LonLatFunction function = null;
        try {
            LonLatMultiLevelSource.create((MultiLevelSource)lonSource, (MultiLevelSource)latSource, function, (int)5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Ignore
    public void testCreate_WithWrongDataType() throws Exception {
        TestMultiLevelSource lonSource = new TestMultiLevelSource(10, 10);
        TestMultiLevelSource latSource = new TestMultiLevelSource(10, 10);
        TestLonLatFunction function = new TestLonLatFunction();
        try {
            LonLatMultiLevelSource.create((MultiLevelSource)lonSource, (MultiLevelSource)latSource, (LonLatFunction)function, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Ignore
    public void testCreate_WithIncompatibleSources() throws Exception {
        TestMultiLevelSource lonSource = new TestMultiLevelSource(10, 10);
        TestMultiLevelSource latSource = new TestMultiLevelSource(11, 11);
        TestLonLatFunction function = new TestLonLatFunction();
        try {
            LonLatMultiLevelSource.create((MultiLevelSource)lonSource, (MultiLevelSource)latSource, (LonLatFunction)function, (int)0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @Ignore
    public void testCreate() throws Exception {
        TestMultiLevelSource lonSource = new TestMultiLevelSource(10, 10);
        TestMultiLevelSource latSource = new TestMultiLevelSource(10, 10);
        TestLonLatFunction function = new TestLonLatFunction();
        Assert.assertNotNull((Object)LonLatMultiLevelSource.create((MultiLevelSource)lonSource, (MultiLevelSource)latSource, (LonLatFunction)function, (int)5));
        Assert.assertNotNull((Object)LonLatMultiLevelSource.create((MultiLevelSource)lonSource, (MultiLevelSource)latSource, (LonLatFunction)function, (int)4));
    }

    private static class TestLonLatFunction
    implements LonLatFunction {
        private TestLonLatFunction() {
        }

        public double getValue(double lon, double lat) {
            return 0.0;
        }
    }

    private static class TestMultiLevelSource
    extends AbstractMultiLevelSource {
        private TestMultiLevelSource(int width, int height) {
            super((MultiLevelModel)new DefaultMultiLevelModel(new AffineTransform(), width, height));
        }

        protected RenderedImage createImage(int level) {
            return null;
        }
    }
}

