/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.probav;

import java.awt.Color;
import java.util.List;
import java.util.logging.Level;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.object.Attribute;
import org.esa.s3tbx.dataio.probav.ProbaVConstants;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.util.BitSetter;
import org.esa.snap.core.util.SystemUtils;

public class ProbaVUtils {
    public static String getAttributeValue(Attribute attribute) {
        String result = "";
        switch (attribute.getType().getDatatypeClass()) {
            case 0: {
                int[] ivals;
                for (int ival : ivals = (int[])attribute.getValue()) {
                    result = result.concat(Integer.toString(ival) + " ");
                }
                break;
            }
            case 1: {
                float[] fvals;
                for (float fval : fvals = (float[])attribute.getValue()) {
                    result = result.concat(Float.toString(fval) + " ");
                }
                break;
            }
            case 3: {
                String[] svals;
                for (String sval : svals = (String[])attribute.getValue()) {
                    result = result.concat(sval + " ");
                }
                break;
            }
        }
        return result.trim();
    }

    public static String getStringAttributeValue(List<Attribute> metadata, String attributeName) {
        String stringAttr = null;
        for (Attribute attribute : metadata) {
            if (!attribute.getName().equals(attributeName)) continue;
            try {
                stringAttr = ProbaVUtils.getAttributeValue(attribute);
            }
            catch (NumberFormatException e) {
                SystemUtils.LOG.log(Level.WARNING, "Cannot parse string attribute: " + e.getMessage());
            }
        }
        return stringAttr;
    }

    public static float getFloatAttributeValue(List<Attribute> metadata, String attributeName) {
        float floatAttr = Float.NaN;
        for (Attribute attribute : metadata) {
            if (!attribute.getName().equals(attributeName)) continue;
            try {
                floatAttr = Float.parseFloat(ProbaVUtils.getAttributeValue(attribute));
            }
            catch (NumberFormatException e) {
                SystemUtils.LOG.log(Level.WARNING, "Cannot parse float attribute: " + e.getMessage());
            }
        }
        return floatAttr;
    }

    public static String[] getStartEndTimeFromAttributes(List<Attribute> metadata) {
        String[] startStopTimes = new String[2];
        String startDate = "";
        String startTime = "";
        String endDate = "";
        String endTime = "";
        for (Attribute attribute : metadata) {
            if (attribute.getName().equals("OBSERVATION_START_DATE")) {
                startDate = ProbaVUtils.getAttributeValue(attribute);
                continue;
            }
            if (attribute.getName().equals("OBSERVATION_START_TIME")) {
                startTime = ProbaVUtils.getAttributeValue(attribute);
                continue;
            }
            if (attribute.getName().equals("OBSERVATION_END_DATE")) {
                endDate = ProbaVUtils.getAttributeValue(attribute);
                continue;
            }
            if (!attribute.getName().equals("OBSERVATION_END_TIME")) continue;
            endTime = ProbaVUtils.getAttributeValue(attribute);
        }
        startStopTimes[0] = startDate + " " + startTime;
        startStopTimes[1] = endDate + " " + endTime;
        return startStopTimes;
    }

    public static void addSynthesisQualityMasks(Product probavProduct) {
        ProductNodeGroup maskGroup = probavProduct.getMaskGroup();
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "CLEAR", "Clear pixel", ProbaVConstants.FLAG_COLORS[0], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "UNDEFINED", "Pixel classified as undefined", ProbaVConstants.FLAG_COLORS[1], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "CLOUD", "Cloudy pixel", ProbaVConstants.FLAG_COLORS[2], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "SNOWICE", "Snow or ice pixel", ProbaVConstants.FLAG_COLORS[3], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "CLOUD_SHADOW", "Cloud shadow pixel", ProbaVConstants.FLAG_COLORS[4], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "LAND", "Land pixel", ProbaVConstants.FLAG_COLORS[5], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "GOOD_SWIR", "Pixel with good SWIR data", ProbaVConstants.FLAG_COLORS[6], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "GOOD_NIR", "Pixel with good NIR data", ProbaVConstants.FLAG_COLORS[7], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "GOOD_RED", "Pixel with good RED data", ProbaVConstants.FLAG_COLORS[8], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, "SM_FLAGS", "GOOD_BLUE", "Pixel with good BLUE data", ProbaVConstants.FLAG_COLORS[9], 0.5f);
    }

    public static void addSynthesisQualityFlags(FlagCoding probavSmFlagCoding) {
        probavSmFlagCoding.addFlag("CLEAR", BitSetter.setFlag((int)0, (int)0), "Clear pixel");
        probavSmFlagCoding.addFlag("UNDEFINED", BitSetter.setFlag((int)0, (int)1), "Pixel classified as undefined");
        probavSmFlagCoding.addFlag("CLOUD", BitSetter.setFlag((int)0, (int)2), "Cloudy pixel");
        probavSmFlagCoding.addFlag("SNOWICE", BitSetter.setFlag((int)0, (int)3), "Snow or ice pixel");
        probavSmFlagCoding.addFlag("CLOUD_SHADOW", BitSetter.setFlag((int)0, (int)4), "Cloud shadow pixel");
        probavSmFlagCoding.addFlag("LAND", BitSetter.setFlag((int)0, (int)5), "Land pixel");
        probavSmFlagCoding.addFlag("GOOD_SWIR", BitSetter.setFlag((int)0, (int)6), "Pixel with good SWIR data");
        probavSmFlagCoding.addFlag("GOOD_NIR", BitSetter.setFlag((int)0, (int)7), "Pixel with good NIR data");
        probavSmFlagCoding.addFlag("GOOD_RED", BitSetter.setFlag((int)0, (int)8), "Pixel with good RED data");
        probavSmFlagCoding.addFlag("GOOD_BLUE", BitSetter.setFlag((int)0, (int)9), "Pixel with good BLUE data");
    }

    public static void addL1cQualityMasks(Product probavProduct, String sourceQualityBandName, String targetQualityFlagBandName) {
        ProductNodeGroup maskGroup = probavProduct.getMaskGroup();
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, targetQualityFlagBandName, sourceQualityBandName + "_" + "CORRECT", "Pixel has no bad quality indicators", ProbaVConstants.FLAG_COLORS[0], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, targetQualityFlagBandName, sourceQualityBandName + "_" + "MISSING", "Pixel value missing due to a bad detector", ProbaVConstants.FLAG_COLORS[1], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, targetQualityFlagBandName, sourceQualityBandName + "_" + "WAS_SATURATED", "Pixel DN value is equal to 4095 in 12-bits coding", ProbaVConstants.FLAG_COLORS[2], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, targetQualityFlagBandName, sourceQualityBandName + "_" + "BECAME_SATURATED", "Pixel value became 4095 during the TOA calculation", ProbaVConstants.FLAG_COLORS[3], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, targetQualityFlagBandName, sourceQualityBandName + "_" + "BECAME_NEGATIVE", "Pixel value became negative during the TOA calculation", ProbaVConstants.FLAG_COLORS[4], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, targetQualityFlagBandName, sourceQualityBandName + "_" + "INTERPOLATED", "Pixel value was interpolated using the neighbour pixels", ProbaVConstants.FLAG_COLORS[5], 0.5f);
        ProbaVUtils.addMask(probavProduct, (ProductNodeGroup<Mask>)maskGroup, targetQualityFlagBandName, sourceQualityBandName + "_" + "BORDER_COMPRESSED", "Pixel value is uncertaion due to onboard compression artefacts", ProbaVConstants.FLAG_COLORS[6], 0.5f);
    }

    public static void addL1cQualityFlags(FlagCoding probavSmFlagCoding, String sourceQualityBandName) {
        probavSmFlagCoding.addFlag(sourceQualityBandName + "_" + "CORRECT", BitSetter.setFlag((int)0, (int)0), "Pixel has no bad quality indicators");
        probavSmFlagCoding.addFlag(sourceQualityBandName + "_" + "MISSING", BitSetter.setFlag((int)0, (int)1), "Pixel value missing due to a bad detector");
        probavSmFlagCoding.addFlag(sourceQualityBandName + "_" + "WAS_SATURATED", BitSetter.setFlag((int)0, (int)2), "Pixel DN value is equal to 4095 in 12-bits coding");
        probavSmFlagCoding.addFlag(sourceQualityBandName + "_" + "BECAME_SATURATED", BitSetter.setFlag((int)0, (int)3), "Pixel value became 4095 during the TOA calculation");
        probavSmFlagCoding.addFlag(sourceQualityBandName + "_" + "BECAME_NEGATIVE", BitSetter.setFlag((int)0, (int)4), "Pixel value became negative during the TOA calculation");
        probavSmFlagCoding.addFlag(sourceQualityBandName + "_" + "INTERPOLATED", BitSetter.setFlag((int)0, (int)5), "Pixel value was interpolated using the neighbour pixels");
        probavSmFlagCoding.addFlag(sourceQualityBandName + "_" + "BORDER_COMPRESSED", BitSetter.setFlag((int)0, (int)6), "Pixel value is uncertaion due to onboard compression artefacts");
    }

    public static ProductData getProbaVRasterData(int file_id, int sourceWidth, int sourceHeight, String datasetName, int datatypeClass) {
        try {
            int dataset_id = H5.H5Dopen((int)file_id, (String)datasetName, (int)HDF5Constants.H5P_DEFAULT);
            int dataspace_id = H5.H5Dget_space((int)dataset_id);
            long[] offset = new long[]{0L, 0L};
            long[] count = new long[]{sourceWidth, sourceHeight};
            H5.H5Sselect_hyperslab((int)dataspace_id, (int)HDF5Constants.H5S_SELECT_SET, (long[])offset, null, (long[])count, null);
            int memspace_id = H5.H5Screate_simple((int)count.length, (long[])count, null);
            long[] offset_out = new long[]{0L, 0L};
            H5.H5Sselect_hyperslab((int)memspace_id, (int)HDF5Constants.H5S_SELECT_SET, (long[])offset_out, null, (long[])count, null);
            int dataType = ProbaVUtils.getDatatypeForH5Dread(datatypeClass);
            ProductData destBuffer = ProbaVUtils.getDataBufferForH5Dread(datatypeClass, sourceWidth, sourceHeight);
            H5.H5Dread((int)dataset_id, (int)dataType, (int)memspace_id, (int)dataspace_id, (int)HDF5Constants.H5P_DEFAULT, (Object)destBuffer.getElems());
            H5.H5Dclose((int)dataset_id);
            H5.H5Sclose((int)memspace_id);
            return destBuffer;
        }
        catch (Exception e) {
            SystemUtils.LOG.log(Level.SEVERE, "Cannot read ProbaV raster data '" + datasetName + "': " + e.getMessage());
            return null;
        }
    }

    private static int getDatatypeForH5Dread(int datatypeClass) {
        switch (datatypeClass) {
            case 4: {
                return HDF5Constants.H5T_NATIVE_UINT8;
            }
            case 2: {
                return HDF5Constants.H5T_NATIVE_UINT8;
            }
            case 1: {
                return HDF5Constants.H5T_NATIVE_FLOAT;
            }
            case 0: {
                return HDF5Constants.H5T_NATIVE_INT16;
            }
        }
        return -1;
    }

    private static ProductData getDataBufferForH5Dread(int datatypeClass, int width, int height) {
        switch (datatypeClass) {
            case 2: {
                return ProductData.createInstance((byte[])new byte[width * height]);
            }
            case 1: {
                return ProductData.createInstance((float[])new float[width * height]);
            }
            case 0: {
                return ProductData.createInstance((short[])new short[width * height]);
            }
        }
        return null;
    }

    private static void addMask(Product mod35Product, ProductNodeGroup<Mask> maskGroup, String bandName, String flagName, String description, Color color, float transparency) {
        int width = mod35Product.getSceneRasterWidth();
        int height = mod35Product.getSceneRasterHeight();
        String maskPrefix = "";
        Mask mask = Mask.BandMathsType.create((String)(maskPrefix + flagName), (String)description, (int)width, (int)height, (String)(bandName + "." + flagName), (Color)color, (double)transparency);
        maskGroup.add((ProductNode)mask);
    }
}

