/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.probav;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import org.esa.s3tbx.dataio.probav.ProbaVSynthesisProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;

public class ProbaVSynthesisProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final String _H5_CLASS_NAME = "ncsa.hdf.hdf5lib.H5";
    public static final String FORMAT_NAME_PROBA_V = "PROBA-V-Synthesis";
    private static final Class[] SUPPORTED_INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String DESCRIPTION = "PROBA-V Format";
    private static final String FILE_EXTENSION = "";
    private static final String[] DEFAULT_FILE_EXTENSIONS = new String[]{""};
    private static final String[] FORMAT_NAMES = new String[]{"PROBA-V-Synthesis"};
    private static boolean hdf5LibAvailable = false;

    public ProbaVSynthesisProductReaderPlugIn() {
        RGBImageProfile toaProfile = new RGBImageProfile("PROBA-V TOA RGB", new String[]{"TOA_REFL_NIR", "TOA_REFL_RED", "TOA_REFL_BLUE"});
        RGBImageProfile tocProfile = new RGBImageProfile("PROBA-V TOC RGB", new String[]{"TOC_REFL_NIR", "TOC_REFL_RED", "TOC_REFL_BLUE"});
        RGBImageProfileManager manager = RGBImageProfileManager.getInstance();
        manager.addProfile(toaProfile);
        manager.addProfile(tocProfile);
    }

    public DecodeQualification getDecodeQualification(Object input) {
        if (ProbaVSynthesisProductReaderPlugIn.isInputValid(input)) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        return null;
    }

    static boolean isHdf5LibAvailable() {
        return hdf5LibAvailable;
    }

    public Class[] getInputTypes() {
        return SUPPORTED_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new ProbaVSynthesisProductReader(this);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return DEFAULT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(FORMAT_NAMES[0], FILE_EXTENSION, DESCRIPTION);
    }

    static boolean isInputValid(Object input) {
        File inputFile = new File(input.toString());
        return ProbaVSynthesisProductReaderPlugIn.isInputProbaVFileNameValid(inputFile.getName());
    }

    static boolean isInputProbaVFileNameValid(String fileName) {
        return fileName.toUpperCase().endsWith(".HDF5") && (fileName.startsWith("PROBAV_S1_") || fileName.startsWith("PROBAV_S5_") || fileName.startsWith("PROBAV_S10_"));
    }

    static boolean isProbaSynthesisToaProduct(String fileName) {
        return ProbaVSynthesisProductReaderPlugIn.isInputProbaVFileNameValid(fileName) && fileName.contains("_TOA_") && !ProbaVSynthesisProductReaderPlugIn.isProbaSynthesisNdviProduct(fileName);
    }

    static boolean isProbaSynthesisTocProduct(String fileName) {
        return ProbaVSynthesisProductReaderPlugIn.isInputProbaVFileNameValid(fileName) && fileName.contains("_TOC_") && !ProbaVSynthesisProductReaderPlugIn.isProbaSynthesisNdviProduct(fileName);
    }

    static boolean isProbaSynthesisNdviProduct(String fileName) {
        return ProbaVSynthesisProductReaderPlugIn.isInputProbaVFileNameValid(fileName) && fileName.contains("_NDVI_");
    }

    static Class<?> loadHdf5Lib(Class<?> callerClass) {
        return ProbaVSynthesisProductReaderPlugIn.loadClassWithNativeDependencies(callerClass, _H5_CLASS_NAME, "{0}: HDF-5 library not available: {1}: {2}");
    }

    private static Class<?> loadClassWithNativeDependencies(Class<?> callerClass, String className, String warningPattern) {
        ClassLoader classLoader = callerClass.getClassLoader();
        String classResourceName = "/" + className.replace('.', '/') + ".class";
        SystemUtils.class.getResource(classResourceName);
        if (callerClass.getResource(classResourceName) != null) {
            try {
                return Class.forName(className, true, classLoader);
            }
            catch (Throwable error) {
                SystemUtils.LOG.warning(MessageFormat.format(warningPattern, callerClass, error.getClass(), error.getMessage()));
                return null;
            }
        }
        return null;
    }

    static {
        hdf5LibAvailable = ProbaVSynthesisProductReaderPlugIn.loadHdf5Lib(ProbaVSynthesisProductReaderPlugIn.class) != null;
    }
}

