/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.probav;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Level;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.h5.H5Group;
import ncsa.hdf.object.h5.H5ScalarDS;
import org.esa.s3tbx.dataio.probav.ProbaVConstants;
import org.esa.s3tbx.dataio.probav.ProbaVSynthesisBitMaskOp;
import org.esa.s3tbx.dataio.probav.ProbaVSynthesisProductReaderPlugIn;
import org.esa.s3tbx.dataio.probav.ProbaVUtils;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.util.ImageUtils;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ProbaVSynthesisProductReader
extends AbstractProductReader {
    private int productWidth;
    private int productHeight;
    private File probavFile;
    private int file_id;

    protected ProbaVSynthesisProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        Object inputObject = this.getInput();
        this.probavFile = ProbaVSynthesisProductReaderPlugIn.getFileInput(inputObject);
        String fileName = this.probavFile.getName();
        Product targetProduct = null;
        if (ProbaVSynthesisProductReaderPlugIn.isHdf5LibAvailable()) {
            FileFormat h5FileFormat = FileFormat.getFileFormat((String)"HDF5");
            FileFormat h5File = null;
            try {
                this.file_id = H5.H5Fopen((String)this.probavFile.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDONLY, (int)HDF5Constants.H5P_DEFAULT);
                h5File = h5FileFormat.createInstance(this.probavFile.getAbsolutePath(), 0);
                h5File.open();
                TreeNode rootNode = h5File.getRootNode();
                if (ProbaVSynthesisProductReaderPlugIn.isProbaSynthesisToaProduct(fileName) || ProbaVSynthesisProductReaderPlugIn.isProbaSynthesisTocProduct(fileName)) {
                    targetProduct = this.createTargetProductFromSynthesis(this.probavFile, rootNode);
                } else if (ProbaVSynthesisProductReaderPlugIn.isProbaSynthesisNdviProduct(fileName)) {
                    targetProduct = this.createTargetProductFromSynthesisNdvi(this.probavFile, rootNode);
                }
            }
            catch (Exception e) {
                throw new IOException("Failed to open file '" + this.probavFile.getPath() + "': " + e.getMessage());
            }
            finally {
                if (h5File != null) {
                    try {
                        h5File.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return targetProduct;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException(String.format("No source to read for band '%s'.", destBand.getName()));
    }

    private Product createTargetProductFromSynthesis(File inputFile, TreeNode inputFileRootNode) throws Exception {
        Product product = null;
        if (inputFileRootNode != null) {
            TreeNode level3Node = inputFileRootNode.getChildAt(0);
            this.productWidth = (int)this.getH5ScalarDS(level3Node.getChildAt(0).getChildAt(0)).getDims()[0];
            this.productHeight = (int)this.getH5ScalarDS(level3Node.getChildAt(0).getChildAt(0)).getDims()[1];
            product = new Product(inputFile.getName(), "PROBA-V SYNTHESIS", this.productWidth, this.productHeight);
            product.setAutoGrouping("TOA_REFL:TOC_REFL:VAA:VZA");
            H5Group rootGroup = (H5Group)((DefaultMutableTreeNode)inputFileRootNode).getUserObject();
            List rootMetadata = rootGroup.getMetadata();
            this.addSynthesisMetadataElement(rootMetadata, product, "MPH");
            product.setDescription(ProbaVUtils.getStringAttributeValue(rootMetadata, "DESCRIPTION"));
            product.setFileLocation(inputFile);
            block14: for (int i = 0; i < level3Node.getChildCount(); ++i) {
                String level3ChildNodeName;
                TreeNode level3ChildNode = level3Node.getChildAt(i);
                switch (level3ChildNodeName = level3ChildNode.toString()) {
                    case "GEOMETRY": {
                        this.setSynthesisGeoCoding(product, inputFileRootNode, level3ChildNode);
                        for (int j = 0; j < level3ChildNode.getChildCount(); ++j) {
                            TreeNode level3GeometryChildNode = level3ChildNode.getChildAt(j);
                            String level3GeometryChildNodeName = level3GeometryChildNode.toString();
                            if (this.isSynthesisSunAngleDataNode(level3GeometryChildNodeName)) {
                                H5ScalarDS sunAngleDS = this.getH5ScalarDS(level3GeometryChildNode);
                                Band sunAngleBand = this.createTargetBand(product, sunAngleDS, level3GeometryChildNodeName, 20);
                                this.setBandUnitAndDescription(sunAngleDS, sunAngleBand);
                                sunAngleBand.setNoDataValue(255.0);
                                sunAngleBand.setNoDataValueUsed(true);
                                String sunAngleDatasetName = "/LEVEL3/GEOMETRY/" + level3GeometryChildNodeName;
                                int sunAngleDatatypeClass = sunAngleDS.getDatatype().getDatatypeClass();
                                ProductData sunAngleRasterData = ProbaVUtils.getProbaVRasterData(this.file_id, this.productWidth, this.productHeight, sunAngleDatasetName, sunAngleDatatypeClass);
                                RenderedImage sunAngleImage = ImageUtils.createRenderedImage((int)this.productWidth, (int)this.productHeight, (ProductData)sunAngleRasterData);
                                sunAngleBand.setSourceImage(sunAngleImage);
                                continue;
                            }
                            if (!this.isSynthesisViewAngleGroupNode(level3GeometryChildNodeName)) continue;
                            for (int k = 0; k < level3GeometryChildNode.getChildCount(); ++k) {
                                TreeNode level3GeometryViewAngleChildNode = level3GeometryChildNode.getChildAt(k);
                                H5ScalarDS viewAngleDS = this.getH5ScalarDS(level3GeometryViewAngleChildNode);
                                String level3GeometryViewAngleChildNodeName = level3GeometryViewAngleChildNode.toString();
                                String viewAnglebandName = level3GeometryViewAngleChildNodeName + "_" + level3GeometryChildNodeName;
                                Band viewAngleBand = this.createTargetBand(product, viewAngleDS, viewAnglebandName, 20);
                                this.setBandUnitAndDescription(viewAngleDS, viewAngleBand);
                                viewAngleBand.setNoDataValue(255.0);
                                viewAngleBand.setNoDataValueUsed(true);
                                String viewAngleDatasetName = "/LEVEL3/GEOMETRY/" + level3GeometryChildNodeName + "/" + level3GeometryViewAngleChildNodeName;
                                int viewAngleDatatypeClass = viewAngleDS.getDatatype().getDatatypeClass();
                                ProductData viewAngleRasterData = ProbaVUtils.getProbaVRasterData(this.file_id, this.productWidth, this.productHeight, viewAngleDatasetName, viewAngleDatatypeClass);
                                RenderedImage viewAngleImage = ImageUtils.createRenderedImage((int)this.productWidth, (int)this.productHeight, (ProductData)viewAngleRasterData);
                                viewAngleBand.setSourceImage(viewAngleImage);
                            }
                        }
                        continue block14;
                    }
                    case "NDVI": {
                        this.setNdviBand(product, level3ChildNode);
                        continue block14;
                    }
                    case "QUALITY": {
                        H5ScalarDS qualityDS = this.getH5ScalarDS(level3ChildNode.getChildAt(0));
                        Product flagProduct = new Product("QUALITY", "flags", this.productWidth, this.productHeight);
                        ProductUtils.copyGeoCoding((Product)product, (Product)flagProduct);
                        Band smBand = this.createTargetBand(flagProduct, qualityDS, "SM", 20);
                        this.setBandUnitAndDescription(qualityDS, smBand);
                        String qualityDatasetName = "/LEVEL3/QUALITY/SM";
                        int qualityDatatypeClass = qualityDS.getDatatype().getDatatypeClass();
                        ProductData qualityRasterData = ProbaVUtils.getProbaVRasterData(this.file_id, this.productWidth, this.productHeight, "/LEVEL3/QUALITY/SM", qualityDatatypeClass);
                        RenderedImage qualityImage = ImageUtils.createRenderedImage((int)this.productWidth, (int)this.productHeight, (ProductData)qualityRasterData);
                        smBand.setSourceImage(qualityImage);
                        ProbaVSynthesisProductReader.attachSynthesisQualityFlagBand(product, flagProduct);
                        this.addQualityMetadata(product, (DefaultMutableTreeNode)level3ChildNode);
                        continue block14;
                    }
                    case "RADIOMETRY": {
                        for (int j = 0; j < level3ChildNode.getChildCount(); ++j) {
                            int k = ProbaVConstants.RADIOMETRY_CHILD_INDEX[j];
                            TreeNode level3RadiometryChildNode = level3ChildNode.getChildAt(k);
                            H5ScalarDS radiometryDS = this.getH5ScalarDS(level3RadiometryChildNode.getChildAt(0));
                            String level3RadiometryChildNodeName = level3RadiometryChildNode.toString();
                            String radiometryBandPrePrefix = ProbaVSynthesisProductReaderPlugIn.isProbaSynthesisToaProduct(inputFile.getName()) ? "TOA" : "TOC";
                            String radiometryBandPrefix = radiometryBandPrePrefix + "_REFL_";
                            Band radiometryBand = this.createTargetBand(product, radiometryDS, radiometryBandPrefix + level3RadiometryChildNodeName, 11);
                            this.setBandUnitAndDescription(radiometryDS, radiometryBand);
                            this.setSpectralBandProperties(radiometryBand);
                            radiometryBand.setNoDataValue(-1.0);
                            radiometryBand.setNoDataValueUsed(true);
                            String radiometryDatasetName = "/LEVEL3/RADIOMETRY/" + level3RadiometryChildNodeName + "/" + radiometryBandPrePrefix;
                            int radiometryDatatypeClass = radiometryDS.getDatatype().getDatatypeClass();
                            ProductData radiometryRasterData = ProbaVUtils.getProbaVRasterData(this.file_id, this.productWidth, this.productHeight, radiometryDatasetName, radiometryDatatypeClass);
                            RenderedImage radiometryImage = ImageUtils.createRenderedImage((int)this.productWidth, (int)this.productHeight, (ProductData)radiometryRasterData);
                            radiometryBand.setSourceImage(radiometryImage);
                        }
                        continue block14;
                    }
                    case "TIME": {
                        Band timeBand;
                        H5ScalarDS timeDS = this.getH5ScalarDS(level3ChildNode.getChildAt(0));
                        int timeDatatypeClass = timeDS.getDatatype().getDatatypeClass();
                        if (timeDatatypeClass == 2) {
                            timeBand = this.createTargetBand(product, timeDS, "TIME", 20);
                            timeBand.setNoDataValue(255.0);
                        } else {
                            timeBand = this.createTargetBand(product, timeDS, "TIME", 21);
                            timeBand.setNoDataValue(0.0);
                        }
                        this.setBandUnitAndDescription(timeDS, timeBand);
                        timeBand.setNoDataValueUsed(true);
                        String timeDatasetName = "/LEVEL3/TIME/TIME";
                        ProductData timeRasterData = ProbaVUtils.getProbaVRasterData(this.file_id, this.productWidth, this.productHeight, "/LEVEL3/TIME/TIME", timeDatatypeClass);
                        RenderedImage radiometryImage = ImageUtils.createRenderedImage((int)this.productWidth, (int)this.productHeight, (ProductData)timeRasterData);
                        timeBand.setSourceImage(radiometryImage);
                        this.addStartStopTimes(product, (DefaultMutableTreeNode)level3ChildNode);
                        continue block14;
                    }
                }
            }
        }
        return product;
    }

    private Product createTargetProductFromSynthesisNdvi(File inputFile, TreeNode inputFileRootNode) throws Exception {
        Product product = null;
        if (inputFileRootNode != null) {
            TreeNode level3Node = inputFileRootNode.getChildAt(0);
            this.productWidth = (int)this.getH5ScalarDS(level3Node.getChildAt(1).getChildAt(0)).getDims()[0];
            this.productHeight = (int)this.getH5ScalarDS(level3Node.getChildAt(1).getChildAt(0)).getDims()[1];
            product = new Product(inputFile.getName(), "PROBA-V SYNTHESIS NDVI", this.productWidth, this.productHeight);
            H5Group rootGroup = (H5Group)((DefaultMutableTreeNode)inputFileRootNode).getUserObject();
            List rootMetadata = rootGroup.getMetadata();
            this.addSynthesisMetadataElement(rootMetadata, product, "MPH");
            product.setDescription(ProbaVUtils.getStringAttributeValue(rootMetadata, "DESCRIPTION"));
            product.setFileLocation(inputFile);
            block12: for (int i = 0; i < level3Node.getChildCount(); ++i) {
                String level3ChildNodeName;
                TreeNode level3ChildNode = level3Node.getChildAt(i);
                switch (level3ChildNodeName = level3ChildNode.toString()) {
                    case "GEOMETRY": {
                        this.setSynthesisGeoCoding(product, inputFileRootNode, level3ChildNode);
                        continue block12;
                    }
                    case "NDVI": {
                        this.setNdviBand(product, level3ChildNode);
                        continue block12;
                    }
                    case "QUALITY": {
                        this.addQualityMetadata(product, (DefaultMutableTreeNode)level3ChildNode);
                        continue block12;
                    }
                    case "TIME": {
                        this.addStartStopTimes(product, (DefaultMutableTreeNode)level3ChildNode);
                        continue block12;
                    }
                }
            }
        }
        return product;
    }

    private void setNdviBand(Product product, TreeNode level3ChildNode) throws Exception {
        H5ScalarDS ndviDS = (H5ScalarDS)((DefaultMutableTreeNode)level3ChildNode.getChildAt(0)).getUserObject();
        Band ndviBand = this.createTargetBand(product, ndviDS, "NDVI", 20);
        ndviBand.setDescription("Normalized Difference Vegetation Index");
        ndviBand.setUnit("dl");
        ndviBand.setNoDataValue(Double.NaN);
        ndviBand.setNoDataValueUsed(true);
        String ndviDatasetName = "/LEVEL3/NDVI/NDVI";
        int ndviDatatypeClass = ndviDS.getDatatype().getDatatypeClass();
        ProductData ndviRasterData = ProbaVUtils.getProbaVRasterData(this.file_id, this.productWidth, this.productHeight, "/LEVEL3/NDVI/NDVI", ndviDatatypeClass);
        RenderedImage ndviImage = ImageUtils.createRenderedImage((int)this.productWidth, (int)this.productHeight, (ProductData)ndviRasterData);
        ndviBand.setSourceImage(ndviImage);
    }

    private void addStartStopTimes(Product product, DefaultMutableTreeNode level3ChildNode) throws HDF5Exception, ParseException {
        H5Group timeGroup = (H5Group)level3ChildNode.getUserObject();
        List timeMetadata = timeGroup.getMetadata();
        product.setStartTime(ProductData.UTC.parse((String)ProbaVUtils.getStartEndTimeFromAttributes(timeMetadata)[0], (String)"yyyy-MM-dd HH:mm:ss"));
        product.setEndTime(ProductData.UTC.parse((String)ProbaVUtils.getStartEndTimeFromAttributes(timeMetadata)[1], (String)"yyyy-MM-dd HH:mm:ss"));
    }

    private void addQualityMetadata(Product product, DefaultMutableTreeNode level3ChildNode) throws HDF5Exception {
        H5Group qualityGroup = (H5Group)level3ChildNode.getUserObject();
        List qualityMetadata = qualityGroup.getMetadata();
        this.addSynthesisMetadataElement(qualityMetadata, product, "QUALITY");
    }

    private void setBandUnitAndDescription(H5ScalarDS ds, Band band) throws HDF5Exception {
        band.setDescription(ProbaVUtils.getStringAttributeValue(ds.getMetadata(), "DESCRIPTION"));
        band.setUnit(ProbaVUtils.getStringAttributeValue(ds.getMetadata(), "UNITS"));
    }

    private void setSpectralBandProperties(Band band) {
        if (band.getName().endsWith("REFL_BLUE")) {
            band.setSpectralBandIndex(0);
            band.setSpectralWavelength(462.0f);
            band.setSpectralBandwidth(48.0f);
        } else if (band.getName().endsWith("REFL_RED")) {
            band.setSpectralBandIndex(1);
            band.setSpectralWavelength(655.5f);
            band.setSpectralBandwidth(81.0f);
        } else if (band.getName().endsWith("REFL_NIR")) {
            band.setSpectralBandIndex(2);
            band.setSpectralWavelength(843.0f);
            band.setSpectralBandwidth(142.0f);
        } else if (band.getName().endsWith("REFL_SWIR")) {
            band.setSpectralBandIndex(3);
            band.setSpectralWavelength(1599.0f);
            band.setSpectralBandwidth(70.0f);
        }
    }

    private void setSynthesisGeoCoding(Product product, TreeNode inputFileRootNode, TreeNode level3ChildNode) throws HDF5Exception {
        H5Group h5GeometryGroup = (H5Group)((DefaultMutableTreeNode)level3ChildNode).getUserObject();
        List geometryMetadata = h5GeometryGroup.getMetadata();
        double easting = ProbaVUtils.getFloatAttributeValue(geometryMetadata, "TOP_LEFT_LONGITUDE");
        double northing = ProbaVUtils.getFloatAttributeValue(geometryMetadata, "TOP_LEFT_LATITUDE");
        double topLeftLon = easting;
        double topRightLon = ProbaVUtils.getFloatAttributeValue(geometryMetadata, "TOP_RIGHT_LONGITUDE");
        double pixelSizeX = Math.abs(topRightLon - topLeftLon) / (double)this.productWidth;
        double topLeftLat = northing;
        double bottomLeftLat = ProbaVUtils.getFloatAttributeValue(geometryMetadata, "BOTTOM_LEFT_LATITUDE");
        double pixelSizeY = (topLeftLat - bottomLeftLat) / (double)this.productHeight;
        H5Group h5RootGroup = (H5Group)((DefaultMutableTreeNode)inputFileRootNode).getUserObject();
        List rootMetadata = h5RootGroup.getMetadata();
        String crsString = ProbaVUtils.getStringAttributeValue(rootMetadata, "MAP_PROJECTION_WKT");
        try {
            CoordinateReferenceSystem crs = CRS.parseWKT((String)crsString);
            CrsGeoCoding geoCoding = new CrsGeoCoding(crs, this.productWidth, this.productHeight, easting, northing, pixelSizeX, pixelSizeY);
            product.setSceneGeoCoding((GeoCoding)geoCoding);
        }
        catch (Exception e) {
            SystemUtils.LOG.log(Level.WARNING, "Cannot attach geocoding: " + e.getMessage());
        }
    }

    private static void attachSynthesisQualityFlagBand(Product probavProduct, Product flagProduct) {
        FlagCoding probavSmFlagCoding = new FlagCoding("SM_FLAGS");
        ProbaVUtils.addSynthesisQualityFlags(probavSmFlagCoding);
        ProbaVUtils.addSynthesisQualityMasks(probavProduct);
        probavProduct.getFlagCodingGroup().add((ProductNode)probavSmFlagCoding);
        Band smFlagBand = probavProduct.addBand("SM_FLAGS", 11);
        smFlagBand.setDescription("PROBA-V Synthesis SM Flags");
        smFlagBand.setSampleCoding((SampleCoding)probavSmFlagCoding);
        ProbaVSynthesisBitMaskOp bitMaskOp = new ProbaVSynthesisBitMaskOp();
        bitMaskOp.setParameterDefaultValues();
        bitMaskOp.setSourceProduct("sourceProduct", flagProduct);
        Product bitMaskProduct = bitMaskOp.getTargetProduct();
        smFlagBand.setSourceImage(bitMaskProduct.getBand("SM_FLAGS").getSourceImage());
    }

    private boolean isSynthesisViewAngleGroupNode(String level3GeometryChildNodeName) {
        return level3GeometryChildNodeName.equals("SWIR") || level3GeometryChildNodeName.equals("VNIR");
    }

    private boolean isSynthesisSunAngleDataNode(String level3GeometryChildNodeName) {
        return level3GeometryChildNodeName.equals("SAA") || level3GeometryChildNodeName.equals("SZA");
    }

    private Band createTargetBand(Product product, H5ScalarDS scalarDS, String bandName, int dataType) throws Exception {
        List metadata = scalarDS.getMetadata();
        float scaleFactorAttr = ProbaVUtils.getFloatAttributeValue(metadata, "SCALE");
        float scaleFactor = Float.isNaN(scaleFactorAttr) ? 1.0f : scaleFactorAttr;
        float scaleOffsetAttr = ProbaVUtils.getFloatAttributeValue(metadata, "OFFSET");
        float scaleOffset = Float.isNaN(scaleOffsetAttr) ? 0.0f : scaleOffsetAttr;
        Band band = product.addBand(bandName, dataType);
        band.setScalingFactor(1.0 / (double)scaleFactor);
        band.setScalingOffset(-1.0 * (double)scaleOffset / (double)scaleFactor);
        return band;
    }

    private H5ScalarDS getH5ScalarDS(TreeNode level3BandsChildNode) throws HDF5Exception {
        H5ScalarDS scalarDS = (H5ScalarDS)((DefaultMutableTreeNode)level3BandsChildNode).getUserObject();
        scalarDS.open();
        scalarDS.read();
        return scalarDS;
    }

    private void addSynthesisMetadataElement(List<Attribute> rootMetadata, Product product, String metadataElementName) {
        MetadataElement metadataElement = new MetadataElement(metadataElementName);
        for (Attribute attribute : rootMetadata) {
            metadataElement.addAttribute(new MetadataAttribute(attribute.getName(), ProductData.createInstance((String)ProbaVUtils.getAttributeValue(attribute)), true));
        }
        product.getMetadataRoot().addElement(metadataElement);
    }
}

