/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.probav;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.util.BitSetter;

@OperatorMetadata(alias="Probav.Synthesis.Bitmask", description="extracts and interprets the relevant bit information stored in SM mask", authors="Olaf Danne", version="1.0", copyright="(c) 2015 by Brockmann Consult", internal=true)
public class ProbaVSynthesisBitMaskOp
extends PixelOperator {
    private static final int SRC_FLAG = 0;
    private static final int TRG_FLAG = 0;
    @SourceProduct
    private Product sourceProduct;
    private static final String TARGET_FLAG_BAND_NAME = "SM_FLAGS";

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        Product targetProduct = productConfigurer.getTargetProduct();
        targetProduct.addBand(TARGET_FLAG_BAND_NAME, 11);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "SM");
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, TARGET_FLAG_BAND_NAME);
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        int srcFlagValue = sourceSamples[0].getInt();
        this.computeSynthesisSmMask(srcFlagValue, targetSamples);
    }

    private void computeSynthesisSmMask(int srcValue, WritableSample[] targetSamples) {
        targetSamples[0].set(0, this.isClear(srcValue));
        targetSamples[0].set(1, this.isUndefined(srcValue));
        targetSamples[0].set(2, this.isCloud(srcValue));
        targetSamples[0].set(3, this.isSnowIce(srcValue));
        targetSamples[0].set(4, this.isCloudShadow(srcValue));
        targetSamples[0].set(5, this.isLand(srcValue));
        targetSamples[0].set(6, this.isGoodSwir(srcValue));
        targetSamples[0].set(7, this.isGoodNir(srcValue));
        targetSamples[0].set(8, this.isGoodRed(srcValue));
        targetSamples[0].set(9, this.isGoodBlue(srcValue));
    }

    private boolean isClear(int srcValue) {
        return !BitSetter.isFlagSet((int)srcValue, (int)0) && !BitSetter.isFlagSet((int)srcValue, (int)1) && !BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private boolean isUndefined(int srcValue) {
        return !BitSetter.isFlagSet((int)srcValue, (int)0) && BitSetter.isFlagSet((int)srcValue, (int)1) && !BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private boolean isCloud(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)0) && BitSetter.isFlagSet((int)srcValue, (int)1) && !BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private boolean isSnowIce(int srcValue) {
        return !BitSetter.isFlagSet((int)srcValue, (int)0) && !BitSetter.isFlagSet((int)srcValue, (int)1) && BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private boolean isCloudShadow(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)0) && !BitSetter.isFlagSet((int)srcValue, (int)1) && !BitSetter.isFlagSet((int)srcValue, (int)2);
    }

    private boolean isLand(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)3);
    }

    private boolean isGoodSwir(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)4);
    }

    private boolean isGoodNir(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)5);
    }

    private boolean isGoodRed(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)6);
    }

    private boolean isGoodBlue(int srcValue) {
        return BitSetter.isFlagSet((int)srcValue, (int)7);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ProbaVSynthesisBitMaskOp.class);
        }
    }
}

