/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.owt;

import org.esa.s3tbx.owt.AuxdataFactory;
import org.esa.s3tbx.owt.CoastalAuxdataFactory;
import org.esa.s3tbx.owt.HyperspectralAuxdataFactory;

public enum OWT_TYPE {
    COASTAL{
        private float[] wavelength = new float[]{410.0f, 443.0f, 490.0f, 510.0f, 555.0f};

        @Override
        AuxdataFactory getAuxdataFactory() {
            return new CoastalAuxdataFactory("/auxdata/coastal/owt16_meris_stats_101119_5band.hdf");
        }

        @Override
        int getClassCount() {
            return 9;
        }

        @Override
        double[] mapMembershipsToClasses(double[] memberships) {
            double[] classes = new double[this.getClassCount()];
            System.arraycopy(memberships, 0, classes, 0, 8);
            for (int i = 8; i < memberships.length; ++i) {
                classes[8] = classes[8] + memberships[i];
            }
            return classes;
        }

        @Override
        float[] getWavelengths() {
            return this.wavelength;
        }
    }
    ,
    INLAND{
        private final float[] ALL_WAVELENGTHS = new float[]{412.0f, 443.0f, 490.0f, 510.0f, 531.0f, 547.0f, 555.0f, 560.0f, 620.0f, 665.0f, 667.0f, 670.0f, 678.0f, 680.0f, 709.0f, 748.0f, 754.0f};
        private final String COVARIANCE_MATRIX_RESOURCE = "/auxdata/inland/rrs_owt_cov_inland.hdf";
        private final String SPECTRAL_MEANS_RESOURCE = "/auxdata/inland/rrs_owt_means_inland.hdf";
        private String covariance = "rrs_cov";
        private String owt_means = "class_means";
        private float[] wavelength = new float[]{412.0f, 443.0f, 490.0f, 510.0f, 560.0f, 620.0f, 665.0f, 680.0f, 709.0f, 754.0f};

        @Override
        AuxdataFactory getAuxdataFactory() {
            return new HyperspectralAuxdataFactory(this.wavelength, this.ALL_WAVELENGTHS, 10.0f, "/auxdata/inland/rrs_owt_cov_inland.hdf", this.covariance, "/auxdata/inland/rrs_owt_means_inland.hdf", this.owt_means);
        }

        @Override
        float[] getWavelengths() {
            return this.wavelength;
        }

        @Override
        int getClassCount() {
            return 7;
        }
    }
    ,
    INLAND_NO_BLUE_BAND{
        private final float[] ALL_WAVELENGTHS = new float[]{412.0f, 443.0f, 490.0f, 510.0f, 531.0f, 547.0f, 555.0f, 560.0f, 620.0f, 665.0f, 667.0f, 670.0f, 678.0f, 680.0f, 709.0f, 748.0f, 754.0f};
        private final String COVARIANCE_MATRIX_RESOURCE = "/auxdata/inland/rrs_owt_cov_inland.hdf";
        private final String SPECTRAL_MEANS_RESOURCE = "/auxdata/inland/rrs_owt_means_inland.hdf";
        private String covariance = "rrs_cov";
        private String owt_means = "class_means";
        private float[] wavelength = new float[]{443.0f, 490.0f, 510.0f, 560.0f, 620.0f, 665.0f, 680.0f, 709.0f, 754.0f};

        @Override
        AuxdataFactory getAuxdataFactory() {
            return new HyperspectralAuxdataFactory(this.wavelength, this.ALL_WAVELENGTHS, 10.0f, "/auxdata/inland/rrs_owt_cov_inland.hdf", this.covariance, "/auxdata/inland/rrs_owt_means_inland.hdf", this.owt_means);
        }

        @Override
        float[] getWavelengths() {
            return this.wavelength;
        }

        @Override
        int getClassCount() {
            return 7;
        }
    }
    ,
    GLASS_5C{
        private final float[] ALL_WAVELENGTHS = new float[]{400.0f, 403.0f, 406.0f, 409.0f, 412.0f, 415.0f, 418.0f, 421.0f, 424.0f, 427.0f, 430.0f, 433.0f, 436.0f, 439.0f, 442.0f, 445.0f, 448.0f, 451.0f, 454.0f, 457.0f, 460.0f, 463.0f, 466.0f, 469.0f, 472.0f, 475.0f, 478.0f, 481.0f, 484.0f, 487.0f, 490.0f, 493.0f, 496.0f, 499.0f, 502.0f, 505.0f, 508.0f, 511.0f, 514.0f, 517.0f, 520.0f, 523.0f, 526.0f, 529.0f, 532.0f, 535.0f, 538.0f, 541.0f, 544.0f, 547.0f, 550.0f, 553.0f, 556.0f, 559.0f, 562.0f, 565.0f, 568.0f, 571.0f, 574.0f, 577.0f, 580.0f, 583.0f, 586.0f, 589.0f, 592.0f, 595.0f, 598.0f, 601.0f, 604.0f, 607.0f, 610.0f, 613.0f, 616.0f, 619.0f, 622.0f, 625.0f, 628.0f, 631.0f, 634.0f, 637.0f, 640.0f, 643.0f, 646.0f, 649.0f, 652.0f, 655.0f, 658.0f, 661.0f, 664.0f, 667.0f, 670.0f, 673.0f, 676.0f, 679.0f, 682.0f, 685.0f, 688.0f, 691.0f, 694.0f, 697.0f, 700.0f, 703.0f, 706.0f, 709.0f, 712.0f, 715.0f, 718.0f, 721.0f, 724.0f, 727.0f, 730.0f, 733.0f, 736.0f, 739.0f, 742.0f, 745.0f, 748.0f, 751.0f, 754.0f, 757.0f, 760.0f, 763.0f, 766.0f, 769.0f, 772.0f, 775.0f, 778.0f, 781.0f, 784.0f, 787.0f, 790.0f, 793.0f, 796.0f, 799.0f};
        private final float MAX_DISTANCE = 1.5f;
        private float[] wavelength = new float[]{442.6f, 489.9f, 509.8f, 559.7f, 619.6f, 664.6f, 680.8f, 708.3f, 753.4f};
        private String auxdataResource = "/auxdata/glass/Rrs_Glass_5C_owt_stats_140912.hdf";
        private String covariance = "covariance";
        private String owt_means = "owt_means";

        @Override
        AuxdataFactory getAuxdataFactory() {
            return new HyperspectralAuxdataFactory(this.wavelength, this.ALL_WAVELENGTHS, 1.5f, this.auxdataResource, this.covariance, this.auxdataResource, this.owt_means);
        }

        @Override
        int getClassCount() {
            return 5;
        }

        @Override
        float[] getWavelengths() {
            return this.wavelength;
        }
    }
    ,
    GLASS_6C{
        private final float[] ALL_WAVELENGTHS = new float[]{400.0f, 403.0f, 406.0f, 409.0f, 412.0f, 415.0f, 418.0f, 421.0f, 424.0f, 427.0f, 430.0f, 433.0f, 436.0f, 439.0f, 442.0f, 445.0f, 448.0f, 451.0f, 454.0f, 457.0f, 460.0f, 463.0f, 466.0f, 469.0f, 472.0f, 475.0f, 478.0f, 481.0f, 484.0f, 487.0f, 490.0f, 493.0f, 496.0f, 499.0f, 502.0f, 505.0f, 508.0f, 511.0f, 514.0f, 517.0f, 520.0f, 523.0f, 526.0f, 529.0f, 532.0f, 535.0f, 538.0f, 541.0f, 544.0f, 547.0f, 550.0f, 553.0f, 556.0f, 559.0f, 562.0f, 565.0f, 568.0f, 571.0f, 574.0f, 577.0f, 580.0f, 583.0f, 586.0f, 589.0f, 592.0f, 595.0f, 598.0f, 601.0f, 604.0f, 607.0f, 610.0f, 613.0f, 616.0f, 619.0f, 622.0f, 625.0f, 628.0f, 631.0f, 634.0f, 637.0f, 640.0f, 643.0f, 646.0f, 649.0f, 652.0f, 655.0f, 658.0f, 661.0f, 664.0f, 667.0f, 670.0f, 673.0f, 676.0f, 679.0f, 682.0f, 685.0f, 688.0f, 691.0f, 694.0f, 697.0f, 700.0f, 703.0f, 706.0f, 709.0f, 712.0f, 715.0f, 718.0f, 721.0f, 724.0f, 727.0f, 730.0f, 733.0f, 736.0f, 739.0f, 742.0f, 745.0f, 748.0f, 751.0f, 754.0f, 757.0f, 760.0f, 763.0f, 766.0f, 769.0f, 772.0f, 775.0f, 778.0f, 781.0f, 784.0f, 787.0f, 790.0f, 793.0f, 796.0f, 799.0f};
        private final float MAX_DISTANCE = 1.5f;
        private float[] wavelength = new float[]{442.6f, 489.9f, 509.8f, 559.7f, 619.6f, 664.6f, 680.8f, 708.3f, 753.4f};
        private String auxdataResource = "/auxdata/glass/Rrs_Glass_6C_owt_stats_140912.hdf";
        private String covariance = "covariance";
        private String owt_means = "owt_means";

        @Override
        AuxdataFactory getAuxdataFactory() {
            return new HyperspectralAuxdataFactory(this.wavelength, this.ALL_WAVELENGTHS, 1.5f, this.auxdataResource, this.covariance, this.auxdataResource, this.owt_means);
        }

        @Override
        int getClassCount() {
            return 6;
        }

        @Override
        float[] getWavelengths() {
            return this.wavelength;
        }
    }
    ,
    GLASS_6C_NORMALISED{
        private final float[] ALL_WAVELENGTHS = new float[]{442.0f, 490.0f, 511.0f, 559.0f, 619.0f, 664.0f, 682.0f, 709.0f, 754.0f};
        private final float MAX_DISTANCE = 1.5f;
        private float[] wavelength = new float[]{442.6f, 489.9f, 509.8f, 559.7f, 619.6f, 664.6f, 680.8f, 708.3f, 753.4f};
        private String auxdataResource = "/auxdata/glass/Rrs_Glass_norm6C_owt_stats_140918.hdf";
        private String covariance = "inverted_covariance";
        private String owt_means = "owt_means";

        @Override
        AuxdataFactory getAuxdataFactory() {
            return new HyperspectralAuxdataFactory(this.wavelength, this.ALL_WAVELENGTHS, 1.5f, this.auxdataResource, this.covariance, false, this.auxdataResource, this.owt_means);
        }

        @Override
        int getClassCount() {
            return 6;
        }

        @Override
        float[] getWavelengths() {
            return this.wavelength;
        }

        @Override
        boolean mustNormalizeSpectra() {
            return true;
        }
    };


    abstract AuxdataFactory getAuxdataFactory();

    abstract float[] getWavelengths();

    abstract int getClassCount();

    double[] mapMembershipsToClasses(double[] memberships) {
        return memberships;
    }

    boolean mustNormalizeSpectra() {
        return false;
    }
}

