/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.owt;

import org.esa.s3tbx.owt.Auxdata;
import org.esa.s3tbx.owt.AuxdataException;
import org.esa.s3tbx.owt.AuxdataFactory;
import org.esa.s3tbx.owt.OWTClassification;
import org.esa.s3tbx.owt.OWTException;
import org.esa.s3tbx.owt.OWT_TYPE;
import org.esa.s3tbx.owt.ReflectanceEnum;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorCancelException;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.pointop.PixelOperator;
import org.esa.snap.core.gpf.pointop.ProductConfigurer;
import org.esa.snap.core.gpf.pointop.Sample;
import org.esa.snap.core.gpf.pointop.SourceSampleConfigurer;
import org.esa.snap.core.gpf.pointop.TargetSampleConfigurer;
import org.esa.snap.core.gpf.pointop.WritableSample;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="OWTClassification", category="Optical/Thematic Water Processing", description="Performs an optical water type classification based on atmospherically corrected reflectances.", authors="Timothy Moore (University of New Hampshire); Marco Peters, Thomas Storm (Brockmann Consult)", copyright="(c) 2016 by Timothy Moore (University of New Hampshire) and Brockmann Consult", version="2.1")
public class OWTClassificationOp
extends PixelOperator {
    private static final int DOMINANT_CLASS_NO_DATA_VALUE = -1;
    private static final int CLASS_SUM_NO_DATA_VALUE = -1;
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @Parameter(label="OWT Type", defaultValue="COASTAL")
    private OWT_TYPE owtType;
    @Parameter(defaultValue="reflec")
    private String reflectancesPrefix;
    @Parameter(defaultValue="RADIANCE_REFLECTANCES")
    private ReflectanceEnum inputReflectanceIs;
    @Parameter(defaultValue="false")
    private boolean writeInputReflectances;
    private OWTClassification owtClassification;
    private Auxdata auxdata;

    private void setTargetSamplesToInvalid(WritableSample[] targetSamples, int numClassSamples) {
        for (int i = 0; i < numClassSamples; ++i) {
            targetSamples[i].set(Double.NaN);
        }
        targetSamples[numClassSamples].set(-1);
        targetSamples[numClassSamples + 1].set(-1);
    }

    private void normalizeSpectra(double[] rrsBelowWater) {
        double[] wls = new double[this.owtType.getWavelengths().length];
        for (int i = 0; i < wls.length; ++i) {
            wls[i] = this.owtType.getWavelengths()[i];
        }
        double integral = OWTClassificationOp.trapz(wls, rrsBelowWater);
        int i = 0;
        while (i < rrsBelowWater.length) {
            int n = i++;
            rrsBelowWater[n] = rrsBelowWater[n] / integral;
        }
    }

    private void addClassBands(String bandNamePrefix, Product targetProduct) {
        for (int i = 1; i <= this.owtType.getClassCount(); ++i) {
            Band classBand = targetProduct.addBand(bandNamePrefix + i, 30);
            classBand.setValidPixelExpression(classBand.getName() + " > 0.0");
        }
    }

    private String getSourceBandName(String reflectancesPrefix, float wavelength) {
        Band[] bands = this.sourceProduct.getBands();
        String bestBandName = OWTClassificationOp.getBestBandName(reflectancesPrefix, wavelength, bands);
        if (bestBandName == null) {
            throw new OperatorCancelException(String.format("Not able to find band with prefix '%s' and wavelength '%4.3f'.", reflectancesPrefix, Float.valueOf(wavelength)));
        }
        return bestBandName;
    }

    private static boolean mustDefineTargetSample(Band band) {
        return !band.isSourceImageSet();
    }

    private boolean areSourceSamplesValid(int x, int y, Sample[] sourceSamples) {
        if (!this.sourceProduct.containsPixel((double)x, (double)y)) {
            return false;
        }
        for (Sample sourceSample : sourceSamples) {
            if (!sourceSample.getNode().isPixelValid(x, y)) {
                return false;
            }
            if (!Double.isNaN(sourceSample.getDouble())) continue;
            return false;
        }
        return true;
    }

    private double convertToSubsurfaceWaterRrs(double merisL2Reflec) {
        double rrsAboveWater = merisL2Reflec / Math.PI;
        return rrsAboveWater / (0.52 + 1.7 * rrsAboveWater);
    }

    static double trapz(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 1; i < x.length; ++i) {
            sum += 0.5 * (x[i] - x[i - 1]) * (y[i] + y[i - 1]);
        }
        return sum;
    }

    static double[] normalizeClassMemberships(double[] memberships) {
        double[] result = new double[memberships.length];
        double sum = 0.0;
        for (double membership : memberships) {
            sum += membership;
        }
        for (int i = 0; i < memberships.length; ++i) {
            result[i] = memberships[i] / sum;
        }
        return result;
    }

    static String getBestBandName(String reflectancesPrefix, float wavelength, Band[] bands) {
        String bestBandName = null;
        double maxDistance = 10.0;
        double wavelengthDist = Double.MAX_VALUE;
        for (Band band : bands) {
            float currentWavelengthDist;
            boolean isSpectralBand;
            float spectralWavelength = band.getSpectralWavelength();
            boolean bl = isSpectralBand = spectralWavelength > 0.0f;
            if (!isSpectralBand || !band.getName().startsWith(reflectancesPrefix) || !((double)(currentWavelengthDist = Math.abs(spectralWavelength - wavelength)) < wavelengthDist) || !((double)currentWavelengthDist < maxDistance)) continue;
            wavelengthDist = currentWavelengthDist;
            bestBandName = band.getName();
        }
        return bestBandName;
    }

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        if (this.sourceProduct.getDescription() != null && this.sourceProduct.getDescription().contains("IRRADIANCE_REFLECTANCES")) {
            this.inputReflectanceIs = ReflectanceEnum.IRRADIANCE_REFLECTANCES;
        }
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        AuxdataFactory auxdataFactory = this.owtType.getAuxdataFactory();
        try {
            this.auxdata = auxdataFactory.createAuxdata();
        }
        catch (AuxdataException e) {
            throw new OperatorException("Unable to initialise auxdata\n" + e.getMessage(), (Throwable)e);
        }
        Product targetProduct = productConfigurer.getTargetProduct();
        this.addClassBands("class_", targetProduct);
        this.addClassBands("norm_class_", targetProduct);
        Band domClassBand = targetProduct.addBand("dominant_class", 10);
        domClassBand.setNoDataValue(-1.0);
        domClassBand.setNoDataValueUsed(true);
        IndexCoding indexCoding = new IndexCoding("Dominant_Classes");
        for (int i = 1; i <= this.owtType.getClassCount(); ++i) {
            String name = "class_" + i;
            indexCoding.addIndex(name, i, "Class " + i);
        }
        targetProduct.getIndexCodingGroup().add((ProductNode)indexCoding);
        domClassBand.setSampleCoding((SampleCoding)indexCoding);
        Band sumBand = targetProduct.addBand("class_sum", 30);
        sumBand.setValidPixelExpression(sumBand.getName() + " > 0.0");
        if (this.writeInputReflectances) {
            float[] wavelengths;
            for (float wavelength : wavelengths = this.owtType.getWavelengths()) {
                String bandName = this.getSourceBandName(this.reflectancesPrefix, wavelength);
                ProductUtils.copyBand((String)bandName, (Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
            }
            if (this.owtType.mustNormalizeSpectra()) {
                for (float wavelength : wavelengths) {
                    String sourceBandName = this.getSourceBandName(this.reflectancesPrefix, wavelength);
                    String targetBandName = "norm_" + sourceBandName;
                    ProductUtils.copyBand((String)sourceBandName, (Product)this.sourceProduct, (String)targetBandName, (Product)targetProduct, (boolean)false);
                }
            }
        }
        targetProduct.setAutoGrouping("reflec:norm_reflec:class:norm_class");
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
    }

    protected void configureSourceSamples(SourceSampleConfigurer sampleConfigurer) throws OperatorException {
        this.owtClassification = new OWTClassification(this.auxdata.getSpectralMeans(), this.auxdata.getInvertedCovarianceMatrices());
        float[] wavelengths = this.owtType.getWavelengths();
        for (int i = 0; i < wavelengths.length; ++i) {
            String bandName = this.getSourceBandName(this.reflectancesPrefix, wavelengths[i]);
            sampleConfigurer.defineSample(i, bandName);
        }
    }

    protected void configureTargetSamples(TargetSampleConfigurer sampleConfigurer) throws OperatorException {
        Band[] bands = this.getTargetProduct().getBands();
        int targetSampleIndex = 0;
        for (Band band : bands) {
            if (!OWTClassificationOp.mustDefineTargetSample(band)) continue;
            sampleConfigurer.defineSample(targetSampleIndex, band.getName());
            ++targetSampleIndex;
        }
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        int i;
        double[] classMemberships;
        int numWLs = this.owtType.getWavelengths().length;
        if (sourceSamples.length != numWLs) {
            throw new OperatorException("Wrong number of source samples: Expected: " + numWLs + ", Actual: " + sourceSamples.length);
        }
        int numClassSamples = this.owtType.getClassCount() * 2;
        if (!this.areSourceSamplesValid(x, y, sourceSamples)) {
            this.setTargetSamplesToInvalid(targetSamples, numClassSamples);
            return;
        }
        double[] rrsBelowWater = new double[numWLs];
        for (int i2 = 0; i2 < numWLs; ++i2) {
            rrsBelowWater[i2] = this.convertToSubsurfaceWaterRrs(sourceSamples[i2].getDouble());
            if (this.inputReflectanceIs != ReflectanceEnum.IRRADIANCE_REFLECTANCES) continue;
            int n = i2;
            rrsBelowWater[n] = rrsBelowWater[n] / Math.PI;
        }
        if (this.owtType.mustNormalizeSpectra()) {
            this.normalizeSpectra(rrsBelowWater);
        }
        try {
            classMemberships = this.owtClassification.computeClassMemberships(rrsBelowWater);
        }
        catch (OWTException e) {
            this.setTargetSamplesToInvalid(targetSamples, numClassSamples);
            return;
        }
        double[] classes = this.owtType.mapMembershipsToClasses(classMemberships);
        for (int i3 = 0; i3 < classes.length; ++i3) {
            targetSamples[i3].set(classes[i3]);
        }
        double[] normClassMemberships = OWTClassificationOp.normalizeClassMemberships(classMemberships);
        double[] normClasses = this.owtType.mapMembershipsToClasses(normClassMemberships);
        for (int i4 = 0; i4 < classes.length; ++i4) {
            targetSamples[this.owtType.getClassCount() + i4].set(normClasses[i4]);
        }
        int dominantClass = -1;
        double dominantClassValue = Double.MIN_VALUE;
        double classSum = 0.0;
        for (i = 0; i < this.owtType.getClassCount(); ++i) {
            double currentClassValue = targetSamples[i].getDouble();
            if (currentClassValue > dominantClassValue) {
                dominantClassValue = currentClassValue;
                dominantClass = i + 1;
            }
            classSum += currentClassValue;
        }
        targetSamples[numClassSamples].set(dominantClass);
        targetSamples[numClassSamples + 1].set(classSum);
        if (this.writeInputReflectances && this.owtType.mustNormalizeSpectra()) {
            for (i = 0; i < rrsBelowWater.length; ++i) {
                targetSamples[numClassSamples + 2 + i].set(rrsBelowWater[i]);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(OWTClassificationOp.class);
        }
    }
}

