/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.owt;

import Jama.Matrix;
import com.bc.ceres.core.Assert;
import org.esa.s3tbx.owt.OWTException;

public class OWTClassification {
    private final double[][] uReflecMeans;
    private final double[][][] invCovMatrix;
    private int wavelengthCount;
    private int classCount;

    public OWTClassification(double[][] reflectanceMeans, double[][][] invertedClassCovMatrix) {
        this.wavelengthCount = reflectanceMeans.length;
        this.classCount = reflectanceMeans[0].length;
        String pattern = "Number of %s of reflectanceMeans [%d] and invertedClassCovMatrix [%d] do not match.";
        Assert.argument((invertedClassCovMatrix.length == this.classCount ? 1 : 0) != 0, (String)String.format("Number of %s of reflectanceMeans [%d] and invertedClassCovMatrix [%d] do not match.", "classes", this.classCount, invertedClassCovMatrix.length));
        Assert.argument((invertedClassCovMatrix[0].length == this.wavelengthCount ? 1 : 0) != 0, (String)String.format("Number of %s of reflectanceMeans [%d] and invertedClassCovMatrix [%d] do not match.", "wavelength", this.wavelengthCount, invertedClassCovMatrix[0].length));
        this.uReflecMeans = (double[][])reflectanceMeans.clone();
        this.invCovMatrix = (double[][][])invertedClassCovMatrix.clone();
    }

    public int getWavelengthCount() {
        return this.wavelengthCount;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public double[] computeClassMemberships(double[] reflectances) throws OWTException {
        String pattern = "Number of reflectances must be %d but is %d.";
        Assert.argument((reflectances.length == this.wavelengthCount ? 1 : 0) != 0, (String)String.format("Number of reflectances must be %d but is %d.", this.wavelengthCount, reflectances.length));
        double[] y = new double[this.wavelengthCount];
        double[][] yInvers = new double[this.wavelengthCount][this.wavelengthCount];
        double[] alphaChi = new double[this.classCount];
        for (int i = 0; i < this.classCount; ++i) {
            double gamma;
            for (int j = 0; j < this.wavelengthCount; ++j) {
                y[j] = reflectances[j] - this.uReflecMeans[j][i];
                System.arraycopy(this.invCovMatrix[i][j], 0, yInvers[j], 0, this.wavelengthCount);
            }
            Matrix yInvMatrix = new Matrix(yInvers);
            Matrix matrixB = yInvMatrix.times(new Matrix(y, y.length));
            double zSquare = 0.0;
            for (int j = 0; j < this.wavelengthCount; ++j) {
                zSquare += y[j] * matrixB.getArray()[j][0];
            }
            double x = zSquare / 2.0;
            double chiSquare = (double)this.wavelengthCount / 2.0;
            if (x <= chiSquare + 1.0) {
                gamma = OWTClassification.computeIGFSeries(chiSquare, x);
                alphaChi[i] = 1.0 - gamma;
                continue;
            }
            alphaChi[i] = gamma = OWTClassification.computeIGFContinuedFraction(chiSquare, x);
        }
        return alphaChi;
    }

    private static double computeIGFContinuedFraction(double a, double x) throws OWTException {
        double d;
        double min = 1.0E-30;
        double constFactor = Math.exp(-x + a * Math.log(x) - OWTClassification.logGamma(a));
        double b = x + 1.0 - a;
        double c = 9.999999999999999E29;
        double h = d = 1.0 / b;
        for (int i = 1; i <= 100; ++i) {
            double an = (double)(-i) * ((double)i - a);
            d = an * d + (b += 2.0);
            c = b + an / c;
            if (Math.abs(d) < 1.0E-30) {
                d = 1.0E-30;
            }
            if (Math.abs(c) < 1.0E-30) {
                c = 1.0E-30;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (!(Math.abs(del - 1.0) < 3.0E-7)) continue;
            return constFactor * h;
        }
        throw new OWTException("Parameter 'a' is too large");
    }

    private static double computeIGFSeries(double a, double x) throws OWTException {
        if (x < 0.0) {
            throw new OWTException("x must be greater or equal to zero");
        }
        if (x > 0.0) {
            double sum;
            double incA = a;
            double del = sum = 1.0 / a;
            int maxIteration = 100;
            double eps = 3.0E-7;
            double constFactor = Math.exp(-x + a * Math.log(x) - OWTClassification.logGamma(a));
            for (int i = 1; i <= 100; ++i) {
                sum += (del *= x / (incA += 1.0));
                if (!(Math.abs(del) < Math.abs(sum) * 3.0E-7)) continue;
                return sum * constFactor;
            }
            throw new OWTException("Parameter 'a' is too large");
        }
        return 0.0;
    }

    private static double logGamma(double x) {
        double[] coefficients = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double tempX = x;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double sum = 1.000000000190015;
        for (int i = 0; i <= 5; ++i) {
            sum += coefficients[i] / (tempX += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * sum / x);
    }
}

