/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.owt;

import org.esa.s3tbx.owt.Auxdata;
import org.esa.s3tbx.owt.AuxdataException;
import org.esa.s3tbx.owt.AuxdataFactory;
import ucar.ma2.Array;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class HyperspectralAuxdataFactory
extends AuxdataFactory {
    private String covarianceMatrixResource;
    private String covarianceVarName;
    private boolean covNeedsInversion;
    private String spectralMeansResource;
    private String spectralMeansVarName;
    private int[] wlIndices;

    public HyperspectralAuxdataFactory(float[] useWavelengths, float[] allWavelengths, float maxDistance, String covarianceMatrixResource, String covarianceVarName, String spectralMeansResource, String spectralMeansVarName) {
        this(useWavelengths, allWavelengths, maxDistance, covarianceMatrixResource, covarianceVarName, true, spectralMeansResource, spectralMeansVarName);
    }

    public HyperspectralAuxdataFactory(float[] useWavelengths, float[] allWavelengths, float maxDistance, String covarianceMatrixResource, String covarianceVarName, boolean covNeedsInversion, String spectralMeansResource, String spectralMeansVarName) {
        this.spectralMeansVarName = spectralMeansVarName;
        this.spectralMeansResource = spectralMeansResource;
        this.wlIndices = HyperspectralAuxdataFactory.findWavelengthIndices(useWavelengths, allWavelengths, maxDistance);
        this.covarianceMatrixResource = covarianceMatrixResource;
        this.covarianceVarName = covarianceVarName;
        this.covNeedsInversion = covNeedsInversion;
    }

    @Override
    public Auxdata createAuxdata() throws AuxdataException {
        double[][] spectralMeans = this.loadSpectralMeans();
        double[][][] invCovarianceMatrix = this.loadInvCovarianceMatrix();
        if (spectralMeans == null || invCovarianceMatrix == null) {
            throw new AuxdataException("Could not load auxiliary data");
        }
        return new Auxdata(spectralMeans, invCovarianceMatrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[][][] loadInvCovarianceMatrix() throws AuxdataException {
        double[][][] invCovarianceMatrix = null;
        try (NetcdfFile covMatrixFile = this.loadFile(this.covarianceMatrixResource);){
            Group rootGroup = covMatrixFile.getRootGroup();
            Variable covarianceVariable = rootGroup.findVariable(this.covarianceVarName);
            if (covarianceVariable == null) {
                throw new AuxdataException(String.format("Variable with name '%s' could not be found", this.covarianceVarName));
            }
            Array arrayDouble = this.getDoubleArray(covarianceVariable);
            double[][][] matrix = (double[][][])arrayDouble.copyToNDJavaArray();
            double[][][] redMatrix = HyperspectralAuxdataFactory.reduceCovarianceMatrixToWLs(matrix, this.wlIndices);
            invCovarianceMatrix = this.covNeedsInversion ? HyperspectralAuxdataFactory.invertMatrix(redMatrix) : redMatrix;
        }
        catch (Exception e) {
            throw new AuxdataException("Could not load auxiliary data", e);
        }
        return invCovarianceMatrix;
    }

    static double[][][] reduceCovarianceMatrixToWLs(double[][][] covarianceMatrix, int[] useIndices) {
        double[][][] reducedMatrix = new double[covarianceMatrix.length][useIndices.length][useIndices.length];
        for (int i = 0; i < covarianceMatrix.length; ++i) {
            double[][] innerCovarianceMatrix = covarianceMatrix[i];
            for (int j = 0; j < useIndices.length; ++j) {
                double[] innerArray = innerCovarianceMatrix[useIndices[j]];
                for (int k = 0; k < useIndices.length; ++k) {
                    reducedMatrix[i][j][k] = innerArray[useIndices[k]];
                }
            }
        }
        return reducedMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[][] loadSpectralMeans() throws AuxdataException {
        double[][] spectralMeans = null;
        try (NetcdfFile specMeansFile = this.loadFile(this.spectralMeansResource);){
            Group rootGroup = specMeansFile.getRootGroup();
            Variable specMeansVariable = rootGroup.findVariable(this.spectralMeansVarName);
            if (specMeansVariable == null) {
                throw new AuxdataException(String.format("Variable with name '%s' could not be found", this.spectralMeansVarName));
            }
            Array arrayDouble = this.getDoubleArray(specMeansVariable);
            double[][] allSpectralMeans = (double[][])arrayDouble.copyToNDJavaArray();
            spectralMeans = HyperspectralAuxdataFactory.reduceSpectralMeansToWLs(allSpectralMeans, this.wlIndices);
        }
        catch (Exception e) {
            throw new AuxdataException("Could not load auxiliary data", e);
        }
        return spectralMeans;
    }

    static double[][] reduceSpectralMeansToWLs(double[][] spectralMeans, int[] useIndices) {
        double[][] reducedSpectralMeans = new double[useIndices.length][];
        for (int i = 0; i < useIndices.length; ++i) {
            reducedSpectralMeans[i] = spectralMeans[useIndices[i]];
        }
        return reducedSpectralMeans;
    }
}

