/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.owt;

import java.util.List;
import org.esa.s3tbx.owt.Auxdata;
import org.esa.s3tbx.owt.AuxdataException;
import org.esa.s3tbx.owt.AuxdataFactory;
import ucar.ma2.Array;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class CoastalAuxdataFactory
extends AuxdataFactory {
    private final String resourcePath;

    public CoastalAuxdataFactory(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Auxdata createAuxdata() throws AuxdataException {
        Auxdata auxdata;
        NetcdfFile netcdfFile = this.loadFile(this.resourcePath);
        try {
            Group rootGroup = netcdfFile.getRootGroup();
            List variableList = rootGroup.getVariables();
            double[][] spectralMeans = null;
            double[][][] invCovarianceMatrix = null;
            for (Variable variable : variableList) {
                Array arrayDouble;
                if ("class_means".equals(variable.getFullName())) {
                    arrayDouble = this.getDoubleArray(variable);
                    spectralMeans = (double[][])arrayDouble.copyToNDJavaArray();
                }
                if ("class_covariance".equals(variable.getFullName()) || "Yinv".equals(variable.getFullName())) {
                    arrayDouble = this.getDoubleArray(variable);
                    invCovarianceMatrix = CoastalAuxdataFactory.invertMatrix((double[][][])arrayDouble.copyToNDJavaArray());
                }
                if (spectralMeans == null || invCovarianceMatrix == null) continue;
                break;
            }
            auxdata = new Auxdata(spectralMeans, invCovarianceMatrix);
        }
        catch (Throwable throwable) {
            try {
                netcdfFile.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new AuxdataException("Could not load auxiliary data", e);
            }
        }
        netcdfFile.close();
        return auxdata;
    }
}

