/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.owt;

import Jama.Matrix;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.esa.s3tbx.owt.Auxdata;
import org.esa.s3tbx.owt.AuxdataException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public abstract class AuxdataFactory {
    protected static int[] findWavelengthIndices(float[] useWavelengths, float[] allWavelengths, float maxDistance) {
        ArrayList<Integer> wavelengthIdxList = new ArrayList<Integer>();
        for (float useWavelength : useWavelengths) {
            int bestIndex = -1;
            double lastDelta = Double.MAX_VALUE;
            for (int i = 0; i < allWavelengths.length; ++i) {
                float delta = Math.abs(useWavelength - allWavelengths[i]);
                if (delta <= maxDistance && (double)delta <= lastDelta) {
                    bestIndex = i;
                } else if ((double)delta > lastDelta) break;
                lastDelta = delta;
            }
            if (bestIndex == -1) {
                String msg = String.format("Could not find appropriate wavelength (%.3f) in auxiliary data", Float.valueOf(useWavelength));
                throw new IllegalStateException(msg);
            }
            wavelengthIdxList.add(bestIndex);
        }
        int[] result = new int[wavelengthIdxList.size()];
        for (int i = 0; i < wavelengthIdxList.size(); ++i) {
            result[i] = (Integer)wavelengthIdxList.get(i);
        }
        return result;
    }

    abstract Auxdata createAuxdata() throws AuxdataException;

    protected Array getDoubleArray(Variable variable) throws IOException, InvalidRangeException {
        int[] origin = new int[variable.getRank()];
        int[] shape = variable.getShape();
        Array array = variable.read(new Section(origin, shape));
        return Array.factory((DataType)DataType.DOUBLE, (int[])shape, (Object)array.get1DJavaArray(Double.class));
    }

    protected static double[][][] invertMatrix(double[][][] matrix) {
        double[][][] invMatrix = new double[matrix.length][][];
        for (int i = 0; i < matrix.length; ++i) {
            Matrix tempMatrix = new Matrix(matrix[i]);
            Matrix tempInvMatrix = tempMatrix.inverse();
            invMatrix[i] = tempInvMatrix.getArray();
        }
        return invMatrix;
    }

    protected NetcdfFile loadFile(String resourcePath) throws URISyntaxException, IOException {
        URI resourceUri = this.getClass().getResource(resourcePath).toURI();
        return NetcdfFile.openInMemory((URI)resourceUri);
    }
}

