/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.snowalbedo;

import junit.framework.TestCase;
import org.esa.s3tbx.olci.snowalbedo.OlciSnowAlbedoAlgorithm;
import org.junit.Test;

public class OlciSnowAlbedoAlgorithmTest {
    @Test
    public void testComputeBroadbandAlbedos() throws Exception {
        double[] spectralAlbedos = new double[]{0.998, 0.998, 0.996, 0.993, 0.99, 0.984, 0.975, 0.964, 0.961, 0.95, 0.92, 0.89, 0.86, 0.712};
        double r21 = 0.71233;
        double sza = 50.0;
        OlciSnowAlbedoAlgorithm.SphericalBroadbandAlbedo sbbaTerms = OlciSnowAlbedoAlgorithm.computeSphericalBroadbandAlbedoTerms((double[])spectralAlbedos, (double)r21);
        double sphericalBroadbandAlbedo = sbbaTerms.getR_b1() + sbbaTerms.getR_b2();
        TestCase.assertEquals((double)0.8385, (double)sphericalBroadbandAlbedo, (double)0.01);
        double broadbandPlanarAlbedo = OlciSnowAlbedoAlgorithm.computePlanarFromSphericalAlbedo((double)sphericalBroadbandAlbedo, (double)sza);
        TestCase.assertEquals((double)0.8416, (double)broadbandPlanarAlbedo, (double)0.01);
    }

    @Test
    public void testComputeGrainDiameter() throws Exception {
        double grainDiameter = OlciSnowAlbedoAlgorithm.computeGrainDiameter((double)0.71233);
        TestCase.assertEquals((double)316.765, (double)grainDiameter, (double)0.01);
    }

    @Test
    public void testComputeSpectralAlbedo() throws Exception {
        double brr = 0.71233;
        double sza = 55.5;
        double vza = 31.55;
        double saa = 154.28;
        double vaa = 103.75;
        double spectralAlbedo = OlciSnowAlbedoAlgorithm.computeSpectralAlbedo((double)brr, (double)sza, (double)vza, (double)saa, (double)vaa);
        TestCase.assertEquals((double)0.7244, (double)spectralAlbedo, (double)0.01);
    }

    @Test
    public void testIntegrateR_b1() throws Exception {
        double[] spectralAlbedos = new double[]{0.998, 0.998, 0.996, 0.993, 0.99, 0.984, 0.975, 0.964, 0.961, 0.95, 0.92, 0.89, 0.86, 0.712};
        double r_b1 = OlciSnowAlbedoAlgorithm.integrateR_b1((double[])spectralAlbedos);
        TestCase.assertEquals((double)0.7552, (double)r_b1, (double)0.01);
    }

    @Test
    public void testIntegrateR_b2() throws Exception {
        double r_b2 = OlciSnowAlbedoAlgorithm.integrateR_b2((double)200.0);
        TestCase.assertEquals((double)0.0947, (double)r_b2, (double)0.01);
        r_b2 = OlciSnowAlbedoAlgorithm.integrateR_b2((double)50.0);
        TestCase.assertEquals((double)0.1289, (double)r_b2, (double)0.01);
        r_b2 = OlciSnowAlbedoAlgorithm.integrateR_b2((double)100.0);
        TestCase.assertEquals((double)0.1118, (double)r_b2, (double)0.01);
        r_b2 = OlciSnowAlbedoAlgorithm.integrateR_b2((double)400.0);
        TestCase.assertEquals((double)0.077, (double)r_b2, (double)0.01);
        r_b2 = OlciSnowAlbedoAlgorithm.integrateR_b2((double)800.0);
        TestCase.assertEquals((double)0.0604, (double)r_b2, (double)0.01);
    }

    @Test
    public void testInterpolateSpectralAlbedos() {
        double[] x = new double[]{0.0, 50.0, 100.0};
        double[] y = new double[]{0.0, 50.0, 200.0};
        double[] xi = new double[]{10.0, 25.0, 75.0, 80.0, 100.0};
        double[] yi = OlciSnowAlbedoAlgorithm.interpolateSpectralAlbedos((double[])x, (double[])y, (double[])xi);
        TestCase.assertEquals((double)5.0, (double)yi.length, (double)0.01);
        TestCase.assertEquals((Object)10.0, (Object)yi[0]);
        TestCase.assertEquals((Object)25.0, (Object)yi[1]);
        TestCase.assertEquals((Object)125.0, (Object)yi[2]);
        TestCase.assertEquals((Object)140.0, (Object)yi[3]);
        TestCase.assertEquals((Object)200.0, (Object)yi[4]);
    }
}

