/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.smilecorr;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.esa.s3tbx.olci.radiometry.Sensor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;

public class SmileCorrectionUtils {
    public static float[] multiple2ArrayFloat(float[] array1, float[] array2) {
        if (array1.length != array2.length) {
            throw new OperatorException("The arrays most have the same length.");
        }
        float[] cal = new float[array1.length];
        IntStream.range(0, cal.length).forEach(value -> {
            cal[value] = array1[value] * array2[value];
        });
        return cal;
    }

    public static float[] multiple3ArrayFloat(float[] array1, float[] array2, float[] array3) {
        return SmileCorrectionUtils.multiple2ArrayFloat(SmileCorrectionUtils.multiple2ArrayFloat(array1, array2), array3);
    }

    public static float[] add2ArrayFloat(float[] array1, float[] array2) {
        if (array1.length != array2.length) {
            throw new OperatorException("The arrays most have the same length.");
        }
        float[] cal = new float[array1.length];
        IntStream.range(0, cal.length).forEach(value -> {
            cal[value] = array1[value] + array2[value];
        });
        return cal;
    }

    public static double[] convertDegreesToRadians(double[] angle) {
        double[] rads = new double[angle.length];
        IntStream.range(0, rads.length).forEach(value -> {
            rads[value] = Math.toRadians(angle[value]);
        });
        return rads;
    }

    public static float[] convertDegreesToRadians(float[] angle) {
        float[] rads = new float[angle.length];
        IntStream.range(0, rads.length).forEach(value -> {
            rads[value] = (float)Math.toRadians(angle[value]);
        });
        return rads;
    }

    public static double[] getAirMass(double[] cosOZARads, double[] cosSZARads) {
        double[] massAir = new double[cosOZARads.length];
        IntStream.range(0, massAir.length).forEach(value -> {
            massAir[value] = 1.0 / cosSZARads[value] + 1.0 / cosOZARads[value];
        });
        return massAir;
    }

    public static double[] getAziDiff(double[] saaRads, double[] aooRads) {
        int length = saaRads.length;
        double[] aziDiff = new double[length];
        IntStream.range(0, length).forEach(value -> {
            double a = aooRads[value] - saaRads[value];
            double cosDelta = Math.cos(a);
            aziDiff[value] = Math.acos(cosDelta);
        });
        return aziDiff;
    }

    public static double[] getSampleDoubles(Tile sourceTile) {
        int maxX = sourceTile.getWidth();
        int maxY = sourceTile.getHeight();
        double[] val = new double[maxX * maxY];
        int index = 0;
        for (int y = sourceTile.getMinY(); y <= sourceTile.getMaxY(); ++y) {
            for (int x = sourceTile.getMinX(); x <= sourceTile.getMaxX(); ++x) {
                val[index++] = sourceTile.getSampleDouble(x, y);
            }
        }
        return val;
    }

    public static float[] getSampleFloats(Tile sourceTile) {
        int maxX = sourceTile.getWidth();
        int maxY = sourceTile.getHeight();
        float[] val = new float[maxX * maxY];
        int index = 0;
        for (int y = sourceTile.getMinY(); y <= sourceTile.getMaxY(); ++y) {
            for (int x = sourceTile.getMinX(); x <= sourceTile.getMaxX(); ++x) {
                val[index++] = sourceTile.getSampleFloat(x, y);
            }
        }
        return val;
    }

    public static float[] convertDoublesToFloats(double[] ref) {
        return Floats.toArray((Collection)Doubles.asList((double[])ref));
    }

    public static int getSourceBandIndex(String name) {
        Matcher matcher = Pattern.compile("(\\d+)").matcher(name);
        if (!matcher.find()) {
            return -1;
        }
        String group = matcher.group(0);
        return Integer.parseInt(group);
    }

    public static Sensor getSensorType(Product sourceProduct) {
        String[] bandNames = sourceProduct.getBandNames();
        boolean isSensor = Stream.of(bandNames).anyMatch(p -> p.matches("Oa\\d+_radiance"));
        if (isSensor) {
            return Sensor.OLCI;
        }
        isSensor = Stream.of(bandNames).anyMatch(p -> p.matches("radiance_\\d+"));
        if (isSensor) {
            return Sensor.MERIS;
        }
        throw new OperatorException("The operator can't be applied on this sensor.\nOnly OLCI and MERIS are supported");
    }
}

