/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.smilecorr;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.s3tbx.olci.radiometry.Sensor;
import org.esa.s3tbx.olci.radiometry.gasabsorption.GaseousAbsorptionAux;
import org.esa.s3tbx.olci.radiometry.rayleigh.RayleighAux;
import org.esa.s3tbx.olci.radiometry.rayleigh.RayleighCorrAlgorithm;
import org.esa.s3tbx.olci.radiometry.rayleigh.RayleighInput;
import org.esa.s3tbx.olci.radiometry.rayleigh.RayleighOutput;
import org.esa.s3tbx.olci.radiometry.smilecorr.PrepareSmileCorrection;
import org.esa.s3tbx.olci.radiometry.smilecorr.SmileCorrectionAlgorithm;
import org.esa.s3tbx.olci.radiometry.smilecorr.SmileCorrectionAuxdata;
import org.esa.s3tbx.olci.radiometry.smilecorr.SmileCorrectionUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.math.RsMathUtils;

@OperatorMetadata(alias="SmileCorrection.Olci", internal=true, description="Performs radiometric corrections on OLCI L1b data products.", authors=" Marco Peters, Muhammad Bala (Brockmann Consult)", copyright="(c) 2015 by Brockmann Consult", category="Optical/Pre-Processing", version="1.2")
public class SmileCorrectionOp
extends Operator {
    public static final String WATER_EXPRESSION = "not quality_flags_land";
    private static final String FWHM_BAND_PATTERN = "FWHM_band_%d";
    private static final String ALTITUDE_BAND = "altitude";
    private static final String LATITUDE_BAND = "latitude";
    private static final String LONGITUDE_BAND = "longitude";
    private static final String DETECTOR_INDEX_BAND = "detector_index";
    private static final String OLCI_SENSOR = "OLCI";
    private static final int DO_NOT_CORRECT_BAND = -1;
    private static final String LAMBDA0_BAND_NAME_PATTERN = "lambda0_band_%d";
    private static final String SOLAR_FLUX_BAND_NAME_PATTERN = "solar_flux_band_%d";
    private static final String OA_RADIANCE_BAND_NAME_PATTERN = "Oa%02d_radiance";
    private static final String OA_RADIANCE_ERR_BAND_NAME_PATTERN = "Oa%02d_radiance_err";
    public static final String OLCI_RADIANCE_PATTERN = "Oa\\d{2}_radiance";
    public static final String LAMBDA_BAND_PATTERN = "lambda0_band_\\d+";
    public static final String SOLAR_FLUX_BAND_PATTERN = "solar_flux_band_\\d+";
    private Mask waterMask;
    @SourceProduct(alias="source", label="Name", description="The source product.")
    private Product sourceProduct;
    private RayleighCorrAlgorithm rayleighCorrAlgorithm;
    private double[] absorpOzone;
    private Sensor sensor;
    private SmileCorrectionAuxdata smileAuxdata;

    public void initialize() throws OperatorException {
        this.sensor = SmileCorrectionUtils.getSensorType(this.getSourceProduct());
        this.smileAuxdata = new SmileCorrectionAuxdata(this.sensor);
        if (Sensor.MERIS.equals((Object)this.sensor)) {
            try {
                this.smileAuxdata.loadFluxWaven(this.sourceProduct.getProductType());
            }
            catch (IOException e) {
                throw new OperatorException((Throwable)e);
            }
        }
        RayleighAux.initDefaultAuxiliary();
        this.rayleighCorrAlgorithm = new RayleighCorrAlgorithm(this.sensor.getNamePattern(), this.sensor.getNumBands());
        this.absorpOzone = GaseousAbsorptionAux.getInstance().absorptionOzone(OLCI_SENSOR);
        Product targetProduct = this.createTargetBands(this.sensor);
        this.setTargetProduct(targetProduct);
        this.waterMask = Mask.BandMathsType.create((String)"__water_mask", null, (int)this.getSourceProduct().getSceneRasterWidth(), (int)this.getSourceProduct().getSceneRasterHeight(), (String)WATER_EXPRESSION, (Color)Color.GREEN, (double)0.0);
        this.waterMask.setOwner((ProductNode)this.getSourceProduct());
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        this.checkForCancellation();
        String targetBandName = targetBand.getName();
        int targetBandIndex = SmileCorrectionUtils.getSourceBandIndex(targetBandName);
        if (Sensor.MERIS == this.sensor) {
            this.correctRadMeris(targetTile, targetBandName, targetBandIndex, this.smileAuxdata, pm);
        } else if (Sensor.OLCI == this.sensor) {
            if (targetBandName.matches(OLCI_RADIANCE_PATTERN)) {
                this.correctRad(targetTile, targetBandName, targetBandIndex, this.sensor, pm);
            }
            if (targetBandName.matches(LAMBDA_BAND_PATTERN)) {
                this.correctLambda(targetTile, targetBandName, targetBandIndex, pm);
            }
            if (targetBandName.matches(SOLAR_FLUX_BAND_PATTERN)) {
                this.correctSolarFlux(targetTile, targetBandName, pm);
            }
        }
    }

    private Product createTargetBands(Sensor sensor) {
        Product targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        boolean[] landRefCorrectionSwitches = this.smileAuxdata.getLandRefCorrectionSwitches();
        boolean[] waterRefCorrectionSwitches = this.smileAuxdata.getWaterRefCorrectionSwitches();
        float[] refCentralWaveLengths = this.smileAuxdata.getRefCentralWaveLengths();
        if (Sensor.OLCI == sensor) {
            this.createTargetBands(targetProduct, sensor.getNamePattern(), landRefCorrectionSwitches, waterRefCorrectionSwitches, refCentralWaveLengths);
            this.createTargetLambda(targetProduct, LAMBDA0_BAND_NAME_PATTERN, landRefCorrectionSwitches, waterRefCorrectionSwitches, refCentralWaveLengths);
            this.createTargetBands(targetProduct, SOLAR_FLUX_BAND_NAME_PATTERN, landRefCorrectionSwitches, waterRefCorrectionSwitches, refCentralWaveLengths);
            this.copyTargetBandsImage(targetProduct, OA_RADIANCE_ERR_BAND_NAME_PATTERN, sensor.getNumBands());
            this.copyTargetBandsImage(targetProduct, FWHM_BAND_PATTERN, sensor.getNumBands());
            this.copyTargetBandImage(targetProduct, ALTITUDE_BAND);
            this.copyTargetBandImage(targetProduct, LATITUDE_BAND);
            this.copyTargetBandImage(targetProduct, LONGITUDE_BAND);
        } else if (Sensor.MERIS == sensor) {
            this.createTargetBands(targetProduct, sensor.getNamePattern(), landRefCorrectionSwitches, waterRefCorrectionSwitches, refCentralWaveLengths);
            this.copyTargetBandImage(targetProduct, DETECTOR_INDEX_BAND);
            ProductUtils.copyMasks((Product)this.sourceProduct, (Product)targetProduct);
        }
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)targetProduct);
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
        return targetProduct;
    }

    private void createTargetLambda(Product targetProduct, String lambdaBandNamePattern, boolean[] landRefCorrectionSwitches, boolean[] waterRefCorrectionSwitches, float[] refCentralWaveLengths) {
        for (int i = 0; i < refCentralWaveLengths.length; ++i) {
            String sourceBandName = String.format(lambdaBandNamePattern, i + 1);
            if (landRefCorrectionSwitches[i] && waterRefCorrectionSwitches[i]) {
                RenderedOp image = ConstantDescriptor.create((Float)Float.valueOf(this.sourceProduct.getSceneRasterWidth()), (Float)Float.valueOf(this.sourceProduct.getSceneRasterHeight()), (Number[])new Float[]{Float.valueOf(refCentralWaveLengths[i])}, null);
                ProductUtils.copyBand((String)sourceBandName, (Product)this.sourceProduct, (Product)targetProduct, (boolean)false);
                targetProduct.getBand(sourceBandName).setSourceImage((RenderedImage)image);
                continue;
            }
            if (!landRefCorrectionSwitches[i] && !waterRefCorrectionSwitches[i]) {
                ProductUtils.copyBand((String)sourceBandName, (Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
                continue;
            }
            this.createTargetBand(targetProduct, sourceBandName);
        }
    }

    private void copyTargetBandsImage(Product targetProduct, String bandNamePattern, int numBand) {
        for (int i = 1; i <= numBand; ++i) {
            String sourceBandName = String.format(bandNamePattern, i);
            this.copyTargetBandImage(targetProduct, sourceBandName);
        }
    }

    private void copyTargetBandImage(Product targetProduct, String bandName) {
        if (this.sourceProduct.containsBand(bandName)) {
            ProductUtils.copyBand((String)bandName, (Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
        }
    }

    private void createTargetBands(Product targetProduct, String bandNamePattern, boolean[] landRefCorrectionSwitches, boolean[] waterRefCorrectionSwitches, float[] refCentralWaveLengths) {
        for (int i = 0; i < refCentralWaveLengths.length; ++i) {
            String sourceBandName = String.format(bandNamePattern, i + 1);
            if (landRefCorrectionSwitches[i] || waterRefCorrectionSwitches[i]) {
                this.createTargetBand(targetProduct, sourceBandName);
                continue;
            }
            if (landRefCorrectionSwitches[i] || waterRefCorrectionSwitches[i]) continue;
            ProductUtils.copyBand((String)sourceBandName, (Product)this.sourceProduct, (Product)targetProduct, (boolean)true);
        }
    }

    private void createTargetBand(Product targetProduct, String bandNamePattern) {
        Band targetBand = targetProduct.addBand(bandNamePattern, 30);
        Band sourceBand = this.sourceProduct.getBand(bandNamePattern);
        targetBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
        targetBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
        targetBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
        targetBand.setNoDataValueUsed(true);
        targetBand.setNoDataValue(Double.NaN);
    }

    private void correctSolarFlux(Tile targetTile, String targetBandName, ProgressMonitor pm) {
        Rectangle rectangle = targetTile.getRectangle();
        String extractBandIndex = targetBandName.substring(16, targetBandName.length());
        int targetBandIndex = Integer.parseInt(extractBandIndex) - 1;
        boolean correctLand = this.smileAuxdata.getLandRefCorrectionSwitches()[targetBandIndex];
        boolean correctWater = this.smileAuxdata.getWaterRefCorrectionSwitches()[targetBandIndex];
        Band lambdaSourceBand = this.sourceProduct.getBand(String.format(LAMBDA0_BAND_NAME_PATTERN, targetBandIndex + 1));
        Band effectiveSolarIrradianceBand = this.sourceProduct.getBand(targetBandName);
        Tile sourceLambdaTile = this.getSourceTile((RasterDataNode)lambdaSourceBand, rectangle);
        Tile solarIrradianceTile = this.getSourceTile((RasterDataNode)effectiveSolarIrradianceBand, rectangle);
        Tile waterMaskTile = this.getSourceTile((RasterDataNode)this.waterMask, rectangle);
        float refCentralWaveLength = this.smileAuxdata.getRefCentralWaveLengths()[targetBandIndex];
        for (int y = targetTile.getMinY(); y <= targetTile.getMaxY(); ++y) {
            if (pm.isCanceled()) {
                return;
            }
            for (int x = targetTile.getMinX(); x <= targetTile.getMaxX(); ++x) {
                float shiftedSolarIrradiance;
                float solarIrradianceSample = solarIrradianceTile.getSampleFloat(x, y);
                float sourceTargetLambda = sourceLambdaTile.getSampleFloat(x, y);
                if (sourceTargetLambda == -1.0f || solarIrradianceSample == -1.0f) continue;
                if (waterMaskTile.getSampleBoolean(x, y)) {
                    if (correctWater) {
                        shiftedSolarIrradiance = this.shiftSolarIrradiance(solarIrradianceSample, sourceTargetLambda, refCentralWaveLength);
                        targetTile.setSample(x, y, shiftedSolarIrradiance);
                        continue;
                    }
                    targetTile.setSample(x, y, solarIrradianceSample);
                    continue;
                }
                if (correctLand) {
                    shiftedSolarIrradiance = this.shiftSolarIrradiance(solarIrradianceSample, sourceTargetLambda, refCentralWaveLength);
                    targetTile.setSample(x, y, shiftedSolarIrradiance);
                    continue;
                }
                targetTile.setSample(x, y, solarIrradianceSample);
            }
        }
    }

    private void correctLambda(Tile targetTile, String targetBandName, int targetBandIndex, ProgressMonitor pm) {
        Rectangle rectangle = targetTile.getRectangle();
        Tile sourceLambdaTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(targetBandName), rectangle);
        boolean correctLand = this.smileAuxdata.getLandRefCorrectionSwitches()[targetBandIndex];
        boolean correctWater = this.smileAuxdata.getWaterRefCorrectionSwitches()[targetBandIndex];
        float refCentralWaveLength = this.smileAuxdata.getRefCentralWaveLengths()[targetBandIndex];
        Tile waterMaskTile = this.getSourceTile((RasterDataNode)this.waterMask, rectangle);
        for (int y = targetTile.getMinY(); y <= targetTile.getMaxY(); ++y) {
            if (pm.isCanceled()) {
                return;
            }
            for (int x = targetTile.getMinX(); x <= targetTile.getMaxX(); ++x) {
                if (waterMaskTile.getSampleBoolean(x, y)) {
                    if (correctWater) {
                        targetTile.setSample(x, y, refCentralWaveLength);
                        continue;
                    }
                    targetTile.setSample(x, y, sourceLambdaTile.getSampleFloat(x, y));
                    continue;
                }
                if (correctLand) {
                    targetTile.setSample(x, y, refCentralWaveLength);
                    continue;
                }
                targetTile.setSample(x, y, sourceLambdaTile.getSampleFloat(x, y));
            }
        }
    }

    private void correctRadMeris(Tile targetTile, String targetBandName, int targetBandIndex, SmileCorrectionAuxdata smileAuxdata, ProgressMonitor pm) {
        this.checkForCancellation();
        Rectangle rectangle = targetTile.getRectangle();
        boolean correctLand = smileAuxdata.getLandRefCorrectionSwitches()[targetBandIndex];
        boolean correctWater = this.smileAuxdata.getWaterRefCorrectionSwitches()[targetBandIndex];
        Tile sourceRadianceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(targetBandName), rectangle);
        if (!correctLand && !correctWater) {
            float[] samplesFloat = sourceRadianceTile.getSamplesFloat();
            targetTile.setSamples(samplesFloat);
            return;
        }
        MerisSmile waterTileValues = null;
        MerisSmile landTileValues = null;
        if (correctWater) {
            waterTileValues = new MerisSmile(this.smileAuxdata, rectangle, targetBandIndex, SmileType.WATER);
        }
        if (correctLand) {
            landTileValues = new MerisSmile(this.smileAuxdata, rectangle, targetBandIndex, SmileType.LAND);
        }
        float refCentralWaveLength = this.smileAuxdata.getRefCentralWaveLengths()[targetBandIndex];
        Tile szaTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid("sun_zenith"), rectangle);
        if (correctWater) {
            float[] correctForSmileEffect = this.correctForSmileEffect(sourceRadianceTile, refCentralWaveLength, waterTileValues, szaTile, targetBandIndex);
            targetTile.setSamples(correctForSmileEffect);
            return;
        }
        if (correctLand) {
            float[] correctedRadiance = this.correctForSmileEffect(sourceRadianceTile, refCentralWaveLength, landTileValues, szaTile, targetBandIndex);
            targetTile.setSamples(correctedRadiance);
            return;
        }
        float[] sourceRadiance = sourceRadianceTile.getSamplesFloat();
        targetTile.setSamples(sourceRadiance);
    }

    private void correctRad(Tile targetTile, String targetBandName, int targetBandIndex, Sensor sensor, ProgressMonitor pm) {
        this.checkForCancellation();
        Rectangle rectangle = targetTile.getRectangle();
        Tile szaTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(sensor.getSZA()), rectangle);
        Tile sourceRadianceTile = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(targetBandName), rectangle);
        Band sourceSolarIrradianceBand = this.sourceProduct.getBand(String.format(SOLAR_FLUX_BAND_NAME_PATTERN, targetBandIndex + 1));
        int waterLowerBandIndex = this.smileAuxdata.getWaterLowerBands()[targetBandIndex];
        int waterUpperBandIndex = this.smileAuxdata.getWaterUpperBands()[targetBandIndex];
        int landLowerBandIndex = this.smileAuxdata.getLandLowerBands()[targetBandIndex];
        int landUpperBandIndex = this.smileAuxdata.getLandUpperBands()[targetBandIndex];
        Band lambdaWaterLowerBand = this.sourceProduct.getBand(String.format(LAMBDA0_BAND_NAME_PATTERN, waterLowerBandIndex));
        Band lambdaWaterUpperBand = this.sourceProduct.getBand(String.format(LAMBDA0_BAND_NAME_PATTERN, waterUpperBandIndex));
        Band lambdaLandLowerBand = this.sourceProduct.getBand(String.format(LAMBDA0_BAND_NAME_PATTERN, landLowerBandIndex));
        Band lambdaLandUpperBand = this.sourceProduct.getBand(String.format(LAMBDA0_BAND_NAME_PATTERN, landUpperBandIndex));
        Band solarIrradianceWaterLowerBand = this.sourceProduct.getBand(String.format(SOLAR_FLUX_BAND_NAME_PATTERN, waterLowerBandIndex));
        Band solarIrradianceWaterUpperBand = this.sourceProduct.getBand(String.format(SOLAR_FLUX_BAND_NAME_PATTERN, waterUpperBandIndex));
        Band solarIrradianceLandLowerBand = this.sourceProduct.getBand(String.format(SOLAR_FLUX_BAND_NAME_PATTERN, landLowerBandIndex));
        Band solarIrradianceLandUpperBand = this.sourceProduct.getBand(String.format(SOLAR_FLUX_BAND_NAME_PATTERN, landUpperBandIndex));
        Band radianceWaterLowerBand = this.sourceProduct.getBand(String.format(OA_RADIANCE_BAND_NAME_PATTERN, waterLowerBandIndex));
        Band radianceWaterUpperBand = this.sourceProduct.getBand(String.format(OA_RADIANCE_BAND_NAME_PATTERN, waterUpperBandIndex));
        Band radianceLandLowerBand = this.sourceProduct.getBand(String.format(OA_RADIANCE_BAND_NAME_PATTERN, landLowerBandIndex));
        Band radianceLandUpperBand = this.sourceProduct.getBand(String.format(OA_RADIANCE_BAND_NAME_PATTERN, landUpperBandIndex));
        Band lambdaSourceBand = this.sourceProduct.getBand(String.format(LAMBDA0_BAND_NAME_PATTERN, targetBandIndex + 1));
        boolean correctLand = this.smileAuxdata.getLandRefCorrectionSwitches()[targetBandIndex];
        boolean correctWater = this.smileAuxdata.getWaterRefCorrectionSwitches()[targetBandIndex];
        if (!correctLand && !correctWater) {
            float[] samplesFloat = sourceRadianceTile.getSamplesFloat();
            targetTile.setSamples(samplesFloat);
            return;
        }
        SmileTiles waterTiles = null;
        if (correctWater) {
            waterTiles = new SmileTiles(lambdaWaterLowerBand, lambdaSourceBand, lambdaWaterUpperBand, radianceWaterLowerBand, radianceWaterUpperBand, solarIrradianceWaterLowerBand, solarIrradianceWaterUpperBand, sourceSolarIrradianceBand, rectangle);
        }
        SmileTiles landTiles = null;
        if (correctLand) {
            landTiles = new SmileTiles(lambdaLandLowerBand, lambdaSourceBand, lambdaLandUpperBand, radianceLandLowerBand, radianceLandUpperBand, solarIrradianceLandLowerBand, solarIrradianceLandUpperBand, solarIrradianceLandUpperBand, rectangle);
        }
        float refCentralWaveLength = this.smileAuxdata.getRefCentralWaveLengths()[targetBandIndex];
        float[] sourceRadiance = sourceRadianceTile.getSamplesFloat();
        if (correctWater) {
            float[] correctForSmileEffect = this.correctForSmileEffect(sourceRadianceTile, refCentralWaveLength, waterTiles, szaTile, targetBandIndex);
            targetTile.setSamples(correctForSmileEffect);
            return;
        }
        if (correctLand) {
            float[] correctedRadiance = this.correctForSmileEffect(sourceRadianceTile, refCentralWaveLength, landTiles, szaTile, targetBandIndex);
            targetTile.setSamples(correctedRadiance);
            return;
        }
        targetTile.setSamples(sourceRadiance);
    }

    private float[] correctForSmileEffect(Tile sourceRadTile, float refCentralWaveLength, PrepareSmileCorrection smileTiles, Tile szaTile, int targetBandIndx) {
        float[] sourceTargetLambda = smileTiles.lambdaSourceBand();
        float[] solarIrradiance = smileTiles.solarIrradianceSourceBand();
        float[] lowerBandSolarIrrad = smileTiles.solarIrradianceLowerBand();
        float[] upperBandSolarIrrad = smileTiles.solarIrradianceUpperBand();
        float[] lowerBandRad = smileTiles.radianceLowerBand();
        float[] upperBandRad = smileTiles.radianceUpperBand();
        float[] lowerLambda = smileTiles.lambdaLowerBand();
        float[] upperLambda = smileTiles.lambdaUpperBand();
        float[] sza = SmileCorrectionUtils.getSampleFloats(szaTile);
        float[] radiance = SmileCorrectionUtils.getSampleFloats(sourceRadTile);
        float[] sourceRefl = this.convertRadToRefl(radiance, solarIrradiance, sza);
        float[] lowerRefl = this.convertRadToRefl(lowerBandRad, lowerBandSolarIrrad, sza);
        float[] upperRefl = this.convertRadToRefl(upperBandRad, upperBandSolarIrrad, sza);
        int lowerWaterIndx = this.smileAuxdata.getWaterLowerBands()[targetBandIndx] - 1;
        int upperWaterIndx = this.smileAuxdata.getWaterUpperBands()[targetBandIndx] - 1;
        if (lowerWaterIndx != -1 && upperWaterIndx != -1) {
            RayleighInput rayleighInputToCompute = new RayleighInput(sourceRefl, lowerRefl, upperRefl, targetBandIndx, lowerWaterIndx, upperWaterIndx);
            RayleighAux rayleighAux = this.prepareRayleighAux(sourceRadTile.getRectangle());
            RayleighOutput computedRayleighOutput = this.rayleighCorrAlgorithm.getRayleighReflectance(rayleighInputToCompute, rayleighAux, this.absorpOzone, this.getSourceProduct());
            sourceRefl = SmileCorrectionUtils.add2ArrayFloat(sourceRefl, computedRayleighOutput.getSourceRayRefls());
            lowerRefl = SmileCorrectionUtils.add2ArrayFloat(lowerRefl, computedRayleighOutput.getLowerRayRefls());
            upperRefl = SmileCorrectionUtils.add2ArrayFloat(upperRefl, computedRayleighOutput.getUpperRayRefls());
        }
        float[] convertRefTo = new float[sourceRefl.length];
        for (int i = 0; i < sourceRefl.length; ++i) {
            float correctedReflectance = SmileCorrectionAlgorithm.correctWithReflectance(sourceRefl[i], lowerRefl[i], upperRefl[i], sourceTargetLambda[i], lowerLambda[i], upperLambda[i], refCentralWaveLength);
            float shiftedSolarIrradiance = this.shiftSolarIrradiance(solarIrradiance[i], sourceTargetLambda[i], refCentralWaveLength);
            convertRefTo[i] = this.convertReflToRad(correctedReflectance, sza[i], shiftedSolarIrradiance);
        }
        return convertRefTo;
    }

    private RayleighAux prepareRayleighAux(Rectangle rectangle) {
        RayleighAux rayleighAux = new RayleighAux();
        rayleighAux.setSunZenithAngles(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getSZA()), rectangle));
        rayleighAux.setViewZenithAngles(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getOZA()), rectangle));
        rayleighAux.setSunAzimuthAngles(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getSAA()), rectangle));
        rayleighAux.setViewAzimuthAngles(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getOAA()), rectangle));
        rayleighAux.setSeaLevels(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getSeaLevelPressure()), rectangle));
        rayleighAux.setTotalOzones(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getTotalOzone()), rectangle));
        if (Sensor.MERIS.equals((Object)this.sensor)) {
            rayleighAux.setAltitudes(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getAltitude()), rectangle));
            rayleighAux.setLatitudes(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getLatitude()), rectangle));
            rayleighAux.setLongitude(this.getSourceTile((RasterDataNode)this.sourceProduct.getTiePointGrid(this.sensor.getLongitude()), rectangle));
        } else {
            rayleighAux.setAltitudes(this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(this.sensor.getAltitude()), rectangle));
            rayleighAux.setLatitudes(this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(this.sensor.getLatitude()), rectangle));
            rayleighAux.setLongitude(this.getSourceTile((RasterDataNode)this.sourceProduct.getBand(this.sensor.getLongitude()), rectangle));
        }
        return rayleighAux;
    }

    private float shiftSolarIrradiance(float solarIrradiance, float sourceTargetLambda, float refCentralWaveLength) {
        double m = 1.164760657E-9 * Math.pow(sourceTargetLambda, 4.0) - 3.553263318E-6 * Math.pow(sourceTargetLambda, 3.0) + 0.004024637931 * Math.pow(sourceTargetLambda, 2.0) - 2.003025166 * Math.pow(sourceTargetLambda, 1.0) + 366.3249385;
        return (float)((double)solarIrradiance + m * (double)(refCentralWaveLength - sourceTargetLambda));
    }

    private float[] convertRadToRefl(float[] radiance, float[] solarIrradiance, float[] sza) {
        float[] convertRadToRef = new float[radiance.length];
        for (int i = 0; i < radiance.length; ++i) {
            convertRadToRef[i] = RsMathUtils.radianceToReflectance((float)radiance[i], (float)sza[i], (float)solarIrradiance[i]);
        }
        return convertRadToRef;
    }

    private float convertReflToRad(float refl, float sza, float solarIrradiance) {
        return RsMathUtils.reflectanceToRadiance((float)refl, (float)sza, (float)solarIrradiance);
    }

    private static enum SmileType {
        WATER,
        LAND;

    }

    private class SmileTiles
    implements PrepareSmileCorrection {
        private final Tile sourceLambdaTile;
        private final Tile sourceSolarIrradianceTile;
        private Tile lowerLambdaTile;
        private Tile upperLambdaTile;
        private Tile lowerRadianceTile;
        private Tile upperRadianceTile;
        private Tile lowerSolarIrradianceTile;
        private Tile upperSolarIrradianceTile;

        SmileTiles(Band lowerLambdaBand, Band sourceLambdaBand, Band upperLambdaBand, Band lowerRadianceBand, Band upperRadianceBand, Band lowerSolarIrradianceBand, Band upperSolarIrradianceBand, Band sourceSolarIrradianceBand, Rectangle rectangle) {
            this.sourceLambdaTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)sourceLambdaBand, rectangle);
            this.lowerLambdaTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)lowerLambdaBand, rectangle);
            this.upperLambdaTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)upperLambdaBand, rectangle);
            this.lowerRadianceTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)lowerRadianceBand, rectangle);
            this.upperRadianceTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)upperRadianceBand, rectangle);
            this.sourceSolarIrradianceTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)sourceSolarIrradianceBand, rectangle);
            this.lowerSolarIrradianceTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)lowerSolarIrradianceBand, rectangle);
            this.upperSolarIrradianceTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)upperSolarIrradianceBand, rectangle);
        }

        @Override
        public float[] lambdaLowerBand() {
            return SmileCorrectionUtils.getSampleFloats(this.lowerLambdaTile);
        }

        @Override
        public float[] lambdaUpperBand() {
            return SmileCorrectionUtils.getSampleFloats(this.upperLambdaTile);
        }

        @Override
        public float[] lambdaSourceBand() {
            return SmileCorrectionUtils.getSampleFloats(this.sourceLambdaTile);
        }

        @Override
        public float[] solarIrradianceLowerBand() {
            return SmileCorrectionUtils.getSampleFloats(this.lowerSolarIrradianceTile);
        }

        @Override
        public float[] solarIrradianceSourceBand() {
            return SmileCorrectionUtils.getSampleFloats(this.sourceSolarIrradianceTile);
        }

        @Override
        public float[] solarIrradianceUpperBand() {
            return SmileCorrectionUtils.getSampleFloats(this.upperSolarIrradianceTile);
        }

        @Override
        public float[] radianceLowerBand() {
            return SmileCorrectionUtils.getSampleFloats(this.lowerRadianceTile);
        }

        @Override
        public float[] radianceUpperBand() {
            return SmileCorrectionUtils.getSampleFloats(this.upperRadianceTile);
        }
    }

    private class MerisSmile
    implements PrepareSmileCorrection {
        private final float[] samplesFloatRadianceLower;
        private final float[] samplesFloatRadianceUpper;
        private final float[] lambdaSourceBand;
        private final float[] lambdaLowerBand;
        private final float[] lambdaUpperBand;
        private final float[] solarIrradianceSource;
        private final float[] solarIrradianceLowerBand;
        private final float[] solarIrradianceUpperBand;

        public MerisSmile(SmileCorrectionAuxdata smileAuxdata, Rectangle rectangle, int targetBandIndex, SmileType smileType) {
            int lowerBandIndex = 0;
            int upperBandIndex = 0;
            if (SmileType.WATER.equals((Object)smileType)) {
                lowerBandIndex = smileAuxdata.getWaterLowerBands()[targetBandIndex];
                upperBandIndex = smileAuxdata.getWaterUpperBands()[targetBandIndex];
            } else if (SmileType.LAND.equals((Object)smileType)) {
                lowerBandIndex = smileAuxdata.getLandLowerBands()[targetBandIndex];
                upperBandIndex = smileAuxdata.getLandUpperBands()[targetBandIndex];
            }
            Tile sourceTile = SmileCorrectionOp.this.getSourceTile((RasterDataNode)SmileCorrectionOp.this.sourceProduct.getBand(SmileCorrectionOp.DETECTOR_INDEX_BAND), rectangle);
            this.lambdaSourceBand = this.getLambdas(smileAuxdata.getDetectorWavelengths(), targetBandIndex, sourceTile);
            this.lambdaLowerBand = this.getLambdas(smileAuxdata.getDetectorWavelengths(), targetBandIndex, sourceTile);
            this.lambdaUpperBand = this.getLambdas(smileAuxdata.getDetectorWavelengths(), upperBandIndex, sourceTile);
            this.solarIrradianceSource = this.getLambdas(smileAuxdata.getDetectorSunSpectralFluxes(), targetBandIndex, sourceTile);
            this.solarIrradianceLowerBand = this.getLambdas(smileAuxdata.getDetectorSunSpectralFluxes(), lowerBandIndex, sourceTile);
            this.solarIrradianceUpperBand = this.getLambdas(smileAuxdata.getDetectorSunSpectralFluxes(), upperBandIndex, sourceTile);
            Band radianceWaterLowerBand = SmileCorrectionOp.this.sourceProduct.getBand(String.format(SmileCorrectionOp.this.sensor.getNamePattern(), lowerBandIndex));
            Band radianceWaterUpperBand = SmileCorrectionOp.this.sourceProduct.getBand(String.format(SmileCorrectionOp.this.sensor.getNamePattern(), upperBandIndex));
            this.samplesFloatRadianceLower = SmileCorrectionOp.this.getSourceTile((RasterDataNode)radianceWaterLowerBand, rectangle).getSamplesFloat();
            this.samplesFloatRadianceUpper = SmileCorrectionOp.this.getSourceTile((RasterDataNode)radianceWaterUpperBand, rectangle).getSamplesFloat();
        }

        private float[] getLambdas(double[][] detectorWavelengths, int index, Tile sourceTile) {
            int[] samplesFloat = sourceTile.getSamplesInt();
            float[] result = new float[samplesFloat.length];
            for (int i = 0; i < samplesFloat.length; ++i) {
                int i1 = samplesFloat[i];
                if (i1 < 0) continue;
                result[i] = (float)detectorWavelengths[i1][index];
            }
            return result;
        }

        @Override
        public float[] lambdaLowerBand() {
            return this.lambdaLowerBand;
        }

        @Override
        public float[] lambdaUpperBand() {
            return this.lambdaUpperBand;
        }

        @Override
        public float[] lambdaSourceBand() {
            return this.lambdaSourceBand;
        }

        @Override
        public float[] solarIrradianceLowerBand() {
            return this.solarIrradianceLowerBand;
        }

        @Override
        public float[] solarIrradianceSourceBand() {
            return this.solarIrradianceSource;
        }

        @Override
        public float[] solarIrradianceUpperBand() {
            return this.solarIrradianceUpperBand;
        }

        @Override
        public float[] radianceLowerBand() {
            return this.samplesFloatRadianceLower;
        }

        @Override
        public float[] radianceUpperBand() {
            return this.samplesFloatRadianceUpper;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SmileCorrectionOp.class);
        }
    }
}

