/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.smilecorr;

import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.s3tbx.olci.radiometry.Sensor;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.CsvReader;

public class SmileCorrectionAuxdata {
    private static final String CENTRAL_WAVELEN_FR_FILENAME = "central_wavelen_fr.txt";
    private static final String CENTRAL_WAVELEN_RR_FILENAME = "central_wavelen_rr.txt";
    private static final String SUN_SPECTRAL_FLUX_FR_FILENAME = "sun_spectral_flux_fr.txt";
    private static final String SUN_SPECTRAL_FLUX_RR_FILENAME = "sun_spectral_flux_rr.txt";
    private static final int NUM_DETECTORS_FR = 3700;
    private static final int NUM_DETECTORS_RR = 925;
    private int[] bandIndices;
    private boolean[] landRefCorrectionSwitches;
    private boolean[] waterRefCorrectionSwitches;
    private int[] waterLowerBands;
    private int[] waterUpperBands;
    private int[] landLowerBands;
    private int[] landUpperBands;
    private float[] refCentralWaveLengths;
    private float[] solarIrradiances;
    private double[][] detectorWavelengths;
    private double[][] detectorSunSpectralFluxes;

    public SmileCorrectionAuxdata(Sensor sensor) {
        List<String[]> loadAuxdata = null;
        try {
            loadAuxdata = SmileCorrectionAuxdata.loadAuxdata(sensor.getBandInfoFileName());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double[][] tableValue = SmileCorrectionAuxdata.auxDataInFlatTable(loadAuxdata, 9);
        int n = tableValue.length;
        this.bandIndices = new int[n];
        this.waterLowerBands = new int[n];
        this.waterUpperBands = new int[n];
        this.landLowerBands = new int[n];
        this.landUpperBands = new int[n];
        this.landRefCorrectionSwitches = new boolean[n];
        this.waterRefCorrectionSwitches = new boolean[n];
        this.solarIrradiances = new float[n];
        this.refCentralWaveLengths = new float[n];
        for (int i = 0; i < tableValue.length; ++i) {
            double[] row = tableValue[i];
            this.bandIndices[i] = (int)row[0];
            this.waterRefCorrectionSwitches[i] = row[1] != 0.0;
            this.waterLowerBands[i] = (int)row[2];
            this.waterUpperBands[i] = (int)row[3];
            this.landRefCorrectionSwitches[i] = row[4] != 0.0;
            this.landLowerBands[i] = (int)row[5];
            this.landUpperBands[i] = (int)row[6];
            this.refCentralWaveLengths[i] = (float)row[7];
            this.solarIrradiances[i] = (float)row[8];
        }
    }

    public void loadFluxWaven(String productType) throws IOException {
        if (productType.startsWith("MER_F")) {
            this.loadFRAuxdata();
        } else if (productType.startsWith("MER_R")) {
            this.loadRRAuxdata();
        } else {
            throw new IOException(String.format("No auxillary data found for input product of type '%s'", productType));
        }
    }

    public void loadRRAuxdata() throws IOException {
        this.loadDetectorData(CENTRAL_WAVELEN_RR_FILENAME, SUN_SPECTRAL_FLUX_RR_FILENAME, 925, Sensor.MERIS.getNumBands());
    }

    public void loadFRAuxdata() throws IOException {
        this.loadDetectorData(CENTRAL_WAVELEN_FR_FILENAME, SUN_SPECTRAL_FLUX_FR_FILENAME, 3700, Sensor.MERIS.getNumBands());
    }

    public int[] getBandIndices() {
        return this.bandIndices;
    }

    public boolean[] getWaterRefCorrectionSwitches() {
        return this.waterRefCorrectionSwitches;
    }

    public boolean[] getLandRefCorrectionSwitches() {
        return this.landRefCorrectionSwitches;
    }

    public int[] getWaterLowerBands() {
        return this.waterLowerBands;
    }

    public int[] getWaterUpperBands() {
        return this.waterUpperBands;
    }

    public int[] getLandLowerBands() {
        return this.landLowerBands;
    }

    public int[] getLandUpperBands() {
        return this.landUpperBands;
    }

    public float[] getRefCentralWaveLengths() {
        return this.refCentralWaveLengths;
    }

    public float[] getSolarIrradiances() {
        return this.solarIrradiances;
    }

    public double[][] getDetectorWavelengths() {
        return this.detectorWavelengths;
    }

    public double[][] getDetectorSunSpectralFluxes() {
        return this.detectorSunSpectralFluxes;
    }

    public static List<String[]> loadAuxdata(String bandInfoFileName) throws IOException {
        List readStringRecords;
        Path auxdataDir = SmileCorrectionAuxdata.installAuxdata();
        try (CsvReader csvReader = new CsvReader((Reader)new FileReader(auxdataDir.resolve(bandInfoFileName).toString()), new char[]{'|', '\t'});){
            readStringRecords = csvReader.readStringRecords();
        }
        return readStringRecords;
    }

    public static double[][] auxDataInFlatTable(List<String[]> loadAuxdata, int columnLen) {
        for (int i = 0; i < loadAuxdata.size(); ++i) {
            String[] p = loadAuxdata.get(i);
            if (p.length > 0) continue;
            loadAuxdata.remove(p);
        }
        double[][] tableEntry = new double[loadAuxdata.size()][columnLen];
        for (int i = 1; i < loadAuxdata.size(); ++i) {
            String[] val = loadAuxdata.get(i);
            if (val.length <= 0) continue;
            String indexValue = val[0];
            StringTokenizer stringTokenizer = new StringTokenizer(indexValue, " \t", false);
            int column = 0;
            while (stringTokenizer.hasMoreElements()) {
                String token = stringTokenizer.nextToken();
                tableEntry[i - 1][column] = Double.valueOf(token);
                ++column;
            }
        }
        return tableEntry;
    }

    private void loadDetectorData(String detectorWavelengthsFilename, String detectorSunSpectralFluxesFilename, int numRows, int numCols) throws IOException {
        this.detectorWavelengths = this.loadFlatAuxDataFile(detectorWavelengthsFilename, numRows, numCols);
        this.detectorSunSpectralFluxes = this.loadFlatAuxDataFile(detectorSunSpectralFluxesFilename, numRows, numCols);
    }

    private double[][] loadFlatAuxDataFile(String auxFileName, int numRows, int numCols) throws IOException {
        double[][] tableData = new double[numRows][numCols];
        Object ioError = null;
        try (BufferedReader reader = this.openFlatAuxDataFile(auxFileName);){
            SmileCorrectionAuxdata.readFlatAuxDataFile(tableData, reader);
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
        return tableData;
    }

    private BufferedReader openFlatAuxDataFile(String fileName) throws IOException {
        assert (fileName != null);
        assert (fileName.length() > 0);
        return Files.newBufferedReader(SmileCorrectionAuxdata.installAuxdata().resolve(fileName));
    }

    private static void readFlatAuxDataFile(double[][] xrWLs, BufferedReader reader) throws IOException {
        String line;
        int numRows = xrWLs.length;
        int numCols = xrWLs[0].length;
        int row = -1;
        while ((line = reader.readLine()) != null) {
            if (row >= 0 && row < numRows) {
                StringTokenizer st = new StringTokenizer(line, " \t", false);
                int col = -1;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (col >= 0 && col < numCols) {
                        xrWLs[row][col] = Double.parseDouble(token);
                    }
                    ++col;
                }
            }
            ++row;
        }
    }

    static Path installAuxdata() throws IOException {
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi spi = operatorSpiRegistry.getOperatorSpi("SmileCorrection.Olci");
        String version = "v" + spi.getOperatorDescriptor().getVersion();
        Path auxdataDirectory = SystemUtils.getAuxDataPath().resolve("olci/smile/" + version);
        Path sourceDirPath = ResourceInstaller.findModuleCodeBasePath(SmileCorrectionAuxdata.class).resolve("auxdata/smile");
        ResourceInstaller resourceInstaller = new ResourceInstaller(sourceDirPath, auxdataDirectory);
        resourceInstaller.install(".*", ProgressMonitor.NULL);
        return auxdataDirectory;
    }
}

