/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.smilecorr;

public class SmileCorrectionAlgorithm {
    public static float correctWithReflectance(float sourceReflectance, float lowerReflectance, float upperReflectance, float sourceTargetLambda, float lowerLambda, float upperLambda, float refCentralWaveLength) {
        double dl = (refCentralWaveLength - sourceTargetLambda) / (upperLambda - lowerLambda);
        double dr = (double)(upperReflectance - lowerReflectance) * dl;
        return (float)((double)sourceReflectance + dr);
    }

    public static float correctionWithRadiance(float sourceRadiance, float lowerRadiance, float upperRadiance, float sourceTargetLambda, float lowerLambda, float upperLambda, float refCentralWL, float sourceFlux, float E0, float E0L, float E0U) {
        float r0 = sourceRadiance / sourceFlux;
        float rc = r0 * E0;
        float r2 = upperRadiance / E0U;
        float r1 = lowerRadiance / E0L;
        double dl = (refCentralWL - sourceTargetLambda) / (upperLambda - lowerLambda);
        double dr = (double)(r2 - r1) * dl * (double)E0;
        return (float)((double)rc + dr);
    }
}

