/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.rayleigh;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.media.jai.Interpolation;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolator;

public class SpikeInterpolation {
    public static double interpolate2D(double[][] doubles2D, double[] xCoordinate, double[] yCoordinate, double x, double y) {
        double x1 = SpikeInterpolation.getLowerBound(xCoordinate, x);
        double y1 = SpikeInterpolation.getLowerBound(yCoordinate, y);
        double x2 = SpikeInterpolation.getUpperValue(xCoordinate, x);
        double y2 = SpikeInterpolation.getUpperValue(yCoordinate, y);
        int ix1 = SpikeInterpolation.arrayIndex(xCoordinate, x1);
        int ix2 = SpikeInterpolation.arrayIndex(xCoordinate, x2);
        int iy1 = SpikeInterpolation.arrayIndex(yCoordinate, y1);
        int iy2 = SpikeInterpolation.arrayIndex(yCoordinate, y2);
        double f11 = doubles2D[ix1][iy1];
        double f12 = doubles2D[ix1][iy2];
        double f21 = doubles2D[ix2][iy1];
        double f22 = doubles2D[ix2][iy2];
        double q11 = SpikeInterpolation.interBetween(f11, f21, x2, x1, x);
        double q12 = SpikeInterpolation.interBetween(f12, f22, x2, x1, x);
        double interpolateValue = SpikeInterpolation.interBetween(q11, q12, y2, y1, y);
        return interpolateValue;
    }

    private static void doExtrapolation() {
    }

    public static double[] useLibJAI(double[][] samples, float xfrac, float yfrac) {
        Interpolation interpolation = Interpolation.getInstance((int)1);
        double interpolateBI = interpolation.interpolate(samples, xfrac, yfrac);
        return new double[]{interpolateBI};
    }

    public static double useApacheMath(double[] xval, double[] yval, double[][] fval, double x, double y) {
        BicubicSplineInterpolator interpolator = new BicubicSplineInterpolator();
        BicubicSplineInterpolatingFunction interpolate = interpolator.interpolate(xval, yval, fval);
        return interpolate.value(x, y);
    }

    public static double interBetween(double lowerY1, double upperY2, double upperX2, double lowerX1, double position) {
        return lowerY1 + (upperY2 - lowerY1) * (position - lowerX1) / (upperX2 - lowerX1);
    }

    public static int arrayIndex(double[] xCoordinate, double val) {
        return Doubles.asList((double[])xCoordinate).indexOf(val);
    }

    public static double getUpperValue(double[] doubles, double val) {
        ArrayList xMin = new ArrayList();
        int length = doubles.length;
        IntStream.range(0, length).forEach(i -> {
            double v = doubles[i];
            if (v >= val) {
                xMin.add(v);
            }
        });
        double[] allMax = Doubles.toArray(xMin);
        if (allMax.length == 0) {
            throw new IllegalArgumentException("Can fine the closest max value of " + val);
        }
        return Doubles.min((double[])allMax);
    }

    public static double getLowerBound(double[] doubles, double val) {
        double[] xMin = new double[1];
        int length = doubles.length;
        IntStream.range(0, length).forEach(i -> {
            double v = doubles[i];
            xMin[0] = v < val ? v : xMin[0];
        });
        if (xMin[0] > val) {
            throw new IllegalArgumentException("Can find the closest min value of " + val);
        }
        return xMin[0];
    }
}

