/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.rayleigh;

import com.bc.ceres.core.ProgressMonitor;
import com.google.common.primitives.Doubles;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolator;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.esa.s3tbx.olci.radiometry.rayleigh.SpikeInterpolation;
import org.esa.s3tbx.olci.radiometry.smilecorr.SmileCorrectionUtils;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class RayleighAux {
    public static final String GETASSE_30 = "GETASSE30";
    public static final String COEFF_MATRIX_TXT = "coeffMatrix.txt";
    public static final String TAU_RAY = "tau_ray";
    public static final String THETA = "theta";
    public static final String RAY_COEFF_MATRIX = "ray_coeff_matrix";
    public static final String RAY_ALBEDO_LUT = "ray_albedo_lut";
    public static PolynomialSplineFunction linearInterpolate;
    public static double[] tau_ray;
    private static ElevationModel elevationModel;
    private static double[] thetas;
    private static double[][][] rayCooefMatrixA;
    private static double[][][] rayCooefMatrixB;
    private static double[][][] rayCooefMatrixC;
    private static double[][][] rayCooefMatrixD;
    private double[] sunZenithAngles;
    private double[] viewZenithAngles;
    private double[] sunAzimuthAngles;
    private double[] viewAzimuthAngles;
    private double[] seaLevels;
    private double[] totalOzones;
    private double[] latitudes;
    private double[] solarFluxs;
    private double[] lambdaSource;
    private double[] sourceSampleRad;
    private int sourceBandIndex;
    private float waveLength;
    private String sourceBandName;
    private double[] longitude;
    private double[] altitudes;
    private Map<Integer, double[]> fourierPoly;
    private Map<Integer, List<double[]>> interpolateMap;
    private double[] viewAzimuthAnglesRad;
    private double[] sunZenithAnglesRad;
    private double[] sunAzimuthAnglesRad;
    private double[] viewZenithAnglesRad;
    private double[] aziDiff;
    private double[] cosSZARads;
    private double[] sinOZARads;
    private double[] sinSZARads;
    private double[] cosOZARads;
    private double[] airMass;

    public static double[] parseJSON1DimArray(JSONObject parse, String ray_coeff_matrix) {
        JSONArray theta = (JSONArray)parse.get((Object)ray_coeff_matrix);
        List collect = theta.stream().collect(Collectors.toList());
        return Doubles.toArray(collect);
    }

    public static void initDefaultAuxiliary() {
        try {
            ElevationModelDescriptor getasse30 = ElevationModelRegistry.getInstance().getDescriptor(GETASSE_30);
            elevationModel = getasse30.createDem(Resampling.NEAREST_NEIGHBOUR);
            Path coeffMatrix = RayleighAux.installAuxdata().resolve(COEFF_MATRIX_TXT);
            JSONParser jsonObject = new JSONParser();
            JSONObject parse = (JSONObject)jsonObject.parse((Reader)new FileReader(coeffMatrix.toString()));
            tau_ray = RayleighAux.parseJSON1DimArray(parse, TAU_RAY);
            thetas = RayleighAux.parseJSON1DimArray(parse, THETA);
            ArrayList<double[][][]> ray_coeff_matrix = RayleighAux.parseJSON3DimArray(parse, RAY_COEFF_MATRIX);
            rayCooefMatrixA = ray_coeff_matrix.get(0);
            rayCooefMatrixB = ray_coeff_matrix.get(1);
            rayCooefMatrixC = ray_coeff_matrix.get(2);
            rayCooefMatrixD = ray_coeff_matrix.get(3);
            double[] lineSpace = RayleighAux.getLineSpace(0.0, 1.0, 17);
            double[] rayAlbedoLuts = RayleighAux.parseJSON1DimArray(parse, RAY_ALBEDO_LUT);
            linearInterpolate = new LinearInterpolator().interpolate(lineSpace, rayAlbedoLuts);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
    }

    public void setSolarFluxs(double[] solarFluxs) {
        this.solarFluxs = solarFluxs;
    }

    public void setLambdaSource(double[] lambdaSource) {
        this.lambdaSource = lambdaSource;
    }

    public void setAltitudes(Tile altitude) {
        this.altitudes = SmileCorrectionUtils.getSampleDoubles(altitude);
    }

    public double[] getTaur() {
        return tau_ray;
    }

    public double[] getAltitudes() {
        if (Objects.isNull(this.altitudes)) {
            double[] longitudes = this.getLongitude();
            double[] latitudes = this.getLatitudes();
            if (Objects.nonNull(longitudes) && Objects.nonNull(latitudes)) {
                double[] elevation = new double[latitudes.length];
                for (int i = 0; i < longitudes.length; ++i) {
                    try {
                        elevation[i] = elevationModel.getElevation(new GeoPos(latitudes[i], longitudes[i]));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.altitudes = elevation;
            }
        }
        return this.altitudes;
    }

    public void setAltitudes(double ... alt) {
        this.altitudes = alt;
    }

    public Map<Integer, List<double[]>> getInterpolation() {
        if (Objects.isNull(this.interpolateMap)) {
            this.interpolateMap = this.getSpikeInterpolation();
        }
        return this.interpolateMap;
    }

    public void setInterpolation(HashMap<Integer, List<double[]>> integerHashMap) {
        this.interpolateMap = integerHashMap;
    }

    public Map<Integer, List<double[]>> getSpikeInterpolation() {
        double[] sunZenithAngles = this.getSunZenithAngles();
        double[] viewZenithAngles = this.getViewZenithAngles();
        HashMap<Integer, List<double[]>> interpolate = new HashMap<Integer, List<double[]>>();
        if (Objects.nonNull(sunZenithAngles) && Objects.nonNull(viewZenithAngles)) {
            for (int index = 0; index < sunZenithAngles.length; ++index) {
                double yVal = viewZenithAngles[index];
                double xVal = sunZenithAngles[index];
                double thetaMin = thetas[0];
                double thetaMax = thetas[thetas.length - 1];
                ArrayList<double[]> valueList = new ArrayList<double[]>();
                for (int i = 0; i < rayCooefMatrixA.length; ++i) {
                    double[] values = new double[4];
                    if (yVal > thetaMin && yVal < thetaMax && xVal > thetaMin && xVal < thetaMax) {
                        values[0] = SpikeInterpolation.interpolate2D(rayCooefMatrixA[i], thetas, thetas, xVal, yVal);
                        values[1] = SpikeInterpolation.interpolate2D(rayCooefMatrixB[i], thetas, thetas, xVal, yVal);
                        values[2] = SpikeInterpolation.interpolate2D(rayCooefMatrixC[i], thetas, thetas, xVal, yVal);
                        values[3] = SpikeInterpolation.interpolate2D(rayCooefMatrixD[i], thetas, thetas, xVal, yVal);
                        valueList.add(values);
                        continue;
                    }
                    if (yVal < thetaMin && xVal < thetaMax) {
                        valueList.add(this.getGridValueAt(0, 0));
                        continue;
                    }
                    int len = thetas.length - 1;
                    if (yVal > thetaMax && xVal > thetaMin) {
                        valueList.add(this.getGridValueAt(0, len));
                        continue;
                    }
                    if (xVal < thetaMin && yVal < thetaMax) {
                        valueList.add(this.getGridValueAt(0, 0));
                        continue;
                    }
                    if (!(yVal > thetaMax) || !(xVal < thetaMin)) continue;
                    valueList.add(this.getGridValueAt(len, len));
                }
                interpolate.put(index, valueList);
            }
        }
        return interpolate;
    }

    public Map<Integer, double[]> getFourier() {
        if (Objects.isNull(this.fourierPoly)) {
            this.fourierPoly = this.getFourierMap();
            return this.fourierPoly;
        }
        return this.fourierPoly;
    }

    public void setWavelength(float waveLength) {
        this.waveLength = waveLength;
    }

    public double getWaveLength() {
        return this.waveLength;
    }

    public String getSourceBandName() {
        return this.sourceBandName;
    }

    public void setSourceBandName(String targetBandName) {
        this.sourceBandName = targetBandName;
    }

    public double[] getSunAzimuthAnglesRad() {
        if (Objects.nonNull(this.sunAzimuthAnglesRad)) {
            return this.sunAzimuthAnglesRad;
        }
        throw new NullPointerException("The sun azimuth angles is null.");
    }

    public void setSunAzimuthAnglesRad(double[] sunAzimuthAngles) {
        if (Objects.nonNull(sunAzimuthAngles)) {
            this.sunAzimuthAnglesRad = SmileCorrectionUtils.convertDegreesToRadians(sunAzimuthAngles);
        }
    }

    public double[] getViewAzimuthAnglesRad() {
        if (Objects.nonNull(this.viewAzimuthAnglesRad)) {
            return this.viewAzimuthAnglesRad;
        }
        throw new NullPointerException("The view azimuth angles is null.");
    }

    public void setViewAzimuthAnglesRad(double[] viewAzimuthAngles) {
        if (Objects.nonNull(viewAzimuthAngles)) {
            this.viewAzimuthAnglesRad = SmileCorrectionUtils.convertDegreesToRadians(viewAzimuthAngles);
        }
    }

    public double[] getSunZenithAnglesRad() {
        if (Objects.nonNull(this.sunZenithAnglesRad)) {
            return this.sunZenithAnglesRad;
        }
        throw new NullPointerException("The sun zenith angles is null.");
    }

    public void setSunZenithAnglesRad(double[] sunZenithAngles) {
        if (Objects.nonNull(sunZenithAngles)) {
            this.sunZenithAnglesRad = SmileCorrectionUtils.convertDegreesToRadians(sunZenithAngles);
        }
        this.setCosSZARads(this.sunZenithAnglesRad);
        this.setSinSZARads(this.sunZenithAnglesRad);
    }

    public double[] getViewZenithAnglesRad() {
        if (Objects.nonNull(this.viewZenithAnglesRad)) {
            return this.viewZenithAnglesRad;
        }
        throw new NullPointerException("The view zenith angles is null.");
    }

    public void setViewZenithAnglesRad(double[] viewZenithAngles) {
        if (Objects.nonNull(viewZenithAngles)) {
            this.viewZenithAnglesRad = SmileCorrectionUtils.convertDegreesToRadians(viewZenithAngles);
        }
        this.setCosOZARads(this.viewZenithAnglesRad);
        this.setSinOZARads(this.viewZenithAnglesRad);
    }

    public double[] getAirMass() {
        if (Objects.isNull(this.airMass)) {
            this.airMass = SmileCorrectionUtils.getAirMass(this.getCosOZARads(), this.getCosSZARads());
        }
        return this.airMass;
    }

    public double[] getAziDifferent() {
        if (Objects.isNull(this.aziDiff)) {
            this.aziDiff = SmileCorrectionUtils.getAziDiff(this.getSunAzimuthAnglesRad(), this.getViewAzimuthAnglesRad());
        }
        return this.aziDiff;
    }

    public double[] getCosSZARads() {
        if (Objects.nonNull(this.cosSZARads)) {
            return this.cosSZARads;
        }
        throw new NullPointerException("The sun zenith angles is null.");
    }

    public void setCosSZARads(double[] sunZenithAnglesRad) {
        if (Objects.nonNull(sunZenithAnglesRad)) {
            this.cosSZARads = Arrays.stream(sunZenithAnglesRad).map(Math::cos).toArray();
        }
    }

    public double[] getCosOZARads() {
        if (Objects.nonNull(this.cosOZARads)) {
            return this.cosOZARads;
        }
        throw new NullPointerException("The view zenith angles is null.");
    }

    public void setCosOZARads(double[] zenithAnglesRad) {
        if (Objects.nonNull(zenithAnglesRad)) {
            this.cosOZARads = Arrays.stream(zenithAnglesRad).map(Math::cos).toArray();
        }
    }

    public double[] getSinSZARads() {
        if (Objects.nonNull(this.sinSZARads)) {
            return this.sinSZARads;
        }
        throw new NullPointerException("The sun zenith angles is null.");
    }

    public void setSinSZARads(double[] sunZenithAnglesRad) {
        if (Objects.nonNull(sunZenithAnglesRad)) {
            this.sinSZARads = Arrays.stream(sunZenithAnglesRad).map(Math::sin).toArray();
        }
    }

    public double[] getSinOZARads() {
        if (Objects.nonNull(this.sinOZARads)) {
            return this.sinOZARads;
        }
        throw new NullPointerException("The view zenith angles is null.");
    }

    public void setSinOZARads(double[] zenithAnglesRad) {
        if (Objects.nonNull(zenithAnglesRad)) {
            this.sinOZARads = Arrays.stream(zenithAnglesRad).map(Math::sin).toArray();
        }
    }

    public double[] getSunZenithAngles() {
        return this.sunZenithAngles;
    }

    public void setSunZenithAngles(Tile sourceTile) {
        this.sunZenithAngles = SmileCorrectionUtils.getSampleDoubles(sourceTile);
        this.setSunZenithAnglesRad(this.sunZenithAngles);
    }

    public void setSunZenithAngles(double ... sunZenithAngles) {
        this.sunZenithAngles = sunZenithAngles;
        this.setSunZenithAnglesRad(sunZenithAngles);
    }

    public double[] getViewZenithAngles() {
        return this.viewZenithAngles;
    }

    public void setViewZenithAngles(double ... viewZenithAngles) {
        this.viewZenithAngles = viewZenithAngles;
        this.setViewZenithAnglesRad(viewZenithAngles);
    }

    public void setViewZenithAngles(Tile sourceTile) {
        this.viewZenithAngles = SmileCorrectionUtils.getSampleDoubles(sourceTile);
        this.setViewZenithAnglesRad(this.viewZenithAngles);
    }

    public double[] getSunAzimuthAngles() {
        return this.sunAzimuthAngles;
    }

    public void setSunAzimuthAngles(double ... sunAzimuthAngles) {
        this.sunAzimuthAngles = sunAzimuthAngles;
        this.setSunAzimuthAnglesRad(sunAzimuthAngles);
    }

    public void setSunAzimuthAngles(Tile sourceTile) {
        this.sunAzimuthAngles = SmileCorrectionUtils.getSampleDoubles(sourceTile);
        this.setSunAzimuthAnglesRad(this.sunAzimuthAngles);
    }

    public double[] getLatitudes() {
        return this.latitudes;
    }

    public void setLatitudes(double ... lat) {
        this.latitudes = lat;
    }

    public void setLatitudes(Tile sourceTile) {
        this.latitudes = SmileCorrectionUtils.getSampleDoubles(sourceTile);
    }

    public double[] getViewAzimuthAngles() {
        return this.viewAzimuthAngles;
    }

    public void setViewAzimuthAngles(double ... viewAzimuthAngles) {
        this.viewAzimuthAngles = viewAzimuthAngles;
        this.setViewAzimuthAnglesRad(viewAzimuthAngles);
    }

    public void setViewAzimuthAngles(Tile sourceTile) {
        this.viewAzimuthAngles = SmileCorrectionUtils.getSampleDoubles(sourceTile);
        this.setViewAzimuthAnglesRad(this.viewAzimuthAngles);
    }

    public double[] getSeaLevels() {
        return this.seaLevels;
    }

    public void setSeaLevels(double ... seaLevels) {
        this.seaLevels = seaLevels;
    }

    public void setSeaLevels(Tile sourceTile) {
        this.seaLevels = SmileCorrectionUtils.getSampleDoubles(sourceTile);
    }

    public double[] getTotalOzones() {
        return this.totalOzones;
    }

    public void setTotalOzones(double ... totalO) {
        this.totalOzones = totalO;
    }

    public void setTotalOzones(Tile sourceTile) {
        this.totalOzones = SmileCorrectionUtils.getSampleDoubles(sourceTile);
    }

    public double[] getSolarFluxs() {
        return this.solarFluxs;
    }

    public void setSolarFluxs(Tile sourceTile) {
        this.solarFluxs = SmileCorrectionUtils.getSampleDoubles(sourceTile);
    }

    public double[] getLambdaSource() {
        return this.lambdaSource;
    }

    public void setLambdaSource(Tile sourceTile) {
        this.lambdaSource = SmileCorrectionUtils.getSampleDoubles(sourceTile);
    }

    public double[] getSourceSampleRad() {
        return this.sourceSampleRad;
    }

    public void setSourceSampleRad(Tile sourceTile) {
        this.sourceSampleRad = SmileCorrectionUtils.getSampleDoubles(sourceTile);
    }

    public int getSourceBandIndex() {
        return this.sourceBandIndex;
    }

    public void setSourceBandIndex(int sourceBandIndex) {
        this.sourceBandIndex = sourceBandIndex;
    }

    public double[] getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double ... longitude) {
        this.longitude = longitude;
    }

    public void setLongitude(Tile sourceTile) {
        this.longitude = SmileCorrectionUtils.getSampleDoubles(sourceTile);
    }

    public double[] getInterpolateRayleighThickness(double ... taur) {
        if (Objects.nonNull(taur)) {
            double[] val = new double[taur.length];
            for (int i = 0; i < taur.length; ++i) {
                val[i] = linearInterpolate.value(taur[i]);
            }
            return val;
        }
        throw new NullPointerException("The linearInterpolate Rayleigh thickness is empty.");
    }

    public double[] getSquarePower(double[] sinOZARads) {
        if (Objects.nonNull(sinOZARads)) {
            return Arrays.stream(sinOZARads).map(p -> Math.pow(p, 2.0)).toArray();
        }
        throw new NullPointerException("The array is null.");
    }

    private double[] getGridValueAt(int x, int y) {
        double[] values = new double[]{rayCooefMatrixA[x][y][0], rayCooefMatrixB[x][y][0], rayCooefMatrixC[x][y][0], rayCooefMatrixD[x][y][0]};
        return values;
    }

    private Map<Integer, double[]> getFourierMap() {
        HashMap<Integer, double[]> fourierPoly = new HashMap<Integer, double[]>();
        double[] sunZenithAnglesRad = this.getSunZenithAnglesRad();
        double[] viewZenithAnglesRad = this.getViewZenithAnglesRad();
        double[] cosSZARads = this.getCosSZARads();
        double[] cosOZARads = this.getCosOZARads();
        double[] sinSZARads = this.getSinSZARads();
        double[] sinOZARads = this.getSinOZARads();
        double[] sinOZA2s = this.getSquarePower(sinOZARads);
        double[] sinSZA2s = this.getSquarePower(sinSZARads);
        if (Objects.nonNull(sunZenithAnglesRad) && Objects.nonNull(viewZenithAnglesRad)) {
            for (int index = 0; index < sunZenithAnglesRad.length; ++index) {
                double cosSZARad = cosSZARads[index];
                double cosOZARad = cosOZARads[index];
                double sinSZARad = sinSZARads[index];
                double sinOZARad = sinOZARads[index];
                double sinSZA2 = sinSZA2s[index];
                double sinOZA2 = sinOZA2s[index];
                double[] fourierSeries = new double[]{0.7190441999999999 * (1.0 + cosSZARad * cosSZARad * (cosOZARad * cosOZARad) + sinSZA2 * sinOZA2 / 2.0) + 0.041274400000000044, -0.7190441999999999 * cosSZARad * cosOZARad * sinSZARad * sinOZARad, 0.17976104999999998 * sinSZA2 * sinOZA2};
                fourierPoly.put(index, fourierSeries);
            }
            return fourierPoly;
        }
        throw new NullPointerException("The Fourier polynomial is empty.");
    }

    static Path installAuxdata() throws IOException {
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi spi = operatorSpiRegistry.getOperatorSpi("RayleighCorrection");
        String version = "v" + spi.getOperatorDescriptor().getVersion();
        Path auxdataDirectory = SystemUtils.getAuxDataPath().resolve("olci/rayleigh/" + version);
        Path sourceDirPath = ResourceInstaller.findModuleCodeBasePath(RayleighAux.class).resolve("auxdata/rayleigh");
        ResourceInstaller resourceInstaller = new ResourceInstaller(sourceDirPath, auxdataDirectory);
        resourceInstaller.install(".*", ProgressMonitor.NULL);
        return auxdataDirectory;
    }

    static ArrayList<double[][][]> parseJSON3DimArray(JSONObject parse, String ray_coeff_matrix) {
        JSONArray theta = (JSONArray)parse.get((Object)ray_coeff_matrix);
        Iterator iterator1 = theta.iterator();
        double[][][] rayCooffA = new double[3][12][12];
        double[][][] rayCooffB = new double[3][12][12];
        double[][][] rayCooffC = new double[3][12][12];
        double[][][] rayCooffD = new double[3][12][12];
        int k = 0;
        while (iterator1.hasNext()) {
            JSONArray next = (JSONArray)iterator1.next();
            Iterator iterator2 = next.iterator();
            int i1 = 0;
            while (iterator2.hasNext()) {
                JSONArray iterator3 = (JSONArray)iterator2.next();
                Iterator iterator4 = iterator3.iterator();
                for (int j = 0; j < 12; ++j) {
                    JSONArray mainValue = (JSONArray)iterator4.next();
                    List collectedValues = mainValue.stream().collect(Collectors.toList());
                    rayCooffA[k][i1][j] = (Double)collectedValues.get(0);
                    rayCooffB[k][i1][j] = (Double)collectedValues.get(1);
                    rayCooffC[k][i1][j] = (Double)collectedValues.get(2);
                    rayCooffD[k][i1][j] = (Double)collectedValues.get(3);
                }
                ++i1;
            }
            ++k;
        }
        ArrayList<double[][][]> rayCoefficient = new ArrayList<double[][][]>();
        rayCoefficient.add(rayCooffA);
        rayCoefficient.add(rayCooffB);
        rayCoefficient.add(rayCooffC);
        rayCoefficient.add(rayCooffD);
        return rayCoefficient;
    }

    static double[] getLineSpace(double start, double end, int interval) {
        if (interval < 0) {
            throw new NegativeArraySizeException("Array must not have negative index");
        }
        double[] temp = new double[interval];
        double steps = (end - start) / (double)(interval - 1);
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = steps * (double)i;
        }
        return temp;
    }

    void setInterpolation() {
        BicubicSplineInterpolator gridInterpolator = new BicubicSplineInterpolator();
        HashMap<Integer, List<double[]>> interpolate = new HashMap<Integer, List<double[]>>();
        double[] sunZenithAngles = this.getSunZenithAngles();
        double[] viewZenithAngles = this.getViewZenithAngles();
        assert (sunZenithAngles != null);
        if (Objects.nonNull(sunZenithAngles) && Objects.nonNull(viewZenithAngles)) {
            for (int index = 0; index < sunZenithAngles.length; ++index) {
                double yVal = viewZenithAngles[index];
                double xVal = sunZenithAngles[index];
                ArrayList<double[]> valueList = new ArrayList<double[]>();
                for (int i = 0; i < rayCooefMatrixA.length; ++i) {
                    double thetaMin = thetas[0];
                    double thetaMax = thetas[thetas.length - 1];
                    if (yVal > thetaMin && yVal < thetaMax) {
                        double[] values = new double[]{gridInterpolator.interpolate(thetas, thetas, rayCooefMatrixA[i]).value(xVal, yVal), gridInterpolator.interpolate(thetas, thetas, rayCooefMatrixB[i]).value(xVal, yVal), gridInterpolator.interpolate(thetas, thetas, rayCooefMatrixC[i]).value(xVal, yVal), gridInterpolator.interpolate(thetas, thetas, rayCooefMatrixD[i]).value(xVal, yVal)};
                        valueList.add(values);
                        continue;
                    }
                    valueList.add(new double[]{0.0, 0.0, 0.0, 0.0});
                }
                interpolate.put(index, valueList);
            }
            this.interpolateMap = interpolate;
        }
    }
}

