/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.operator;

import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="OLCI.Radiomerty", description="Performs radiometric corrections on OLCI L1b data products.", authors=" Marco Peters ,Muhammad Bala (Brockmann Consult)", copyright="(c) 2015 by Brockmann Consult", category="Optical/Pre-Processing", version="1.2")
public class Radiometry
extends Operator {
    @SourceProduct
    public Product sourceProduct;
    private Product targetProduct;

    public void initialize() throws OperatorException {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        for (Band band : this.sourceProduct.getBands()) {
            Band targetBand = this.targetProduct.addBand(band.getName(), band.getDataType());
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)band, (RasterDataNode)targetBand);
        }
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setAutoGrouping(this.sourceProduct.getAutoGrouping());
        this.setTargetProduct(this.targetProduct);
    }

    private Product getSmileProduct(Product sourceProduct) {
        HashMap parameters = new HashMap();
        return GPF.createProduct((String)"SmileCorrection.Olci", parameters, (Product)sourceProduct);
    }
}

