/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.gasabsorption;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.olci.radiometry.Sensor;
import org.esa.s3tbx.olci.radiometry.gasabsorption.GaseousAbsorptionAlgo;
import org.esa.s3tbx.olci.radiometry.smilecorr.SmileCorrectionUtils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="GaseousAbsorption", internal=true, authors="Marco Peters, Muhamamd Bala (Brockmann Consult)", copyright="(c) 2016 by Brockmann Consult", version="1.0", description="Correct the influence of atmospheric gas absorption for those OLCI channels.")
public class GaseousAbsorptionOp
extends Operator {
    public static final String SZA = "SZA";
    public static final String OZA = "OZA";
    @SourceProduct(description="OLCI Reflectance product")
    Product sourceProduct;
    private Product targetProduct;
    private GaseousAbsorptionAlgo gasAbsorptionAlgo = new GaseousAbsorptionAlgo();

    public void initialize() throws OperatorException {
        Sensor sensorType = SmileCorrectionUtils.getSensorType(this.sourceProduct);
        if (!Sensor.OLCI.equals((Object)sensorType)) {
            throw new OperatorException("The sensor type is not supported with this operator.");
        }
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        for (int i = 1; i <= 21; ++i) {
            Band targetBand = this.targetProduct.addBand(String.format("gaseous_absorp_%02d", i), 30);
            Band sourceBand = this.sourceProduct.getBand(String.format("Oa%02d_radiance", i));
            targetBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
            targetBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
            targetBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
            targetBand.setTimeCoding(sourceBand.getTimeCoding());
        }
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyMasks((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        ProductUtils.copyGeoCoding((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setAutoGrouping(this.sourceProduct.getAutoGrouping());
        this.setTargetProduct(this.targetProduct);
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        this.checkForCancellation();
        Rectangle rectangle = targetTile.getRectangle();
        String targetBandName = targetBand.getName();
        float[] computedGases = this.computeGas(targetBandName, rectangle, this.sourceProduct);
        targetTile.setSamples(computedGases);
    }

    private float[] computeGas(String bandName, Rectangle rectangle, Product sourceProduct) {
        float[] szas = this.getSourceTile((RasterDataNode)sourceProduct.getTiePointGrid(SZA), rectangle).getSamplesFloat();
        float[] ozas = this.getSourceTile((RasterDataNode)sourceProduct.getTiePointGrid(OZA), rectangle).getSamplesFloat();
        return this.gasAbsorptionAlgo.getTransmissionGas(bandName, szas, ozas);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GaseousAbsorptionOp.class);
        }
    }
}

