/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.gasabsorption;

import com.bc.ceres.core.ProgressMonitor;
import com.google.common.primitives.Doubles;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.CsvReader;

public class GaseousAbsorptionAux {
    private List<double[]> ozoneHighs;
    private List<double[]> coeffhighres = new ArrayList<double[]>();

    GaseousAbsorptionAux() {
        try {
            Path installAuxdata = this.installAuxdata();
            Path resolve = installAuxdata.resolve("ozone-highres.txt");
            FileReader fileReader = new FileReader(resolve.toString());
            CsvReader reader = new CsvReader((Reader)fileReader, new char[]{' ', '\t'}, true, "#");
            this.ozoneHighs = reader.readDoubleRecords();
            this.coeffhighres = this.getCoeffhighres(this.ozoneHighs);
            fileReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static GaseousAbsorptionAux getInstance() {
        return Holder.instance;
    }

    public List<double[]> getOzoneHighs() {
        return this.ozoneHighs;
    }

    public List<double[]> getCoeffhighres(List<double[]> ozoneHighs) {
        ArrayList<Double> o3wavelengthList = new ArrayList<Double>();
        ArrayList<Double> o3absorptionList = new ArrayList<Double>();
        for (double[] ozoneHigh : ozoneHighs) {
            o3wavelengthList.add(ozoneHigh[0]);
            o3absorptionList.add(ozoneHigh[1]);
        }
        ArrayList<double[]> O3Main = new ArrayList<double[]>();
        O3Main.add(Doubles.toArray(o3wavelengthList));
        O3Main.add(Doubles.toArray(o3absorptionList));
        return O3Main;
    }

    Path installAuxdata() throws IOException {
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi spi = operatorSpiRegistry.getOperatorSpi("GaseousAbsorption");
        String version = "v" + spi.getOperatorDescriptor().getVersion();
        Path auxdataDirectory = SystemUtils.getAuxDataPath().resolve("olci/gaseous/" + version);
        Path sourceDirPath = ResourceInstaller.findModuleCodeBasePath(GaseousAbsorptionAux.class).resolve("auxdata/gaseous");
        ResourceInstaller resourceInstaller = new ResourceInstaller(sourceDirPath, auxdataDirectory);
        resourceInstaller.install(".*", ProgressMonitor.NULL);
        return auxdataDirectory;
    }

    public double convolve(double lower, double upper, List<double[]> coeffhighres) {
        double[] o3absorption = coeffhighres.get(1);
        double[] O3wavelength = coeffhighres.get(0);
        int length = o3absorption.length;
        int weight = 0;
        double totalValue = 0.0;
        for (int i = 0; i < length; ++i) {
            if (!(O3wavelength[i] >= lower) || !(O3wavelength[i] <= upper)) continue;
            ++weight;
            totalValue += o3absorption[i];
        }
        return totalValue / (double)weight;
    }

    public double[] absorptionOzone(String instrument) {
        double[] lamC;
        ArrayList<Double> o3absorpInstrument = new ArrayList<Double>();
        if (instrument.equals("MERIS")) {
            double[] absorb_ozon = new double[]{2.174E-4, 0.0034448, 0.0205669, 0.0400134, 0.105446, 0.1081787, 0.0501634, 0.0349671, 0.0187495, 0.0086322, 1.0E-7, 0.0084989, 0.0018944, 0.0012369, 1.0E-6};
            lamC = new double[]{412.5, 442.0, 490.0, 510.0, 560.0, 620.0, 665.0, 681.25, 708.75, 753.0, 761.25, 779.0, 865.0, 885.0, 900.0};
            double[] lamW = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 3.075, 10.0, 20.0, 20.0, 40.0};
            for (int i = 0; i < lamC.length; ++i) {
                double lower = lamC[i] - lamW[i] / 2.0;
                double upper = lamC[i] + lamW[i] / 2.0;
                o3absorpInstrument.add(this.convolve(lower, upper, this.coeffhighres));
            }
        }
        if (instrument.equals("OLCI")) {
            lamC = new double[]{400.0, 412.5, 442.0, 490.0, 510.0, 560.0, 620.0, 665.0, 673.75, 681.25, 708.75, 753.75, 761.25, 764.375, 767.5, 778.75, 865.0, 885.0, 900.0, 940.0, 1020.0};
            double[] lamW = new double[]{15.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 7.05, 7.05, 10.0, 7.05, 2.05, 3.075, 2.05, 15.0, 20.0, 10.0, 10.0, 20.0, 40.0};
            for (int i = 0; i < lamC.length; ++i) {
                double lower = lamC[i] - lamW[i] / 2.0;
                double upper = lamC[i] + lamW[i] / 2.0;
                o3absorpInstrument.add(this.convolve(lower, upper, this.coeffhighres));
            }
        }
        return Doubles.toArray(o3absorpInstrument);
    }

    private static class Holder {
        private static final GaseousAbsorptionAux instance = new GaseousAbsorptionAux();

        private Holder() {
        }
    }
}

