/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.olci.radiometry.gasabsorption;

import com.bc.ceres.core.Assert;
import java.util.ArrayList;
import org.esa.s3tbx.olci.radiometry.gasabsorption.GasToCompute;
import org.esa.s3tbx.olci.radiometry.smilecorr.SmileCorrectionUtils;

public class GaseousAbsorptionAlgo {
    public float getAtmosphericGas(String bandName) {
        return 1.0f;
    }

    public float getNormalizedConcentration(String bandName) {
        return 1.0f;
    }

    public float getExponential(float atmosphericGas, float normConcentration, float massAir) {
        float calValue = -atmosphericGas * normConcentration * massAir;
        return (float)Math.exp(calValue);
    }

    public String[] gasToComputeForBand(String bandName) {
        GasToCompute gasToCompute = GasToCompute.valueOf(bandName);
        return gasToCompute.getGasBandToCompute();
    }

    public float[] getMassAir(float[] sza, float[] oza) {
        Assert.notNull((Object)sza, (String)"The sun zenith angel most not be null.");
        Assert.notNull((Object)oza);
        float[] szaRad = SmileCorrectionUtils.convertDegreesToRadians(sza);
        float[] ozaRad = SmileCorrectionUtils.convertDegreesToRadians(oza);
        float[] massAirs = new float[sza.length];
        for (int i = 0; i < sza.length; ++i) {
            massAirs[i] = GaseousAbsorptionAlgo.getMassAir(szaRad[i], ozaRad[i]);
        }
        return massAirs;
    }

    public static float getMassAir(float szaRad, float ozaRad) {
        return (float)(1.0 / Math.cos(szaRad) + 1.0 / Math.cos(ozaRad));
    }

    public float[] getTransmissionGas(String bandName, float[] sza, float[] oza) {
        float[] calMassAirs = this.getMassAir(sza, oza);
        String[] gasesToCompute = this.gasToComputeForBand(bandName);
        if (gasesToCompute == null) {
            return null;
        }
        ArrayList<float[]> arrayListExponential = new ArrayList<float[]>();
        for (String gas : gasesToCompute) {
            float calAtmosphericGas = this.getAtmosphericGas(gas);
            float normalizedConcentration = this.getNormalizedConcentration(gas);
            float[] calExponential = new float[oza.length];
            for (int i = 0; i < sza.length; ++i) {
                calExponential[i] = this.getExponential(calAtmosphericGas, normalizedConcentration, calMassAirs[i]);
            }
            arrayListExponential.add(calExponential);
        }
        int size = arrayListExponential.size();
        float[] transmissionGas = new float[]{};
        if (size == 1) {
            transmissionGas = (float[])arrayListExponential.get(0);
        } else if (size == 2) {
            transmissionGas = SmileCorrectionUtils.multiple2ArrayFloat((float[])arrayListExponential.get(0), (float[])arrayListExponential.get(1));
        } else if (size == 3) {
            transmissionGas = SmileCorrectionUtils.multiple3ArrayFloat((float[])arrayListExponential.get(0), (float[])arrayListExponential.get(1), (float[])arrayListExponential.get(2));
        }
        return transmissionGas;
    }
}

