/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.mphchl;

import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.esa.s3tbx.mphchl.MphChlConstants;
import org.esa.s3tbx.mphchl.MphChlOp;
import org.esa.s3tbx.mphchl.Sensor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.junit.Assert;
import org.junit.Test;

public class MphChlOpTest {
    @Test
    public void testOperatorMetadata() {
        OperatorMetadata operatorMetadata = MphChlOp.class.getAnnotation(OperatorMetadata.class);
        Assert.assertNotNull((Object)operatorMetadata);
        Assert.assertEquals((Object)"MphChl", (Object)operatorMetadata.alias());
        Assert.assertEquals((Object)"1.0", (Object)operatorMetadata.version());
        Assert.assertEquals((Object)"Mark William Matthews, Daniel Odermatt, Tom Block, Olaf Danne", (Object)operatorMetadata.authors());
        Assert.assertEquals((Object)"(c) 2013, 2014, 2017 by Brockmann Consult", (Object)operatorMetadata.copyright());
        Assert.assertEquals((Object)"This operator computes maximum peak height of chlorophyll (MPH/CHL).", (Object)operatorMetadata.description());
    }

    @Test
    public void testSourceProductAnnotation() throws NoSuchFieldException {
        Field productField = MphChlOp.class.getDeclaredField("sourceProduct");
        Assert.assertNotNull((Object)productField);
        SourceProduct productFieldAnnotation = productField.getAnnotation(SourceProduct.class);
        Assert.assertNotNull((Object)productFieldAnnotation);
    }

    @Test
    public void testCyanoMaxValueAnnotation() throws NoSuchFieldException {
        Field cyanoMaxValueField = MphChlOp.class.getDeclaredField("cyanoMaxValue");
        Parameter annotation = cyanoMaxValueField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"1000.0", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Maximum chlorophyll, arithmetically higher values are capped.", (Object)annotation.description());
    }

    @Test
    public void testChlThreshForFloatFlagAnnotation() throws NoSuchFieldException {
        Field chlThreshForFloatFlagField = MphChlOp.class.getDeclaredField("chlThreshForFloatFlag");
        Parameter annotation = chlThreshForFloatFlagField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"500.0", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Chlorophyll threshold, above which all cyanobacteria dominated waters are 'float.", (Object)annotation.description());
    }

    @Test
    public void testExportMphAnnotation() throws NoSuchFieldException {
        Field exportMphField = MphChlOp.class.getDeclaredField("exportMph");
        Parameter annotation = exportMphField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"false", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Switch to true to write 'mph' band.", (Object)annotation.description());
    }

    @Test
    public void testApplyLowPassFilterAnnotation() throws NoSuchFieldException {
        Field applyLowPassFilterField = MphChlOp.class.getDeclaredField("applyLowPassFilter");
        Parameter annotation = applyLowPassFilterField.getAnnotation(Parameter.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"false", (Object)annotation.defaultValue());
        Assert.assertEquals((Object)"Switch to true to apply a 3x3 low-pass filter on the result.", (Object)annotation.description());
    }

    @Test
    public void testGetSensorType() throws Exception {
        Product sourceProduct = new Product("test", "test", 1, 1);
        for (String bandName : MphChlConstants.MERIS_REQUIRED_RADIANCE_BAND_NAMES) {
            sourceProduct.addBand(bandName, 30);
        }
        Sensor sensor = MphChlOp.getSensorType((Product)sourceProduct);
        Assert.assertEquals((Object)sensor, (Object)Sensor.MERIS_3RD);
        sourceProduct = new Product("test2", "test2", 1, 1);
        for (String bandName : MphChlConstants.MERIS_REQUIRED_RADIANCE_BAND_NAMES_4TH) {
            sourceProduct.addBand(bandName, 30);
        }
        sensor = MphChlOp.getSensorType((Product)sourceProduct);
        Assert.assertEquals((Object)sensor, (Object)Sensor.MERIS_4TH);
        sourceProduct = new Product("test3", "test3", 1, 1);
        for (String bandName : MphChlConstants.OLCI_REQUIRED_RADIANCE_BAND_NAMES) {
            sourceProduct.addBand(bandName, 30);
        }
        sensor = MphChlOp.getSensorType((Product)sourceProduct);
        Assert.assertEquals((Object)sensor, (Object)Sensor.OLCI);
        sourceProduct = new Product("test4", "test4", 1, 1);
        for (String bandName : MphChlConstants.MERIS_REQUIRED_BRR_BAND_NAMES) {
            sourceProduct.addBand(bandName, 30);
        }
        sourceProduct.addBand("l1_flags", 20);
        sensor = MphChlOp.getSensorType((Product)sourceProduct);
        Assert.assertEquals((Object)sensor, (Object)Sensor.MERIS_3RD);
        sourceProduct = new Product("test5", "test5", 1, 1);
        for (String bandName : MphChlConstants.MERIS_REQUIRED_BRR_BAND_NAMES) {
            sourceProduct.addBand(bandName, 30);
        }
        sourceProduct.addBand("quality_flags", 11);
        sensor = MphChlOp.getSensorType((Product)sourceProduct);
        Assert.assertEquals((Object)sensor, (Object)Sensor.MERIS_4TH);
        sourceProduct = new Product("test6", "test6", 1, 1);
        for (String bandName : MphChlConstants.OLCI_REQUIRED_BRR_BAND_NAMES) {
            sourceProduct.addBand(bandName, 30);
        }
        sensor = MphChlOp.getSensorType((Product)sourceProduct);
        Assert.assertEquals((Object)sensor, (Object)Sensor.OLCI);
    }

    @Test
    public void testIsValidL1bSourceProduct() throws Exception {
        Product sourceProduct = new Product("test", "test", 1, 1);
        Assert.assertFalse((boolean)MphChlOp.isValidL1bSourceProduct((Product)sourceProduct, (Sensor)Sensor.MERIS_3RD));
        for (String bandName : MphChlConstants.MERIS_REQUIRED_RADIANCE_BAND_NAMES) {
            sourceProduct.addBand(bandName, 30);
        }
        TestCase.assertTrue((boolean)MphChlOp.isValidL1bSourceProduct((Product)sourceProduct, (Sensor)Sensor.MERIS_3RD));
        Assert.assertFalse((boolean)MphChlOp.isValidL1bSourceProduct((Product)sourceProduct, (Sensor)Sensor.OLCI));
        Assert.assertFalse((boolean)MphChlOp.isValidL1bSourceProduct((Product)sourceProduct, (Sensor)Sensor.MERIS_4TH));
        for (String bandName : MphChlConstants.MERIS_REQUIRED_RADIANCE_BAND_NAMES_4TH) {
            sourceProduct.addBand(bandName, 30);
        }
        TestCase.assertTrue((boolean)MphChlOp.isValidL1bSourceProduct((Product)sourceProduct, (Sensor)Sensor.MERIS_4TH));
        for (String bandName : MphChlConstants.OLCI_REQUIRED_RADIANCE_BAND_NAMES) {
            sourceProduct.addBand(bandName, 30);
        }
        TestCase.assertTrue((boolean)MphChlOp.isValidL1bSourceProduct((Product)sourceProduct, (Sensor)Sensor.OLCI));
    }

    @Test
    public void testIsValidBrrSourceProduct() throws Exception {
        Product sourceProduct = new Product("test", "test", 1, 1);
        Assert.assertFalse((boolean)MphChlOp.isValidBrrSourceProduct((Product)sourceProduct, (Sensor)Sensor.MERIS_3RD));
        for (String bandName : MphChlConstants.MERIS_REQUIRED_BRR_BAND_NAMES) {
            sourceProduct.addBand(bandName, 30);
        }
        TestCase.assertTrue((boolean)MphChlOp.isValidBrrSourceProduct((Product)sourceProduct, (Sensor)Sensor.MERIS_3RD));
        TestCase.assertTrue((boolean)MphChlOp.isValidBrrSourceProduct((Product)sourceProduct, (Sensor)Sensor.MERIS_4TH));
        Assert.assertFalse((boolean)MphChlOp.isValidBrrSourceProduct((Product)sourceProduct, (Sensor)Sensor.OLCI));
        for (String bandName : MphChlConstants.OLCI_REQUIRED_BRR_BAND_NAMES) {
            if (sourceProduct.containsBand(bandName)) continue;
            sourceProduct.addBand(bandName, 30);
        }
        TestCase.assertTrue((boolean)MphChlOp.isValidBrrSourceProduct((Product)sourceProduct, (Sensor)Sensor.OLCI));
    }

    @Test
    public void testGetSensorFromBrrSourceProduct() throws Exception {
        String[] sourceBands = MphChlConstants.MERIS_REQUIRED_BRR_BAND_NAMES;
        Sensor sensor = MphChlOp.getSensorFromBrrSourceProduct((String[])sourceBands);
        Assert.assertNotNull((Object)sensor);
        Assert.assertEquals((Object)Sensor.MERIS_3RD, (Object)sensor);
        sourceBands = MphChlConstants.OLCI_REQUIRED_BRR_BAND_NAMES;
        sensor = MphChlOp.getSensorFromBrrSourceProduct((String[])sourceBands);
        Assert.assertNotNull((Object)sensor);
        Assert.assertEquals((Object)Sensor.OLCI, (Object)sensor);
        sourceBands = new String[]{"bla", "blubb"};
        sensor = MphChlOp.getSensorFromBrrSourceProduct((String[])sourceBands);
        Assert.assertNull((Object)sensor);
    }
}

