/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis.productdb;

import org.esa.s3tbx.dataio.modis.productdb.ModisBandDescription;
import org.esa.s3tbx.dataio.modis.productdb.ModisProductDescription;
import org.esa.s3tbx.dataio.modis.productdb.ModisSpectralInfo;
import org.esa.s3tbx.dataio.modis.productdb.ModisTiePointDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModisProductDescriptionTest {
    private ModisProductDescription prod;

    @Before
    public void setUp() {
        this.prod = new ModisProductDescription();
    }

    @Test
    public void testDefaultConstruction() {
        Assert.assertEquals((long)0L, (long)this.prod.getBandNames().length);
        Assert.assertNull((Object)this.prod.getBandDescription("no_band"));
        Assert.assertEquals((Object)false, (Object)this.prod.mustFlipTopDown());
        Assert.assertArrayEquals(null, (Object[])this.prod.getGeolocationDatasetNames());
        Assert.assertEquals(null, (Object)this.prod.getExternalGeolocationPattern());
        Assert.assertEquals((Object)false, (Object)this.prod.hasExternalGeolocation());
        Assert.assertEquals((long)0L, (long)this.prod.getTiePointNames().length);
    }

    @Test
    public void testAddGetBand() {
        String expB_1_Name = "band_1";
        String expB_1_spectral = "true";
        String expB_1_ScaleMethod = "scale_method_1";
        String expB_1_Scale = "scale_1";
        String expB_1_Offset = "offset_1";
        String expB_1_Unit = "unit_1";
        String expB_1_BandName = "band_name_1";
        String expB_1_DescName = "desc_name_1";
        String expB_1_SpectralWL = "680.5";
        String expB_1_SpectralBW = "56.7";
        String expB_1_SpectralBI = "4";
        String expB_2_Name = "band_2";
        String expB_2_spectral = "false";
        String expB_2_ScaleMethod = "scale_method_2";
        String expB_2_Scale = "scale_2";
        String expB_2_Offset = "offset_2";
        String expB_2_Unit = "unit_2";
        String expB_2_BandName = "band_name_2";
        String expB_2_DescName = "desc_name_2";
        this.prod.addBand(expB_1_Name, expB_1_spectral, expB_1_ScaleMethod, expB_1_Scale, expB_1_Offset, expB_1_Unit, expB_1_BandName, expB_1_DescName, expB_1_SpectralWL, expB_1_SpectralBW, expB_1_SpectralBI);
        this.prod.addBand(expB_2_Name, expB_2_spectral, expB_2_ScaleMethod, expB_2_Scale, expB_2_Offset, expB_2_Unit, expB_2_BandName, expB_2_DescName);
        ModisBandDescription band = this.prod.getBandDescription(expB_1_Name);
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)expB_1_Name, (Object)band.getName());
        Assert.assertEquals((Object)expB_1_spectral, (Object)("" + band.isSpectral()));
        Assert.assertEquals((Object)expB_1_ScaleMethod, (Object)band.getScalingMethod());
        Assert.assertEquals((Object)expB_1_Scale, (Object)band.getScaleAttribName());
        Assert.assertEquals((Object)expB_1_Offset, (Object)band.getOffsetAttribName());
        Assert.assertEquals((Object)expB_1_Unit, (Object)band.getUnitAttribName());
        Assert.assertEquals((Object)expB_1_BandName, (Object)band.getBandAttribName());
        Assert.assertEquals((Object)true, (Object)band.hasSpectralInfo());
        ModisSpectralInfo spectralInfo = band.getSpecInfo();
        Assert.assertNotNull((Object)spectralInfo);
        Assert.assertEquals((Object)expB_1_SpectralWL, (Object)("" + spectralInfo.getSpectralWavelength()));
        Assert.assertEquals((Object)expB_1_SpectralBW, (Object)("" + spectralInfo.getSpectralBandwidth()));
        Assert.assertEquals((Object)expB_1_SpectralBI, (Object)("" + spectralInfo.getSpectralBandIndex()));
        band = this.prod.getBandDescription(expB_2_Name);
        Assert.assertNotNull((Object)band);
        Assert.assertEquals((Object)expB_2_Name, (Object)band.getName());
        Assert.assertEquals((Object)expB_2_spectral, (Object)("" + band.isSpectral()));
        Assert.assertEquals((Object)expB_2_ScaleMethod, (Object)band.getScalingMethod());
        Assert.assertEquals((Object)expB_2_Scale, (Object)band.getScaleAttribName());
        Assert.assertEquals((Object)expB_2_Offset, (Object)band.getOffsetAttribName());
        Assert.assertEquals((Object)expB_2_Unit, (Object)band.getUnitAttribName());
        Assert.assertEquals((Object)expB_2_BandName, (Object)band.getBandAttribName());
        String[] bandNames = this.prod.getBandNames();
        Assert.assertNotNull((Object)bandNames);
        Assert.assertEquals((long)2L, (long)bandNames.length);
        Assert.assertEquals((Object)expB_1_Name, (Object)bandNames[0]);
        Assert.assertEquals((Object)expB_2_Name, (Object)bandNames[1]);
        Assert.assertNull((Object)this.prod.getBandDescription("no_band"));
        Assert.assertNull((Object)this.prod.getBandDescription("nonsense"));
    }

    @Test
    public void testGeolocationAccess() {
        Assert.assertNull((Object)this.prod.getGeolocationDatasetNames());
        String expLat = "latitude";
        String expLon = "longitude";
        this.prod.setGeolocationDatasetNames(expLat, expLon);
        String[] geoLoc = this.prod.getGeolocationDatasetNames();
        Assert.assertNotNull((Object)geoLoc);
        Assert.assertEquals((long)2L, (long)geoLoc.length);
        Assert.assertEquals((Object)expLat, (Object)geoLoc[0]);
        Assert.assertEquals((Object)expLon, (Object)geoLoc[1]);
    }

    @Test
    public void testTiePointAccess() {
        Assert.assertEquals((long)0L, (long)this.prod.getTiePointNames().length);
        String[] tp = new String[]{"tie_point_1", "tie_point_2", "tie_point_3"};
        String[] sc = new String[]{"scale_1", "scale_2", "scale_3"};
        String[] of = new String[]{"off_1", "off_2", "off_3"};
        String[] un = new String[]{"unit_1", "unit_2", "unit_3"};
        for (int n = 0; n < 3; ++n) {
            this.prod.addTiePointGrid(new ModisTiePointDescription(tp[n], sc[n], of[n], un[n]));
        }
        String[] tpNames = this.prod.getTiePointNames();
        Assert.assertNotNull((Object)tpNames);
        Assert.assertEquals((long)3L, (long)tpNames.length);
        for (int n = 0; n < 3; ++n) {
            Assert.assertEquals((Object)tp[n], (Object)tpNames[n]);
        }
        for (int n = 0; n < 3; ++n) {
            ModisTiePointDescription desc = this.prod.getTiePointDescription(tpNames[n]);
            Assert.assertNotNull((Object)desc);
            Assert.assertEquals((Object)tp[n], (Object)desc.getName());
            Assert.assertEquals((Object)sc[n], (Object)desc.getScaleAttribName());
            Assert.assertEquals((Object)of[n], (Object)desc.getOffsetAttribName());
            Assert.assertEquals((Object)un[n], (Object)desc.getUnitAttribName());
        }
    }

    @Test
    public void testFlipAccessors() {
        Assert.assertEquals((Object)false, (Object)this.prod.mustFlipTopDown());
        this.prod.setTopDownFlip(true);
        Assert.assertEquals((Object)true, (Object)this.prod.mustFlipTopDown());
        this.prod.setTopDownFlip(false);
        Assert.assertEquals((Object)false, (Object)this.prod.mustFlipTopDown());
    }

    @Test
    public void testGeocodingAccessors() {
        String[] latlon = this.prod.getGeolocationDatasetNames();
        Assert.assertNull((Object)latlon);
        Assert.assertEquals((Object)false, (Object)this.prod.hasExternalGeolocation());
        Assert.assertNull((Object)this.prod.getExternalGeolocationPattern());
        String expLat = "latitude";
        String expLon = "lomgitude";
        this.prod.setGeolocationDatasetNames(expLat, expLon);
        Assert.assertEquals((Object)false, (Object)this.prod.hasExternalGeolocation());
        latlon = this.prod.getGeolocationDatasetNames();
        Assert.assertNotNull((Object)latlon);
        Assert.assertEquals((long)2L, (long)latlon.length);
        Assert.assertEquals((Object)expLat, (Object)latlon[0]);
        Assert.assertEquals((Object)expLon, (Object)latlon[1]);
        String expExter = "external";
        this.prod.setExternalGeolocationPattern(expExter);
        Assert.assertEquals((Object)true, (Object)this.prod.hasExternalGeolocation());
        Assert.assertEquals((Object)expExter, (Object)this.prod.getExternalGeolocationPattern());
        this.prod.setExternalGeolocationPattern(null);
        Assert.assertEquals((Object)false, (Object)this.prod.hasExternalGeolocation());
        Assert.assertEquals(null, (Object)this.prod.getExternalGeolocationPattern());
    }
}

