/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.esa.s3tbx.dataio.modis.ModisUtils;
import org.junit.Assert;
import org.junit.Test;

public class ModisUtilsTest_CreateDateFromString {
    @Test
    public void testOk_MoreThanMillisecondsSnipped() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2004-07-10";
        String time = "21:55:11.123456";
        Date testDate = ModisUtils.createDateFromStrings((String)"2004-07-10", (String)"21:55:11.123456");
        Assert.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        Assert.assertEquals((long)2004L, (long)cal.get(1));
        Assert.assertEquals((long)6L, (long)cal.get(2));
        Assert.assertEquals((long)10L, (long)cal.get(5));
        Assert.assertEquals((long)21L, (long)cal.get(11));
        Assert.assertEquals((long)55L, (long)cal.get(12));
        Assert.assertEquals((long)11L, (long)cal.get(13));
        Assert.assertEquals((long)123L, (long)cal.get(14));
    }

    @Test
    public void testOk_exact() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2005-08-22";
        String time = "12:22:09.887";
        Date testDate = ModisUtils.createDateFromStrings((String)"2005-08-22", (String)"12:22:09.887");
        Assert.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        Assert.assertEquals((long)2005L, (long)cal.get(1));
        Assert.assertEquals((long)7L, (long)cal.get(2));
        Assert.assertEquals((long)22L, (long)cal.get(5));
        Assert.assertEquals((long)12L, (long)cal.get(11));
        Assert.assertEquals((long)22L, (long)cal.get(12));
        Assert.assertEquals((long)9L, (long)cal.get(13));
        Assert.assertEquals((long)887L, (long)cal.get(14));
    }

    @Test
    public void testOk_WithoutMilliseconds() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2007-03-25";
        String time = "15:16:17";
        Date testDate = ModisUtils.createDateFromStrings((String)"2007-03-25", (String)"15:16:17");
        Assert.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        Assert.assertEquals((long)2007L, (long)cal.get(1));
        Assert.assertEquals((long)2L, (long)cal.get(2));
        Assert.assertEquals((long)25L, (long)cal.get(5));
        Assert.assertEquals((long)15L, (long)cal.get(11));
        Assert.assertEquals((long)16L, (long)cal.get(12));
        Assert.assertEquals((long)17L, (long)cal.get(13));
        Assert.assertEquals((long)0L, (long)cal.get(14));
    }

    @Test
    public void testOk_WithMillisecondsFragment() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2001-09-13";
        String time = "07:08:09.4";
        Date testDate = ModisUtils.createDateFromStrings((String)"2001-09-13", (String)"07:08:09.4");
        Assert.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        Assert.assertEquals((long)2001L, (long)cal.get(1));
        Assert.assertEquals((long)8L, (long)cal.get(2));
        Assert.assertEquals((long)13L, (long)cal.get(5));
        Assert.assertEquals((long)7L, (long)cal.get(11));
        Assert.assertEquals((long)8L, (long)cal.get(12));
        Assert.assertEquals((long)9L, (long)cal.get(13));
        Assert.assertEquals((long)400L, (long)cal.get(14));
    }

    @Test
    public void testOk_WithoutSeconds() throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        String date = "2008-04-21";
        String time = "17:18";
        Date testDate = ModisUtils.createDateFromStrings((String)"2008-04-21", (String)"17:18");
        Assert.assertNotNull((Object)testDate);
        cal.setTime(testDate);
        Assert.assertEquals((long)2008L, (long)cal.get(1));
        Assert.assertEquals((long)3L, (long)cal.get(2));
        Assert.assertEquals((long)21L, (long)cal.get(5));
        Assert.assertEquals((long)17L, (long)cal.get(11));
        Assert.assertEquals((long)18L, (long)cal.get(12));
        Assert.assertEquals((long)0L, (long)cal.get(13));
        Assert.assertEquals((long)0L, (long)cal.get(14));
    }
}

