/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import org.esa.s3tbx.dataio.modis.IncrementOffset;
import org.esa.s3tbx.dataio.modis.ModisUtils;
import org.esa.snap.core.util.math.Range;
import org.junit.Assert;
import org.junit.Test;

public class ModisUtilsTest {
    private static final String TestCoreString = "GROUP                  = INVENTORYMETADATA\n  GROUPTYPE            = MASTERGROUP\n\n  GROUP                  = ECSDATAGRANULE\n\n    OBJECT                 = LOCALGRANULEID\n      NUM_VAL              = 1\n      VALUE                = \"MYD021KM.A2005297.2205.005.2005299100720.hdf\"\n    END_OBJECT             = LOCALGRANULEID\n\n    OBJECT                 = PRODUCTIONDATETIME\n      NUM_VAL              = 1\n      VALUE                = \"2005-10-26T10:07:21.000Z\"\n    END_OBJECT             = PRODUCTIONDATETIME\n\n    OBJECT                 = DAYNIGHTFLAG\n      NUM_VAL              = 1\n      VALUE                = \"Night\"\n    END_OBJECT             = DAYNIGHTFLAG\nEND_GROUP              = ADDITIONALATTRIBUTES\nGROUP                  = ORBITCALCULATEDSPATIALDOMAIN\n   OBJECT                 = ORBITNUMBER\n       CLASS                = \"1\"\n       NUM_VAL              = 1\n       VALUE                = 18490\n   END_OBJECT           = ORBITNUMBER\nEND_GROUP              = ORBITCALCULATEDSPATIALDOMAIN\n\nEND_GROUP              = INVENTORYMETADATA\n\nEND";

    @Test
    public void testExtractValueForKey() {
        Assert.assertEquals((Object)"Night", (Object)ModisUtils.extractValueForKey((String)TestCoreString, (String)"DAYNIGHTFLAG"));
        Assert.assertEquals((Object)"2005-10-26T10:07:21.000Z", (Object)ModisUtils.extractValueForKey((String)TestCoreString, (String)"PRODUCTIONDATETIME"));
        Assert.assertNull((Object)ModisUtils.extractValueForKey((String)TestCoreString, (String)"huppepup"));
    }

    @Test
    public void testExtractIntegerValueFromObject() {
        Assert.assertEquals((Object)"18490", (Object)ModisUtils.extractValueForKey((String)TestCoreString, (String)"ORBITNUMBER"));
    }

    @Test
    public void testExtractValueForKeyHandlesStupidInput() {
        try {
            ModisUtils.extractValueForKey(null, (String)"DAYNIGHTFLAG");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ModisUtils.extractValueForKey((String)TestCoreString, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetIncrementOffset() {
        String test1 = "3,8";
        String test2 = "3,8,13,...";
        IncrementOffset incrementOffset = ModisUtils.getIncrementOffset((String)"3,8");
        Assert.assertNotNull((Object)incrementOffset);
        Assert.assertEquals((long)2L, (long)incrementOffset.offset);
        Assert.assertEquals((long)5L, (long)incrementOffset.increment);
        incrementOffset = ModisUtils.getIncrementOffset((String)"3,8,13,...");
        Assert.assertNotNull((Object)incrementOffset);
        Assert.assertEquals((long)2L, (long)incrementOffset.offset);
        Assert.assertEquals((long)5L, (long)incrementOffset.increment);
    }

    @Test
    public void testGetRangeFromString() {
        String test_1 = "0, 32767";
        String test_2 = "6,2";
        Range result = ModisUtils.getRangeFromString((String)"0, 32767");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)((int)result.getMin()));
        Assert.assertEquals((long)32767L, (long)((int)result.getMax()));
        result = ModisUtils.getRangeFromString((String)"6,2");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)((int)result.getMin()));
        Assert.assertEquals((long)6L, (long)((int)result.getMax()));
    }

    @Test
    public void testExtractBandName() {
        Assert.assertEquals((Object)"band_name", (Object)ModisUtils.extractBandName((String)"band_name"));
        Assert.assertEquals((Object)"EV_250_Aggr500_RefSB", (Object)ModisUtils.extractBandName((String)"MODIS_SWATH_Type_L1B/Data Fields/EV_250_Aggr500_RefSB"));
        Assert.assertEquals((Object)"EV_500_RefSB_Uncert_Indexes", (Object)ModisUtils.extractBandName((String)"MODIS_SWATH_Type_L1B/Data Fields/EV_500_RefSB_Uncert_Indexes"));
    }

    @Test
    public void testDecodeBandName() {
        Assert.assertEquals((Object)".bla", (Object)ModisUtils.decodeBandName((String)"schnipp,schnupp,bla,blubb", (int)2));
        Assert.assertEquals((Object)".schnipp", (Object)ModisUtils.decodeBandName((String)"schnipp,schnupp,bla,blubb", (int)0));
    }
}

