/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.esa.s3tbx.dataio.modis.ModisProductReader;
import org.esa.s3tbx.dataio.modis.ModisProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModisProductReaderPluginTest {
    private ModisProductReaderPlugIn plugIn;
    private File testFile;

    @Test
    public void testInputTypes() {
        Class[] inputTypes = this.plugIn.getInputTypes();
        Assert.assertNotNull((Object)inputTypes);
        Assert.assertEquals((long)2L, (long)inputTypes.length);
        Assert.assertEquals(String.class, (Object)inputTypes[0]);
        Assert.assertEquals(File.class, (Object)inputTypes[1]);
    }

    @Test
    public void testCreateReaderInstance() {
        ProductReader readerInstance = this.plugIn.createReaderInstance();
        Assert.assertNotNull((Object)readerInstance);
        Assert.assertTrue((boolean)(readerInstance instanceof ModisProductReader));
    }

    @Test
    public void testGetDefaultFileExtension() {
        String[] defaultFileExtensions = this.plugIn.getDefaultFileExtensions();
        Assert.assertNotNull((Object)defaultFileExtensions);
        Assert.assertEquals((long)1L, (long)defaultFileExtensions.length);
        Assert.assertEquals((Object)".hdf", (Object)defaultFileExtensions[0]);
    }

    @Test
    public void testGetDescription() {
        String description = this.plugIn.getDescription(Locale.getDefault());
        Assert.assertNotNull((Object)description);
        Assert.assertEquals((Object)"MODIS HDF4 Data Products", (Object)description);
        description = this.plugIn.getDescription(null);
        Assert.assertNotNull((Object)description);
        Assert.assertEquals((Object)"MODIS HDF4 Data Products", (Object)description);
    }

    @Test
    public void testGetFormatNames() {
        String[] formatNames = this.plugIn.getFormatNames();
        Assert.assertNotNull((Object)formatNames);
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"MODIS", (Object)formatNames[0]);
    }

    @Test
    public void testGetInputFile_nullInput() {
        Assert.assertNull((Object)ModisProductReaderPlugIn.getInputFile(null));
    }

    @Test
    public void testGetInputFile_stringInput() {
        String testFileName = "test.file";
        File file = ModisProductReaderPlugIn.getInputFile((Object)testFileName);
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)testFileName, (Object)file.getName());
    }

    @Test
    public void testGetInputFile_fileInput() {
        File inputFile = new File("I_am_a.file");
        File file = ModisProductReaderPlugIn.getInputFile((Object)inputFile);
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)inputFile.getName(), (Object)file.getName());
    }

    @Test
    public void testHasHdfFileExtension() {
        Assert.assertFalse((boolean)ModisProductReaderPlugIn.hasHdfFileExtension(null));
        Assert.assertFalse((boolean)ModisProductReaderPlugIn.hasHdfFileExtension((File)new File("tonio_und.tom")));
        Assert.assertTrue((boolean)ModisProductReaderPlugIn.hasHdfFileExtension((File)new File("I_am_but.hdf")));
    }

    @Test
    public void testGetProductFileFilter() {
        SnapFileFilter productFileFilter = this.plugIn.getProductFileFilter();
        Assert.assertNotNull((Object)productFileFilter);
        Assert.assertEquals((Object)"MODIS", (Object)productFileFilter.getFormatName());
        Assert.assertEquals((Object)".hdf", (Object)productFileFilter.getDefaultExtension());
        Assert.assertEquals((Object)"MODIS HDF4 Data Products (*.hdf)", (Object)productFileFilter.getDescription());
    }

    @Test
    public void testIsValidInputFile_nullFile() {
        Assert.assertFalse((boolean)ModisProductReaderPlugIn.isValidInputFile(null));
    }

    @Test
    public void testIsValidInputFile_notExistingFile() {
        Assert.assertFalse((boolean)ModisProductReaderPlugIn.isValidInputFile((File)new File("I/don/not/exist.hdf")));
    }

    @Test
    public void testIsValidInputFile_nonHdfFile() throws IOException {
        this.testFile = new File("I_do_exist.txt");
        if (!this.testFile.createNewFile()) {
            Assert.fail((String)"unable to create TestFile");
        }
        Assert.assertFalse((boolean)ModisProductReaderPlugIn.isValidInputFile((File)this.testFile));
    }

    @Test
    public void testIsValidInputFile_hdfFile() throws IOException {
        this.testFile = new File("I_do_exist.hdf");
        if (!this.testFile.createNewFile()) {
            Assert.fail((String)"unable to create TestFile");
        }
        Assert.assertTrue((boolean)ModisProductReaderPlugIn.isValidInputFile((File)this.testFile));
    }

    @Before
    public void setUp() {
        this.plugIn = new ModisProductReaderPlugIn();
    }

    @After
    public void tearDown() throws Exception {
        if (this.testFile != null && !this.testFile.delete()) {
            Assert.fail((String)"unable to delete test file");
        }
    }
}

