/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import java.awt.Dimension;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.esa.s3tbx.dataio.modis.ModisFileReader;
import org.esa.s3tbx.dataio.modis.ModisGlobalAttributes;
import org.esa.s3tbx.dataio.modis.hdf.HdfDataField;
import org.esa.s3tbx.dataio.modis.productdb.ModisBandDescription;
import org.esa.s3tbx.dataio.modis.productdb.ModisSpectralInfo;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.math.Range;
import org.junit.Assert;
import org.junit.Test;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ModisFileReaderTest {
    @Test
    public void testGetTypeString_typeNull() {
        Product product = new Product("Name", "PROD_TYPE", 5, 5);
        Assert.assertEquals((Object)"PROD_TYPE", (Object)ModisFileReader.getTypeString(null, (Product)product));
    }

    @Test
    public void testGetTypeString_typeSupplied() {
        Product product = new Product("Name", "PROD_TYPE", 5, 5);
        Assert.assertEquals((Object)"TYPE_STRING", (Object)ModisFileReader.getTypeString((String)"TYPE_STRING", (Product)product));
    }

    @Test
    public void testCreateRangeFromArray_nullArray() {
        Assert.assertNull((Object)ModisFileReader.createRangeFromArray(null));
    }

    @Test
    public void testCreateRangeFromArray_tooShortArray() {
        Assert.assertNull((Object)ModisFileReader.createRangeFromArray((int[])new int[]{34}));
    }

    @Test
    public void testCreateRangeFromArray_orderedInts() {
        Range range = ModisFileReader.createRangeFromArray((int[])new int[]{34, 3809});
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((double)34.0, (double)range.getMin(), (double)1.0E-8);
        Assert.assertEquals((double)3809.0, (double)range.getMax(), (double)1.0E-8);
    }

    @Test
    public void testCreateRangeFromArray_inverseOrderedInts() {
        Range range = ModisFileReader.createRangeFromArray((int[])new int[]{9886, 14});
        Assert.assertNotNull((Object)range);
        Assert.assertEquals((double)14.0, (double)range.getMin(), (double)1.0E-8);
        Assert.assertEquals((double)9886.0, (double)range.getMax(), (double)1.0E-8);
    }

    @Test
    public void testHasInvalidScaleAndOffset_invalidScale() {
        Assert.assertTrue((boolean)ModisFileReader.hasInvalidScaleAndOffset((float[])new float[2], (float[])new float[4], (int)3));
    }

    @Test
    public void testHasInvalidScaleAndOffset_invalidOffset() {
        Assert.assertTrue((boolean)ModisFileReader.hasInvalidScaleAndOffset((float[])new float[4], (float[])new float[2], (int)3));
    }

    @Test
    public void testHasInvalidScaleAndOffset() {
        Assert.assertFalse((boolean)ModisFileReader.hasInvalidScaleAndOffset((float[])new float[4], (float[])new float[4], (int)3));
    }

    @Test
    public void testSetSpectralBandInfo_notSpectral() {
        Band band = new Band("bla", 30, 3, 3);
        ModisBandDescription description = new ModisBandDescription("", "false", "", "", "", "", "", "");
        ModisFileReader.setBandSpectralInformation((ModisBandDescription)description, (String)"", (Band)band);
        Assert.assertEquals((long)-1L, (long)band.getSpectralBandIndex());
        Assert.assertEquals((double)0.0, (double)band.getSpectralWavelength(), (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)band.getSpectralBandwidth(), (double)1.0E-8);
    }

    @Test
    public void testSetSpectralBandInfo_fromBandIndex() {
        Band band = new Band("bla", 30, 3, 3);
        ModisBandDescription description = new ModisBandDescription("", "true", "", "", "", "", "", "");
        ModisFileReader.setBandSpectralInformation((ModisBandDescription)description, (String)"4", (Band)band);
        Assert.assertEquals((long)6L, (long)band.getSpectralBandIndex());
        Assert.assertEquals((double)555.0, (double)band.getSpectralWavelength(), (double)1.0E-8);
        Assert.assertEquals((double)20.0, (double)band.getSpectralBandwidth(), (double)1.0E-8);
    }

    @Test
    public void testSetSpectralBandInfo_fromSpecInfo() {
        Band band = new Band("bla", 30, 3, 3);
        ModisBandDescription description = new ModisBandDescription("", "true", "", "", "", "", "", "");
        ModisSpectralInfo spectralInfo = new ModisSpectralInfo("2", "3", "4");
        description.setSpecInfo(spectralInfo);
        ModisFileReader.setBandSpectralInformation((ModisBandDescription)description, (String)"", (Band)band);
        Assert.assertEquals((long)4L, (long)band.getSpectralBandIndex());
        Assert.assertEquals((double)2.0, (double)band.getSpectralWavelength(), (double)1.0E-8);
        Assert.assertEquals((double)3.0, (double)band.getSpectralBandwidth(), (double)1.0E-8);
    }

    @Test
    public void testIsEosGridType() throws IOException {
        TestGlobalAttributes globalAttributes = new TestGlobalAttributes();
        globalAttributes.setEosType("EOS_TYPE_GRID");
        Assert.assertTrue((boolean)ModisFileReader.isEosGridType((ModisGlobalAttributes)globalAttributes));
        globalAttributes.setEosType("EOS_invalid_and_ausgedacht");
        Assert.assertFalse((boolean)ModisFileReader.isEosGridType((ModisGlobalAttributes)globalAttributes));
    }

    @Test
    public void testInvert() {
        float[] scales = new float[]{24.7f, 0.0f, -100.0f};
        ModisFileReader.invert((float[])scales);
        Assert.assertEquals((double)0.04048582911491394, (double)scales[0], (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)scales[1], (double)1.0E-8);
        Assert.assertEquals((double)-0.01f, (double)scales[2], (double)1.0E-8);
    }

    private class TestGlobalAttributes
    implements ModisGlobalAttributes {
        private String eosType;

        private TestGlobalAttributes() {
        }

        public String getProductName() throws IOException {
            throw new NotImplementedException();
        }

        public String getProductType() throws IOException {
            throw new NotImplementedException();
        }

        public Dimension getProductDimensions(List<ucar.nc2.Dimension> netcdfFileDimensions) {
            throw new NotImplementedException();
        }

        public HdfDataField getDatafield(String name) throws ProductIOException {
            throw new NotImplementedException();
        }

        public Date getSensingStart() {
            throw new NotImplementedException();
        }

        public Date getSensingStop() {
            throw new NotImplementedException();
        }

        public int[] getSubsamplingAndOffset(String dimensionName) {
            throw new NotImplementedException();
        }

        public boolean isImappFormat() {
            throw new NotImplementedException();
        }

        public String getEosType() {
            return this.eosType;
        }

        void setEosType(String eosType) {
            this.eosType = eosType;
        }

        public GeoCoding createGeocoding() {
            throw new NotImplementedException();
        }
    }
}

