/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.modis;

import org.esa.s3tbx.dataio.modis.ModisDaacUtils;
import org.esa.s3tbx.dataio.modis.productdb.ModisProductDb;
import org.esa.snap.core.dataio.ProductIOException;
import org.junit.Assert;
import org.junit.Test;

public class ModisDaacUtilsTest_extractProductType {
    @Test
    public void testOk_MOD13A2_InTheMiddle() throws ProductIOException {
        String typeString = ModisDaacUtils.extractProductType((String)"MOD_SS.MOD13A2.somthing other");
        Assert.assertEquals((Object)"MOD13A2", (Object)typeString);
    }

    @Test
    public void testOk_MYD13A2_AtStart() throws ProductIOException {
        String typeString = ModisDaacUtils.extractProductType((String)"MYD13A2.somthing other");
        Assert.assertEquals((Object)"MYD13A2", (Object)typeString);
    }

    @Test
    public void testAllProductTypes_InTheMiddle() throws ProductIOException {
        String[] supportetProductTypes = ModisProductDb.getInstance().getSupportetProductTypes();
        for (int i = 0; i < supportetProductTypes.length; ++i) {
            String type = supportetProductTypes[i];
            String toTest = "anyPrefix." + type + ".anySuffix";
            Assert.assertEquals((String)("Index = " + i), (Object)ModisDaacUtils.extractProductType((String)toTest), (Object)type);
        }
    }

    @Test
    public void testAllProductTypes_AtStart() throws ProductIOException {
        String[] supportetProductTypes = ModisProductDb.getInstance().getSupportetProductTypes();
        for (int i = 0; i < supportetProductTypes.length; ++i) {
            String type = supportetProductTypes[i];
            String toTest = type + ".anySuffix";
            Assert.assertEquals((String)("Index = " + i), (Object)ModisDaacUtils.extractProductType((String)toTest), (Object)type);
        }
    }

    @Test
    public void testShittyEsaNotFollowingTheConventionsNameHandling() throws ProductIOException {
        String[] supportetProductTypes = ModisProductDb.getInstance().getSupportetProductTypes();
        for (int i = 0; i < supportetProductTypes.length; ++i) {
            String type = supportetProductTypes[i];
            String toTest = type + "_anySuffix";
            if (this.isImapp(toTest)) continue;
            Assert.assertEquals((String)("Index = " + i), (Object)ModisDaacUtils.extractProductType((String)toTest), (Object)type);
        }
    }

    @Test
    public void testExtractProdcutTypeReturnsEmptyStringOnUnknown() throws ProductIOException {
        Assert.assertEquals((Object)"", (Object)ModisDaacUtils.extractProductType((String)"This.is.an.invalid.type"));
        Assert.assertEquals((Object)"", (Object)ModisDaacUtils.extractProductType((String)"This_is_an_invalid_type"));
    }

    private boolean isImapp(String toTest) {
        return toTest.contains("IMAPP");
    }
}

