/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.merisl3;

import java.awt.Point;
import org.esa.s3tbx.dataio.merisl3.ISINGrid;
import org.junit.Assert;
import org.junit.Test;

public class ISINGridTest {
    private ISINGrid grid = new ISINGrid(2160);

    @Test
    public void testDefaults() {
        Assert.assertEquals((long)2160L, (long)2160L);
        Assert.assertEquals((long)2160L, (long)this.grid.getRowCount());
        Assert.assertEquals((long)5940422L, (long)this.grid.getTotalBinCount());
        Assert.assertEquals((double)(180.0 / (double)this.grid.getRowCount()), (double)this.grid.getDeltaLat(), (double)1.0E-10);
        Assert.assertEquals((double)(20037.508342789242 / (double)this.grid.getRowCount()), (double)this.grid.getBinSize(), (double)1.0E-10);
    }

    @Test
    public void test_getRowLength() {
        Assert.assertEquals((long)3L, (long)this.grid.getRowLength(0));
        Assert.assertEquals((long)9L, (long)this.grid.getRowLength(1));
        Assert.assertEquals((long)16L, (long)this.grid.getRowLength(2));
        Assert.assertEquals((long)22L, (long)this.grid.getRowLength(3));
        Assert.assertEquals((long)4320L, (long)this.grid.getRowLength(1079));
        Assert.assertEquals((long)4320L, (long)this.grid.getRowLength(1080));
        Assert.assertEquals((long)3L, (long)this.grid.getRowLength(2159));
        Assert.assertEquals((long)9L, (long)this.grid.getRowLength(2158));
        Assert.assertEquals((long)16L, (long)this.grid.getRowLength(2157));
        Assert.assertEquals((long)22L, (long)this.grid.getRowLength(2156));
    }

    @Test
    public void test_getRowOffset() {
        Assert.assertEquals((long)0L, (long)this.grid.getBinOffset(0));
        Assert.assertEquals((long)3L, (long)this.grid.getBinOffset(1));
        Assert.assertEquals((long)12L, (long)this.grid.getBinOffset(2));
        Assert.assertEquals((long)28L, (long)this.grid.getBinOffset(3));
        Assert.assertEquals((long)50L, (long)this.grid.getBinOffset(4));
        Assert.assertEquals((long)2965891L, (long)this.grid.getBinOffset(1079));
        Assert.assertEquals((long)2970211L, (long)this.grid.getBinOffset(1080));
        Assert.assertEquals((long)5940419L, (long)this.grid.getBinOffset(2159));
        Assert.assertEquals((long)5940410L, (long)this.grid.getBinOffset(2158));
        Assert.assertEquals((long)0x5AA4AAL, (long)this.grid.getBinOffset(2157));
        Assert.assertEquals((long)5940372L, (long)this.grid.getBinOffset(2156));
    }

    @Test
    public void test_getRowIndex() {
        Assert.assertEquals((long)0L, (long)this.grid.getRowIndex(0));
        Assert.assertEquals((long)1L, (long)this.grid.getRowIndex(3));
        Assert.assertEquals((long)2L, (long)this.grid.getRowIndex(12));
        Assert.assertEquals((long)3L, (long)this.grid.getRowIndex(28));
        Assert.assertEquals((long)4L, (long)this.grid.getRowIndex(50));
        Assert.assertEquals((long)1079L, (long)this.grid.getRowIndex(2965891));
        Assert.assertEquals((long)1080L, (long)this.grid.getRowIndex(2970211));
        Assert.assertEquals((long)2158L, (long)this.grid.getRowIndex(5940418));
        Assert.assertEquals((long)2159L, (long)this.grid.getRowIndex(5940419));
        Assert.assertEquals((long)2159L, (long)this.grid.getRowIndex(5940420));
        Assert.assertEquals((long)2159L, (long)this.grid.getRowIndex(5940421));
        Assert.assertEquals((long)2158L, (long)this.grid.getRowIndex(5940410));
        Assert.assertEquals((long)2158L, (long)this.grid.getRowIndex(5940411));
        Assert.assertEquals((long)2157L, (long)this.grid.getRowIndex(0x5AA4AA));
        Assert.assertEquals((long)2156L, (long)this.grid.getRowIndex(5940372));
        Assert.assertEquals((long)-1L, (long)this.grid.getRowIndex(-1000));
        Assert.assertEquals((long)-1L, (long)this.grid.getRowIndex(-1));
        Assert.assertEquals((long)-1L, (long)this.grid.getRowIndex(5940422));
        Assert.assertEquals((long)-1L, (long)this.grid.getRowIndex(5941422));
    }

    @Test
    public void test_getGridPoint() {
        Point point = new Point();
        Assert.assertEquals((Object)new Point(2, 0), (Object)this.grid.getGridPoint(2, point));
        Assert.assertEquals((Object)new Point(7, 1), (Object)this.grid.getGridPoint(10, point));
        Assert.assertEquals((Object)new Point(11, 2), (Object)this.grid.getGridPoint(23, point));
        Assert.assertEquals((Object)new Point(19, 3), (Object)this.grid.getGridPoint(47, point));
        Assert.assertEquals((Object)new Point(25, 4), (Object)this.grid.getGridPoint(75, point));
        Assert.assertEquals((Object)new Point(632, 1079), (Object)this.grid.getGridPoint(2966523, point));
        Assert.assertEquals((Object)new Point(1743, 1080), (Object)this.grid.getGridPoint(2971954, point));
        Assert.assertEquals((Object)new Point(1, 2159), (Object)this.grid.getGridPoint(5940420, point));
        Assert.assertEquals((Object)new Point(6, 2158), (Object)this.grid.getGridPoint(5940416, point));
        Assert.assertEquals((Object)new Point(15, 2157), (Object)this.grid.getGridPoint(5940409, point));
        Assert.assertEquals((Object)new Point(20, 2156), (Object)this.grid.getGridPoint(5940392, point));
        Assert.assertEquals((Object)new Point(-1, -1), (Object)this.grid.getGridPoint(-1000, point));
        Assert.assertEquals((Object)new Point(-1, -1), (Object)this.grid.getGridPoint(-1, point));
        Assert.assertEquals((Object)new Point(-1, -1), (Object)this.grid.getGridPoint(5940422, point));
        Assert.assertEquals((Object)new Point(-1, -1), (Object)this.grid.getGridPoint(5941422, point));
    }

    @Test
    public void test_getBinIndex() {
        Assert.assertEquals((long)2L, (long)this.grid.getBinIndex(new Point(2, 0)));
        Assert.assertEquals((long)10L, (long)this.grid.getBinIndex(new Point(7, 1)));
        Assert.assertEquals((long)23L, (long)this.grid.getBinIndex(new Point(11, 2)));
        Assert.assertEquals((long)47L, (long)this.grid.getBinIndex(new Point(19, 3)));
        Assert.assertEquals((long)75L, (long)this.grid.getBinIndex(new Point(25, 4)));
        Assert.assertEquals((long)2966523L, (long)this.grid.getBinIndex(new Point(632, 1079)));
        Assert.assertEquals((long)2971954L, (long)this.grid.getBinIndex(new Point(1743, 1080)));
        Assert.assertEquals((long)5940420L, (long)this.grid.getBinIndex(new Point(1, 2159)));
        Assert.assertEquals((long)5940416L, (long)this.grid.getBinIndex(new Point(6, 2158)));
        Assert.assertEquals((long)5940409L, (long)this.grid.getBinIndex(new Point(15, 2157)));
        Assert.assertEquals((long)5940392L, (long)this.grid.getBinIndex(new Point(20, 2156)));
        Assert.assertEquals((long)-1L, (long)this.grid.getBinIndex(new Point(-1, -1)));
        Assert.assertEquals((long)-1L, (long)this.grid.getBinIndex(new Point(-1, 23)));
        Assert.assertEquals((long)-1L, (long)this.grid.getBinIndex(new Point(546, -1)));
        Assert.assertEquals((long)-1L, (long)this.grid.getBinIndex(new Point(4321, 46)));
        Assert.assertEquals((long)-1L, (long)this.grid.getBinIndex(new Point(343, 5940423)));
    }

    @Test
    public void test_getColIndex() {
        Assert.assertEquals((long)0L, (long)this.grid.getColIndex(0, 0.0));
        Assert.assertEquals((long)0L, (long)this.grid.getColIndex(0, 45.0));
        Assert.assertEquals((long)1L, (long)this.grid.getColIndex(0, 120.0));
        Assert.assertEquals((long)1L, (long)this.grid.getColIndex(0, 165.0));
        Assert.assertEquals((long)2L, (long)this.grid.getColIndex(0, 240.0));
        Assert.assertEquals((long)2L, (long)this.grid.getColIndex(0, 285.0));
        Assert.assertEquals((long)3L, (long)this.grid.getColIndex(0, 360.0));
        Assert.assertEquals((long)3L, (long)this.grid.getColIndex(0, 405.0));
        try {
            this.grid.getColIndex(0, -285.0);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.grid.getColIndex(0, -165.0);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.grid.getColIndex(0, -45.0);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.grid.getColIndex(0, 360.0);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.grid.getColIndex(0, 405.0);
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.grid.getColIndex(-1, 45.3);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.grid.getColIndex(this.grid.getRowCount(), 45.3);
            Assert.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void test_getBinIndexWithLon() {
    }

    @Test
    public void testDetectRowCount() throws Exception {
        String name9277 = "L3_ENV_MER_A443_m__20030301_GLOB_SI_ACR_9277x9277_-90+90+-180+180_0000.nc";
        Assert.assertEquals((long)2160L, (long)ISINGrid.detectRowCount((String)"L3_ENV_MER_A443_m__20030301_GLOB_SI_ACR_9277x9277_-90+90+-180+180_0000.nc"));
        String name4320 = "L3_ENV_MER_CHL1_d__20070101_GLOB_SI_ESA_4638x4638_-90+90+-180+180_0000.nc";
        Assert.assertEquals((long)4320L, (long)ISINGrid.detectRowCount((String)"L3_ENV_MER_CHL1_d__20070101_GLOB_SI_ESA_4638x4638_-90+90+-180+180_0000.nc"));
        String nameFoo = "foo";
        Assert.assertEquals((long)2160L, (long)ISINGrid.detectRowCount((String)"foo"));
    }
}

