/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.merisl3;

import java.awt.Point;
import junit.framework.TestCase;
import org.esa.s3tbx.dataio.merisl3.ISINGrid;

public class ISINGridTest
extends TestCase {
    private ISINGrid grid = new ISINGrid(2160);

    public void testDefaults() {
        ISINGridTest.assertEquals((int)2160, (int)2160);
        ISINGridTest.assertEquals((int)2160, (int)this.grid.getRowCount());
        ISINGridTest.assertEquals((int)5940422, (int)this.grid.getTotalBinCount());
        ISINGridTest.assertEquals((double)(180.0 / (double)this.grid.getRowCount()), (double)this.grid.getDeltaLat(), (double)1.0E-10);
        ISINGridTest.assertEquals((double)(20037.508342789242 / (double)this.grid.getRowCount()), (double)this.grid.getBinSize(), (double)1.0E-10);
    }

    public void test_getRowLength() {
        ISINGridTest.assertEquals((int)3, (int)this.grid.getRowLength(0));
        ISINGridTest.assertEquals((int)9, (int)this.grid.getRowLength(1));
        ISINGridTest.assertEquals((int)16, (int)this.grid.getRowLength(2));
        ISINGridTest.assertEquals((int)22, (int)this.grid.getRowLength(3));
        ISINGridTest.assertEquals((int)4320, (int)this.grid.getRowLength(1079));
        ISINGridTest.assertEquals((int)4320, (int)this.grid.getRowLength(1080));
        ISINGridTest.assertEquals((int)3, (int)this.grid.getRowLength(2159));
        ISINGridTest.assertEquals((int)9, (int)this.grid.getRowLength(2158));
        ISINGridTest.assertEquals((int)16, (int)this.grid.getRowLength(2157));
        ISINGridTest.assertEquals((int)22, (int)this.grid.getRowLength(2156));
    }

    public void test_getRowOffset() {
        ISINGridTest.assertEquals((int)0, (int)this.grid.getBinOffset(0));
        ISINGridTest.assertEquals((int)3, (int)this.grid.getBinOffset(1));
        ISINGridTest.assertEquals((int)12, (int)this.grid.getBinOffset(2));
        ISINGridTest.assertEquals((int)28, (int)this.grid.getBinOffset(3));
        ISINGridTest.assertEquals((int)50, (int)this.grid.getBinOffset(4));
        ISINGridTest.assertEquals((int)2965891, (int)this.grid.getBinOffset(1079));
        ISINGridTest.assertEquals((int)2970211, (int)this.grid.getBinOffset(1080));
        ISINGridTest.assertEquals((int)5940419, (int)this.grid.getBinOffset(2159));
        ISINGridTest.assertEquals((int)5940410, (int)this.grid.getBinOffset(2158));
        ISINGridTest.assertEquals((int)0x5AA4AA, (int)this.grid.getBinOffset(2157));
        ISINGridTest.assertEquals((int)5940372, (int)this.grid.getBinOffset(2156));
    }

    public void test_getRowIndex() {
        ISINGridTest.assertEquals((int)0, (int)this.grid.getRowIndex(0));
        ISINGridTest.assertEquals((int)1, (int)this.grid.getRowIndex(3));
        ISINGridTest.assertEquals((int)2, (int)this.grid.getRowIndex(12));
        ISINGridTest.assertEquals((int)3, (int)this.grid.getRowIndex(28));
        ISINGridTest.assertEquals((int)4, (int)this.grid.getRowIndex(50));
        ISINGridTest.assertEquals((int)1079, (int)this.grid.getRowIndex(2965891));
        ISINGridTest.assertEquals((int)1080, (int)this.grid.getRowIndex(2970211));
        ISINGridTest.assertEquals((int)2158, (int)this.grid.getRowIndex(5940418));
        ISINGridTest.assertEquals((int)2159, (int)this.grid.getRowIndex(5940419));
        ISINGridTest.assertEquals((int)2159, (int)this.grid.getRowIndex(5940420));
        ISINGridTest.assertEquals((int)2159, (int)this.grid.getRowIndex(5940421));
        ISINGridTest.assertEquals((int)2158, (int)this.grid.getRowIndex(5940410));
        ISINGridTest.assertEquals((int)2158, (int)this.grid.getRowIndex(5940411));
        ISINGridTest.assertEquals((int)2157, (int)this.grid.getRowIndex(0x5AA4AA));
        ISINGridTest.assertEquals((int)2156, (int)this.grid.getRowIndex(5940372));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getRowIndex(-1000));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getRowIndex(-1));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getRowIndex(5940422));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getRowIndex(5941422));
    }

    public void test_getGridPoint() {
        Point point = new Point();
        ISINGridTest.assertEquals((Object)new Point(2, 0), (Object)this.grid.getGridPoint(2, point));
        ISINGridTest.assertEquals((Object)new Point(7, 1), (Object)this.grid.getGridPoint(10, point));
        ISINGridTest.assertEquals((Object)new Point(11, 2), (Object)this.grid.getGridPoint(23, point));
        ISINGridTest.assertEquals((Object)new Point(19, 3), (Object)this.grid.getGridPoint(47, point));
        ISINGridTest.assertEquals((Object)new Point(25, 4), (Object)this.grid.getGridPoint(75, point));
        ISINGridTest.assertEquals((Object)new Point(632, 1079), (Object)this.grid.getGridPoint(2966523, point));
        ISINGridTest.assertEquals((Object)new Point(1743, 1080), (Object)this.grid.getGridPoint(2971954, point));
        ISINGridTest.assertEquals((Object)new Point(1, 2159), (Object)this.grid.getGridPoint(5940420, point));
        ISINGridTest.assertEquals((Object)new Point(6, 2158), (Object)this.grid.getGridPoint(5940416, point));
        ISINGridTest.assertEquals((Object)new Point(15, 2157), (Object)this.grid.getGridPoint(5940409, point));
        ISINGridTest.assertEquals((Object)new Point(20, 2156), (Object)this.grid.getGridPoint(5940392, point));
        ISINGridTest.assertEquals((Object)new Point(-1, -1), (Object)this.grid.getGridPoint(-1000, point));
        ISINGridTest.assertEquals((Object)new Point(-1, -1), (Object)this.grid.getGridPoint(-1, point));
        ISINGridTest.assertEquals((Object)new Point(-1, -1), (Object)this.grid.getGridPoint(5940422, point));
        ISINGridTest.assertEquals((Object)new Point(-1, -1), (Object)this.grid.getGridPoint(5941422, point));
    }

    public void test_getBinIndex() {
        ISINGridTest.assertEquals((int)2, (int)this.grid.getBinIndex(new Point(2, 0)));
        ISINGridTest.assertEquals((int)10, (int)this.grid.getBinIndex(new Point(7, 1)));
        ISINGridTest.assertEquals((int)23, (int)this.grid.getBinIndex(new Point(11, 2)));
        ISINGridTest.assertEquals((int)47, (int)this.grid.getBinIndex(new Point(19, 3)));
        ISINGridTest.assertEquals((int)75, (int)this.grid.getBinIndex(new Point(25, 4)));
        ISINGridTest.assertEquals((int)2966523, (int)this.grid.getBinIndex(new Point(632, 1079)));
        ISINGridTest.assertEquals((int)2971954, (int)this.grid.getBinIndex(new Point(1743, 1080)));
        ISINGridTest.assertEquals((int)5940420, (int)this.grid.getBinIndex(new Point(1, 2159)));
        ISINGridTest.assertEquals((int)5940416, (int)this.grid.getBinIndex(new Point(6, 2158)));
        ISINGridTest.assertEquals((int)5940409, (int)this.grid.getBinIndex(new Point(15, 2157)));
        ISINGridTest.assertEquals((int)5940392, (int)this.grid.getBinIndex(new Point(20, 2156)));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getBinIndex(new Point(-1, -1)));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getBinIndex(new Point(-1, 23)));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getBinIndex(new Point(546, -1)));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getBinIndex(new Point(4321, 46)));
        ISINGridTest.assertEquals((int)-1, (int)this.grid.getBinIndex(new Point(343, 5940423)));
    }

    public void test_getColIndex() {
        ISINGridTest.assertEquals((int)0, (int)this.grid.getColIndex(0, 0.0));
        ISINGridTest.assertEquals((int)0, (int)this.grid.getColIndex(0, 45.0));
        ISINGridTest.assertEquals((int)1, (int)this.grid.getColIndex(0, 120.0));
        ISINGridTest.assertEquals((int)1, (int)this.grid.getColIndex(0, 165.0));
        ISINGridTest.assertEquals((int)2, (int)this.grid.getColIndex(0, 240.0));
        ISINGridTest.assertEquals((int)2, (int)this.grid.getColIndex(0, 285.0));
        ISINGridTest.assertEquals((int)3, (int)this.grid.getColIndex(0, 360.0));
        ISINGridTest.assertEquals((int)3, (int)this.grid.getColIndex(0, 405.0));
        try {
            this.grid.getColIndex(0, -285.0);
        }
        catch (Exception e) {
            ISINGridTest.fail();
        }
        try {
            this.grid.getColIndex(0, -165.0);
        }
        catch (Exception e) {
            ISINGridTest.fail();
        }
        try {
            this.grid.getColIndex(0, -45.0);
        }
        catch (Exception e) {
            ISINGridTest.fail();
        }
        try {
            this.grid.getColIndex(0, 360.0);
        }
        catch (Exception e) {
            ISINGridTest.fail();
        }
        try {
            this.grid.getColIndex(0, 405.0);
        }
        catch (Exception e) {
            ISINGridTest.fail();
        }
        try {
            this.grid.getColIndex(-1, 45.3);
            ISINGridTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.grid.getColIndex(this.grid.getRowCount(), 45.3);
            ISINGridTest.fail();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void test_getBinIndexWithLon() {
    }

    public void testDetectRowCount() throws Exception {
        String name9277 = "L3_ENV_MER_A443_m__20030301_GLOB_SI_ACR_9277x9277_-90+90+-180+180_0000.nc";
        ISINGridTest.assertEquals((int)2160, (int)ISINGrid.detectRowCount((String)"L3_ENV_MER_A443_m__20030301_GLOB_SI_ACR_9277x9277_-90+90+-180+180_0000.nc"));
        String name4320 = "L3_ENV_MER_CHL1_d__20070101_GLOB_SI_ESA_4638x4638_-90+90+-180+180_0000.nc";
        ISINGridTest.assertEquals((int)4320, (int)ISINGrid.detectRowCount((String)"L3_ENV_MER_CHL1_d__20070101_GLOB_SI_ESA_4638x4638_-90+90+-180+180_0000.nc"));
        String nameFoo = "foo";
        ISINGridTest.assertEquals((int)2160, (int)ISINGrid.detectRowCount((String)"foo"));
    }
}

