/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.smac;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import org.esa.s3tbx.smac.SmacSensorCoefficients;
import org.esa.snap.core.util.Guardian;

public class SensorCoefficientFile
implements SmacSensorCoefficients {
    private double _ah2o;
    private double _nh2o;
    private double _ao3;
    private double _no3;
    private double _ao2;
    private double _no2;
    private double _po2;
    private double _aco2;
    private double _nco2;
    private double _pco2;
    private double _ach4;
    private double _nch4;
    private double _pch4;
    private double _ano2;
    private double _nno2;
    private double _pno2;
    private double _aco;
    private double _nco;
    private double _pco;
    private double _a0s;
    private double _a1s;
    private double _a2s;
    private double _a3s;
    private double _a0T;
    private double _a1T;
    private double _a2T;
    private double _a3T;
    private double _taur;
    private double _sr;
    private double _a0taup;
    private double _a1taup;
    private double _wo;
    private double _gc;
    private double _a0P;
    private double _a1P;
    private double _a2P;
    private double _a3P;
    private double _a4P;
    private double _rest1;
    private double _rest2;
    private double _rest3;
    private double _rest4;
    private double _resr1;
    private double _resr2;
    private double _resr3;
    private double _resa1;
    private double _resa2;
    private double _resa3;
    private double _resa4;

    public void readFile(String fileName) throws IllegalArgumentException, IOException {
        Guardian.assertNotNull((String)"fileName", (Object)fileName);
        File coeffFile = new File(fileName);
        if (!coeffFile.exists() || !coeffFile.isFile()) {
            throw new FileNotFoundException();
        }
        this.scan(coeffFile);
    }

    @Override
    public double getAh2o() {
        return this._ah2o;
    }

    @Override
    public double getNh2o() {
        return this._nh2o;
    }

    @Override
    public double getAo3() {
        return this._ao3;
    }

    @Override
    public double getNo3() {
        return this._no3;
    }

    @Override
    public double getAo2() {
        return this._ao2;
    }

    @Override
    public double getNo2() {
        return this._no2;
    }

    @Override
    public double getPo2() {
        return this._po2;
    }

    @Override
    public double getAco2() {
        return this._aco2;
    }

    @Override
    public double getNco2() {
        return this._nco2;
    }

    @Override
    public double getPco2() {
        return this._pco2;
    }

    @Override
    public double getAch4() {
        return this._ach4;
    }

    @Override
    public double getNch4() {
        return this._nch4;
    }

    @Override
    public double getPch4() {
        return this._pch4;
    }

    @Override
    public double getAno2() {
        return this._ano2;
    }

    @Override
    public double getNno2() {
        return this._nno2;
    }

    @Override
    public double getPno2() {
        return this._pno2;
    }

    @Override
    public double getAco() {
        return this._aco;
    }

    @Override
    public double getNco() {
        return this._nco;
    }

    @Override
    public double getPco() {
        return this._pco;
    }

    @Override
    public double getA0s() {
        return this._a0s;
    }

    @Override
    public double getA1s() {
        return this._a1s;
    }

    @Override
    public double getA2s() {
        return this._a2s;
    }

    @Override
    public double getA3s() {
        return this._a3s;
    }

    @Override
    public double getA0T() {
        return this._a0T;
    }

    @Override
    public double getA1T() {
        return this._a1T;
    }

    @Override
    public double getA2T() {
        return this._a2T;
    }

    @Override
    public double getA3T() {
        return this._a3T;
    }

    @Override
    public double getTaur() {
        return this._taur;
    }

    @Override
    public double getSr() {
        return this._sr;
    }

    @Override
    public double getA0taup() {
        return this._a0taup;
    }

    @Override
    public double getA1taup() {
        return this._a1taup;
    }

    @Override
    public double getWo() {
        return this._wo;
    }

    @Override
    public double getGc() {
        return this._gc;
    }

    @Override
    public double getA0P() {
        return this._a0P;
    }

    @Override
    public double getA1P() {
        return this._a1P;
    }

    @Override
    public double getA2P() {
        return this._a2P;
    }

    @Override
    public double getA3P() {
        return this._a3P;
    }

    @Override
    public double getA4P() {
        return this._a4P;
    }

    @Override
    public double getRest1() {
        return this._rest1;
    }

    @Override
    public double getRest2() {
        return this._rest2;
    }

    @Override
    public double getRest3() {
        return this._rest3;
    }

    @Override
    public double getRest4() {
        return this._rest4;
    }

    @Override
    public double getResr1() {
        return this._resr1;
    }

    @Override
    public double getResr2() {
        return this._resr2;
    }

    @Override
    public double getResr3() {
        return this._resr3;
    }

    @Override
    public double getResa1() {
        return this._resa1;
    }

    @Override
    public double getResa2() {
        return this._resa2;
    }

    @Override
    public double getResa3() {
        return this._resa3;
    }

    @Override
    public double getResa4() {
        return this._resa4;
    }

    private void scan(File coeffFile) throws IOException {
        FileReader reader = new FileReader(coeffFile);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(false);
        tokenizer.wordChars(33, 255);
        this._ah2o = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._nh2o = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._ao3 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._no3 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._ao2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._no2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._po2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._aco2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._nco2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._pco2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._ach4 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._nch4 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._pch4 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._ano2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._nno2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._pno2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._aco = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._nco = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._pco = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a0s = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a1s = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a2s = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a3s = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a0T = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a1T = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a2T = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a3T = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._taur = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._sr = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a0taup = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a1taup = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._wo = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._gc = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a0P = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a1P = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a2P = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a3P = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._a4P = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._rest1 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._rest2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._rest3 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._rest4 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._resr1 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._resr2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._resr3 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._resa1 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._resa2 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._resa3 = SensorCoefficientFile.getNextCoefficient(tokenizer);
        this._resa4 = SensorCoefficientFile.getNextCoefficient(tokenizer);
    }

    private static double getNextCoefficient(StreamTokenizer tokenizer) throws IOException {
        tokenizer.nextToken();
        double ret = tokenizer.ttype == -2 ? tokenizer.nval : Double.valueOf(tokenizer.sval);
        return ret;
    }
}

