/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.smac;

import java.util.regex.Pattern;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.dataio.envisat.EnvisatConstants;

class SmacUtils {
    private static Pattern AATSR_L1_TOA_TYPE_PATTERN = Pattern.compile("ATS_TOA_1P");

    SmacUtils() {
    }

    public static String getSensorType(String productType) {
        Guardian.assertNotNull((String)"productType", (Object)productType);
        if (SmacUtils.isSupportedAatsrProductType(productType)) {
            return "AATSR";
        }
        if (SmacUtils.isSupportedMerisProductType(productType)) {
            return "MERIS";
        }
        return null;
    }

    public static boolean isSupportedMerisProductType(String productType) {
        return EnvisatConstants.MERIS_L1_TYPE_PATTERN.matcher(productType).matches();
    }

    public static boolean isSupportedAatsrProductType(String productType) {
        return AATSR_L1_TOA_TYPE_PATTERN.matcher(productType).matches();
    }

    public static boolean isSupportedProductType(String productType) {
        Guardian.assertNotNull((String)"productType", (Object)productType);
        return SmacUtils.isSupportedAatsrProductType(productType) || SmacUtils.isSupportedMerisProductType(productType);
    }
}

