/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.smac;

import org.esa.s3tbx.smac.SmacSensorCoefficients;
import org.esa.snap.core.util.Guardian;

public final class SmacAlgorithm {
    private static final double _cdr = Math.PI / 180;
    private static final double _crd = 57.29577951308232;
    private static final double _invMaxPressure = 9.871668311944718E-4;
    private static final double _oneQuarter = 0.25;
    private static final double _twoThird = 0.6666666666666666;
    private double _A0taup;
    private double _A1taup;
    private double _a0P;
    private double _a1P;
    private double _a2P;
    private double _a3P;
    private double _a4P;
    private double _ao3;
    private double _no3;
    private double _ah2o;
    private double _nh2o;
    private double _ao2;
    private double _no2;
    private double _po2;
    private double _aco2;
    private double _nco2;
    private double _pco2;
    private double _ach4;
    private double _nch4;
    private double _pch4;
    private double _ano2;
    private double _nno2;
    private double _pno2;
    private double _aco;
    private double _nco;
    private double _pco;
    private double _a0T;
    private double _a1T;
    private double _a2T;
    private double _a3T;
    private double _a0s;
    private double _a1s;
    private double _a2s;
    private double _a3s;
    private double _taur;
    private double _resr1;
    private double _resr2;
    private double _resr3;
    private double _resa1;
    private double _resa2;
    private double _resa3;
    private double _resa4;
    private double _rest1;
    private double _rest2;
    private double _rest3;
    private double _rest4;
    private double _wo;
    private double _onemwo;
    private double _gc;
    private double _ak;
    private double _ak2;
    private double _pfac;
    private double _b;
    private double _onepb;
    private double _onemb;
    private double _onepb2;
    private double _onemb2;
    private double _ww;
    private boolean _calcTo3;
    private boolean _calcTh2o;
    private boolean _calcTo2;
    private boolean _calcUo2;
    private boolean _calcTco2;
    private boolean _calcUco2;
    private boolean _calcTch4;
    private boolean _calcUch4;
    private boolean _calcTno2;
    private boolean _calcUno2;
    private boolean _calcTco;
    private boolean _calcUco;

    public final void setSensorCoefficients(SmacSensorCoefficients coeffs) {
        Guardian.assertNotNull((String)"coefficients", (Object)coeffs);
        this._A0taup = coeffs.getA0taup();
        this._A1taup = coeffs.getA1taup();
        this._ao3 = coeffs.getAo3();
        this._no3 = coeffs.getNo3();
        this._calcTo3 = true;
        if (this._ao3 == 0.0) {
            this._calcTo3 = false;
        }
        this._ah2o = coeffs.getAh2o();
        this._nh2o = coeffs.getNh2o();
        this._calcTh2o = true;
        if (this._ah2o == 0.0) {
            this._calcTh2o = false;
        }
        this._ao2 = coeffs.getAo2();
        this._no2 = coeffs.getNo2();
        this._calcTo2 = true;
        if (this._ao2 == 0.0) {
            this._calcTo2 = false;
        }
        this._po2 = coeffs.getPo2();
        this._calcUo2 = true;
        if (this._po2 == 0.0) {
            this._calcUo2 = false;
        }
        this._aco2 = coeffs.getAco2();
        this._nco2 = coeffs.getNco2();
        this._calcTco2 = true;
        if (this._aco2 == 0.0) {
            this._calcTco2 = false;
        }
        this._pco2 = coeffs.getPco2();
        this._calcUco2 = true;
        if (this._pco2 == 0.0) {
            this._calcUco2 = false;
        }
        this._ach4 = coeffs.getAch4();
        this._nch4 = coeffs.getNch4();
        this._calcTch4 = true;
        if (this._ach4 == 0.0) {
            this._calcTch4 = false;
        }
        this._pch4 = coeffs.getPch4();
        this._calcUch4 = true;
        if (this._pch4 == 0.0) {
            this._calcUch4 = false;
        }
        this._ano2 = coeffs.getAno2();
        this._nno2 = coeffs.getNno2();
        this._calcTno2 = true;
        if (this._ano2 == 0.0) {
            this._calcTno2 = false;
        }
        this._pno2 = coeffs.getPno2();
        this._calcUno2 = true;
        if (this._pno2 == 0.0) {
            this._calcUno2 = false;
        }
        this._aco = coeffs.getAco();
        this._nco = coeffs.getNco();
        this._calcTco = true;
        if (this._aco == 0.0) {
            this._calcTco = false;
        }
        this._pco = coeffs.getPco();
        this._calcUco = true;
        if (this._pco == 0.0) {
            this._calcUco = false;
        }
        this._a0T = coeffs.getA0T();
        this._a1T = coeffs.getA1T();
        this._a2T = coeffs.getA2T();
        this._a3T = coeffs.getA3T();
        this._a0s = coeffs.getA0s();
        this._a1s = coeffs.getA1s();
        this._a2s = coeffs.getA2s();
        this._a3s = coeffs.getA3s();
        this._taur = coeffs.getTaur();
        this._resr1 = coeffs.getResr1();
        this._resr2 = coeffs.getResr2();
        this._resr3 = coeffs.getResr3();
        this._a0P = coeffs.getA0P();
        this._a1P = coeffs.getA1P();
        this._a2P = coeffs.getA2P();
        this._a3P = coeffs.getA3P();
        this._a4P = coeffs.getA4P();
        this._wo = coeffs.getWo();
        this._gc = coeffs.getGc();
        this._resa1 = coeffs.getResa1();
        this._resa2 = coeffs.getResa2();
        this._resa3 = coeffs.getResa3();
        this._resa4 = coeffs.getResa4();
        this._rest1 = coeffs.getRest1();
        this._rest2 = coeffs.getRest2();
        this._rest3 = coeffs.getRest3();
        this._rest4 = coeffs.getRest4();
        this._ak2 = (1.0 - this._wo) * 3.0 * (1.0 - this._wo * this._gc);
        this._ak = Math.sqrt(this._ak2);
        this._b = 0.6666666666666666 * this._ak / (1.0 - this._wo * this._gc);
        this._onepb = 1.0 + this._b;
        this._onepb2 = this._onepb * this._onepb;
        this._onemb = 1.0 - this._b;
        this._onemb2 = this._onemb * this._onemb;
        this._ww = this._wo * 0.25;
        this._onemwo = 1.0 - this._wo;
        this._pfac = this._ak / (3.0 * (1.0 - this._wo * this._gc));
    }

    public final float[] run(float[] sza, float[] saa, float[] vza, float[] vaa, float[] taup550, float[] uh2o, float[] uo3, float[] airPressure, boolean[] process, float invalid, float[] r_toa, float[] r_surfRecycle) {
        float[] r_return = r_surfRecycle == null || r_surfRecycle.length != r_toa.length ? new float[r_toa.length] : r_surfRecycle;
        for (int n = 0; n < r_toa.length; ++n) {
            if (!process[n]) {
                r_return[n] = invalid;
                continue;
            }
            double us = Math.cos((double)sza[n] * (Math.PI / 180));
            double invUs = 1.0 / us;
            double us2 = us * us;
            double uv = Math.cos((double)vza[n] * (Math.PI / 180));
            double invUv = 1.0 / uv;
            double usTimesuv = us * uv;
            double invUsTimesUv = 1.0 / usTimesuv;
            double dphi = (double)(saa[n] - vaa[n]) * (Math.PI / 180);
            double Peq = (double)airPressure[n] * 9.871668311944718E-4;
            double m = invUs + invUv;
            double taup = this._A0taup + this._A1taup * (double)taup550[n];
            double uo2 = 1.0;
            if (this._calcUo2) {
                uo2 = Math.pow(Peq, this._po2);
            }
            double uco2 = 1.0;
            if (this._calcUco2) {
                uco2 = Math.pow(Peq, this._pco2);
            }
            double uch4 = 1.0;
            if (this._calcUch4) {
                uch4 = Math.pow(Peq, this._pch4);
            }
            double uno2 = 1.0;
            if (this._calcUno2) {
                uno2 = Math.pow(Peq, this._pno2);
            }
            double uco = 1.0;
            if (this._calcUco) {
                uco = Math.pow(Peq, this._pco);
            }
            double to3 = 1.0;
            double th2o = 1.0;
            double to2 = 1.0;
            double tco2 = 1.0;
            double tch4 = 1.0;
            double tno2 = 1.0;
            double tco = 1.0;
            if ((double)uh2o[n] > 0.0 || (double)uo3[n] > 0.0) {
                if (this._calcTo3) {
                    to3 = Math.exp(this._ao3 * Math.pow((double)uo3[n] * m, this._no3));
                }
                if (this._calcTh2o) {
                    th2o = Math.exp(this._ah2o * Math.pow((double)uh2o[n] * m, this._nh2o));
                }
                if (this._calcTo2) {
                    to2 = Math.exp(this._ao2 * Math.pow(uo2 * m, this._no2));
                }
                if (this._calcTco2) {
                    tco2 = Math.exp(this._aco2 * Math.pow(uco2 * m, this._nco2));
                }
                if (this._calcTch4) {
                    tch4 = Math.exp(this._ach4 * Math.pow(uch4 * m, this._nch4));
                }
                if (this._calcTno2) {
                    tno2 = Math.exp(this._ano2 * Math.pow(uno2 * m, this._nno2));
                }
                if (this._calcTco) {
                    tco = Math.exp(this._aco * Math.pow(uco * m, this._nco));
                }
            }
            double temp = this._a2T * Peq + this._a3T;
            double ttetas = this._a0T + this._a1T * (double)taup550[n] * invUs + temp / (1.0 + us);
            double ttetav = this._a0T + this._a1T * (double)taup550[n] * invUv + temp / (1.0 + uv);
            double s = this._a0s * Peq + this._a3s + this._a1s * (double)taup550[n] + this._a2s * (double)taup550[n] * (double)taup550[n];
            double cksi = -(usTimesuv + Math.sqrt(1.0 - us2) * Math.sqrt(1.0 - uv * uv) * Math.cos(dphi));
            if (cksi < -1.0) {
                cksi = -1.0;
            }
            double ksiD = 57.29577951308232 * Math.acos(cksi);
            double ray_phase = 0.7190443 * (1.0 + cksi * cksi) + 0.0412742;
            double taurz = this._taur * Peq;
            double ray_ref = taurz * ray_phase * 0.25 * invUsTimesUv;
            temp = taurz * ray_phase * invUsTimesUv;
            double Res_ray = this._resr1 + this._resr2 * temp + this._resr3 * temp * temp;
            temp = ksiD * ksiD;
            double aer_phase = this._a0P + this._a1P * ksiD + this._a2P * temp + this._a3P * temp * ksiD + this._a4P * temp * temp;
            temp = 1.0 / (4.0 * (1.0 - this._ak2 * us2));
            double e = -3.0 * us2 * this._wo * temp;
            double f = -this._onemwo * 3.0 * this._gc * us2 * this._wo * temp;
            double dp = e / (3.0 * us) + us * f;
            double d = e + f;
            double del = Math.exp(this._ak * taup) * this._onepb2 - Math.exp(-this._ak * taup) * this._onemb2;
            double ss = us / (1.0 - this._ak2 * us2);
            temp = 3.0 * us;
            double q1 = 2.0 + temp + this._onemwo * temp * this._gc * (1.0 + 2.0 * us);
            double q2 = 2.0 - temp - this._onemwo * temp * this._gc * (1.0 - 2.0 * us);
            double q3 = q2 * Math.exp(-taup * invUs);
            temp = this._ww * ss / del;
            double c1 = temp * (q1 * Math.exp(this._ak * taup) * this._onepb + q3 * this._onemb);
            double c2 = -temp * (q1 * Math.exp(-this._ak * taup) * this._onemb + q3 * this._onepb);
            double cp1 = c1 * this._pfac;
            double cp2 = -c2 * this._pfac;
            temp = this._wo * 3.0 * this._gc * uv;
            double z = d - temp * dp + this._wo * aer_phase * 0.25;
            double x = c1 - temp * cp1;
            double y = c2 - temp * cp2;
            temp = this._ak * uv;
            double aa1 = uv / (1.0 + temp);
            double aa2 = uv / (1.0 - temp);
            double aa3 = usTimesuv / (us + uv);
            double aer_ref = x * aa1 * (1.0 - Math.exp(-taup / aa1));
            aer_ref += y * aa2 * (1.0 - Math.exp(-taup / aa2));
            aer_ref += z * aa3 * (1.0 - Math.exp(-taup / aa3));
            aer_ref *= invUsTimesUv;
            temp = taup * m * cksi;
            double Res_aer = this._resa1 + this._resa2 * temp + this._resa3 * temp * temp + this._resa4 * temp * temp * temp;
            double tautot = taup + taurz;
            temp = tautot * m * cksi;
            double Res_6s = this._rest1 + this._rest2 * temp + this._rest3 * temp * temp + this._rest4 * temp * temp * temp;
            double atm_ref = ray_ref - Res_ray + aer_ref - Res_aer + Res_6s;
            double tg = th2o * to3 * to2 * tco2 * tch4 * tco * tno2;
            temp = (double)r_toa[n] - atm_ref * tg;
            temp /= tg * ttetas * ttetav + temp * s;
            r_return[n] = (float)temp;
        }
        return r_return;
    }
}

