/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.smac;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.smac.AEROSOL_TYPE;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ObjectUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.CsvReader;

public class SensorCoefficientManager {
    public static final String AER_DES_NAME = "DES";
    public static final String AER_CONT_NAME = "CONT";
    public static final String MERIS_NAME = "MERIS";
    public static final String AATSR_NAME = "AATSR";
    private static final char[] fieldSeparators = new char[]{'|'};
    private static final String mapFileName = "SensorMap.txt";
    private List<SensorDb> sensors;
    private String locationPath;
    private Map<AEROSOL_TYPE, String> aerosolTypeMap;

    public SensorCoefficientManager() {
        this.init();
    }

    public SensorCoefficientManager(URL location) throws IOException {
        Guardian.assertNotNull((String)"location", (Object)location);
        this.init();
        this.setURL(location);
    }

    public void setURL(URL location) throws IOException {
        URL mapFileURL;
        Guardian.assertNotNull((String)"location", (Object)location);
        String file = null;
        try {
            file = SystemUtils.convertToLocalPath((String)(location.getPath() + "/" + mapFileName));
            mapFileURL = new URL(location.getProtocol(), location.getHost(), file);
        }
        catch (MalformedURLException e) {
            throw new IOException("Unable to open coefficient map file from URL '" + file + "'", e);
        }
        this.setLocationPath(location);
        try (InputStream in = mapFileURL.openStream();){
            String[] record;
            CsvReader csvReader = new CsvReader((Reader)new InputStreamReader(in), fieldSeparators);
            while ((record = csvReader.readRecord()) != null) {
                SensorDb sensorDb = this.getSensorDb(record[0]);
                if (sensorDb == null) {
                    sensorDb = new SensorDb(record[0]);
                    this.sensors.add(sensorDb);
                }
                BandDb bandDb = new BandDb(record[1], record[2], record[3]);
                sensorDb.addBand(bandDb);
            }
        }
    }

    public URL getCoefficientFile(String sensor, String bandName, AEROSOL_TYPE aerosolType) {
        URL url = null;
        SensorDb sensorDb = this.getSensorDb(sensor);
        if (sensorDb != null) {
            BandDb bandDb = sensorDb.getBand(bandName, this.aerosolTypeMap.get((Object)aerosolType));
            if (bandDb == null) {
                return null;
            }
            try {
                url = new URL(bandDb.getCoefficientFileName());
            }
            catch (MalformedURLException e) {
                try {
                    url = new URL(this.locationPath + bandDb.getCoefficientFileName());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return url;
    }

    private void init() {
        this.sensors = new ArrayList<SensorDb>();
        this.aerosolTypeMap = new HashMap<AEROSOL_TYPE, String>();
        this.aerosolTypeMap.put(AEROSOL_TYPE.CONTINENTAL, AER_CONT_NAME);
        this.aerosolTypeMap.put(AEROSOL_TYPE.DESERT, AER_DES_NAME);
    }

    private SensorDb getSensorDb(String name) {
        SensorDb sensorDb = null;
        for (SensorDb sensor : this.sensors) {
            SensorDb current = sensor;
            if (!ObjectUtils.equalObjects((Object)name, (Object)current.getName())) continue;
            sensorDb = current;
        }
        return sensorDb;
    }

    private void setLocationPath(URL location) {
        this.locationPath = location.toExternalForm();
    }

    private class BandDb {
        String bandName;
        String aerosolType;
        String coeffFileName;

        BandDb(String bandName, String aerosolType, String coefficientFileName) {
            this.setBandName(bandName);
            this.setAerosolType(aerosolType);
            this.setCoefficientFileName(coefficientFileName);
        }

        void setBandName(String bandName) {
            Guardian.assertNotNull((String)"bandName", (Object)bandName);
            this.bandName = bandName;
        }

        String getBandName() {
            return this.bandName;
        }

        void setAerosolType(String aerosolType) {
            Guardian.assertNotNull((String)"aerosolType", (Object)aerosolType);
            this.aerosolType = aerosolType;
        }

        String getAerosolType() {
            return this.aerosolType;
        }

        void setCoefficientFileName(String coeffFile) {
            Guardian.assertNotNull((String)"coeffFile", (Object)coeffFile);
            this.coeffFileName = coeffFile;
        }

        String getCoefficientFileName() {
            return this.coeffFileName;
        }
    }

    private class SensorDb {
        private String name;
        private List<BandDb> bands;

        SensorDb(String name) {
            this.init();
            this.setName(name);
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            Guardian.assertNotNull((String)"name", (Object)name);
            this.name = name;
        }

        void addBand(BandDb band) {
            Guardian.assertNotNull((String)"bandDb", (Object)band);
            this.bands.add(band);
        }

        public BandDb getBand(String name, String aerosolType) {
            BandDb ret = null;
            for (BandDb band : this.bands) {
                BandDb current = band;
                if (!ObjectUtils.equalObjects((Object)name, (Object)current.getBandName()) || !ObjectUtils.equalObjects((Object)aerosolType, (Object)current.getAerosolType())) continue;
                ret = current;
                break;
            }
            return ret;
        }

        private void init() {
            this.bands = new ArrayList<BandDb>();
        }
    }
}

