/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.sdr;

import com.bc.jnn.Jnn;
import com.bc.jnn.JnnException;
import com.bc.jnn.JnnNet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.esa.s3tbx.meris.sdr.SdrAlgorithm;
import org.esa.snap.core.util.io.CsvReader;
import org.junit.Assert;
import org.junit.Test;

public class SdrAlgorithmTest {
    private static final String NEURAL_NET_RESOURCE_PATH = "run05_100.nna";
    private static final String TEST_PIXEL_RESOURCE_PATH = "run05_100_test_pixel.dat";
    private static final double EPS = 1.0E-5;

    @Test
    public void testValidConstructorCall() {
        try {
            new SdrAlgorithm(new JnnNet());
        }
        catch (IllegalArgumentException notExpected) {
            Assert.fail();
        }
    }

    @Test
    public void testInvalidConstructorCall() {
        try {
            new SdrAlgorithm(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSdaComputation() throws IOException, JnnException {
        JnnNet neuralNet = this.readNeuralNet();
        SdrAlgorithm algorithm = new SdrAlgorithm(neuralNet);
        double sdr = algorithm.computeSdr(0.0186672, 412.5, 5.10563, 38.6851, -139.682, 0.496, 0.29, 1.58081);
        Assert.assertEquals((double)0.0242241, (double)sdr, (double)1.0E-5);
    }

    @Test
    public void testNeuralNetFunction() throws IOException, JnnException {
        double[][] testVectors;
        JnnNet neuralNet = this.readNeuralNet();
        SdrAlgorithm algorithm = new SdrAlgorithm(neuralNet);
        for (double[] testVector : testVectors = this.readTestPixels()) {
            double[] input = new double[testVector.length - 1];
            double[] actualOutput = new double[1];
            double[] expectedOutput = new double[1];
            System.arraycopy(testVector, 0, input, 0, input.length);
            expectedOutput[0] = testVector[testVector.length - 1];
            algorithm.computeSdr(input, actualOutput);
            Assert.assertEquals((double)expectedOutput[0], (double)actualOutput[0], (double)1.0E-5);
        }
    }

    private JnnNet readNeuralNet() throws IOException, JnnException {
        InputStream stream = SdrAlgorithmTest.class.getResourceAsStream(NEURAL_NET_RESOURCE_PATH);
        try (InputStreamReader reader = new InputStreamReader(stream);){
            JnnNet jnnNet = Jnn.readNna((Reader)reader);
            return jnnNet;
        }
    }

    private double[][] readTestPixels() throws IOException {
        List recordList;
        InputStream stream = SdrAlgorithmTest.class.getResourceAsStream(TEST_PIXEL_RESOURCE_PATH);
        InputStreamReader reader = new InputStreamReader(stream);
        try (CsvReader csvReader = new CsvReader((Reader)reader, new char[]{' ', '\t'}, true, "#");){
            recordList = csvReader.readStringRecords();
        }
        String[] header = (String[])recordList.get(0);
        recordList.remove(0);
        double[][] testData = new double[recordList.size()][header.length];
        for (int i = 0; i < recordList.size(); ++i) {
            String[] record = (String[])recordList.get(i);
            if (record.length != header.length) {
                throw new IOException("record.length != header.length");
            }
            for (int j = 0; j < record.length; ++j) {
                String value = record[j];
                try {
                    testData[i][j] = Double.parseDouble(value);
                    continue;
                }
                catch (NumberFormatException ignored) {
                    throw new IOException("record #" + (j + 1) + ": invalid number: " + value);
                }
            }
        }
        return testData;
    }
}

