/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.esa.s3tbx.meris.cloud.CentralWavelengthProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CentralWavelengthProviderTest {
    private static float DIFF = 1.0E-6f;
    private CentralWavelengthProvider provider;

    @Before
    public void setUp() {
        this.provider = new CentralWavelengthProvider();
    }

    @Test
    public void testInit() {
        float[] cwRR = this.provider.getCentralWavelength("MER_RR");
        Assert.assertEquals((String)"925 members", (long)925L, (long)cwRR.length);
        Assert.assertEquals((String)"value 0", (float)0.0f, (float)cwRR[0], (float)DIFF);
        Assert.assertEquals((String)"value 1", (float)0.0f, (float)cwRR[1], (float)DIFF);
        Assert.assertEquals((String)"value 924", (float)0.0f, (float)cwRR[924], (float)DIFF);
    }

    @Test
    public void testIllegalProductType() {
        try {
            this.provider.getCentralWavelength("MER_TT");
            Assert.fail((String)"Exception expected.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadCW() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (int i = 0; i < 925; ++i) {
            String line = String.valueOf(i) + "\n";
            outputStream.write(line.getBytes());
        }
        byte[] outArray = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outArray);
        this.provider.readCW((InputStream)inputStream);
        float[] cwRR = this.provider.getCentralWavelength("MER_RR");
        Assert.assertEquals((String)"925 members", (long)925L, (long)cwRR.length);
        Assert.assertEquals((String)"value 0", (float)0.0f, (float)cwRR[0], (float)DIFF);
        Assert.assertEquals((String)"value 1", (float)1.0f, (float)cwRR[1], (float)DIFF);
        Assert.assertEquals((String)"value 2", (float)2.0f, (float)cwRR[2], (float)DIFF);
        Assert.assertEquals((String)"value 924", (float)924.0f, (float)cwRR[924], (float)DIFF);
    }

    @Test
    public void testFr() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        float value = 1.5f;
        for (int i = 0; i < 925; ++i) {
            String line = String.valueOf(value) + "\n";
            outputStream.write(line.getBytes());
            value += 4.0f;
        }
        byte[] outArray = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outArray);
        this.provider.readCW((InputStream)inputStream);
        float[] cwFR = this.provider.getCentralWavelength("MER_FR");
        Assert.assertEquals((String)"3700 members", (long)3700L, (long)cwFR.length);
        for (int i = 0; i < 3700; ++i) {
            Assert.assertEquals((String)("value " + i), (float)i, (float)cwFR[i], (float)DIFF);
        }
    }

    @Test
    public void testFrDiscontinuiti() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (int camera = 0; camera < 5; ++camera) {
            float value = 1.5f;
            for (int i = 0; i < 185; ++i) {
                String line = String.valueOf(value) + "\n";
                outputStream.write(line.getBytes());
                value += 4.0f;
            }
        }
        byte[] outArray = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outArray);
        this.provider.readCW((InputStream)inputStream);
        float[] cwFR = this.provider.getCentralWavelength("MER_FR");
        Assert.assertEquals((String)"3700 members", (long)3700L, (long)cwFR.length);
        int index = 0;
        for (int camera = 0; camera < 5; ++camera) {
            for (int value = 0; value < 740; ++value) {
                Assert.assertEquals((String)("value " + index), (float)value, (float)cwFR[index], (float)DIFF);
                ++index;
            }
        }
    }
}

