/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.brr.operator;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import org.esa.s3tbx.meris.brr.operator.MerisL1BProduct;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class BrrOpIntegrationTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        boolean internetAvailable;
        try {
            URLConnection urlConnection = new URL("http://www.google.com").openConnection();
            urlConnection.setConnectTimeout(5);
            urlConnection.getContent();
            internetAvailable = true;
        }
        catch (IOException e) {
            internetAvailable = false;
        }
        Assume.assumeTrue((String)"Internet connection not available, skipping BrrOpIntegrationTest", (boolean)internetAvailable);
    }

    @Test
    public void testProcessMerisL1B() throws IOException {
        Product merisL1BProduct = MerisL1BProduct.create();
        Product target = GPF.createProduct((String)"Meris.Brr", this.createParameter(), (Product)merisL1BProduct);
        try {
            this.assertCorrectBand("brr_1", new float[]{0.032894164f, 0.032959674f}, target);
            this.assertCorrectBand("brr_2", new float[]{0.031884823f, 0.032448795f}, target);
            this.assertCorrectBand("brr_3", new float[]{0.033055514f, 0.03287222f}, target);
            this.assertCorrectBand("brr_4", new float[]{0.031992495f, 0.031583574f}, target);
            this.assertCorrectBand("brr_5", new float[]{0.025552496f, 0.025396578f}, target);
            this.assertCorrectBand("brr_6", new float[]{0.016063847f, 0.015916752f}, target);
            this.assertCorrectBand("brr_7", new float[]{0.014079448f, 0.013955961f}, target);
            this.assertCorrectBand("brr_8", new float[]{0.013317848f, 0.013692145f}, target);
            this.assertCorrectBand("brr_9", new float[]{0.012169723f, 0.012201455f}, target);
            this.assertCorrectBand("brr_10", new float[]{0.010856963f, 0.010678502f}, target);
            this.assertCorrectBand("brr_12", new float[]{0.010445503f, 0.010495728f}, target);
            this.assertCorrectBand("brr_13", new float[]{0.0091937855f, 0.0089309625f}, target);
            this.assertCorrectBand("brr_14", new float[]{0.008603007f, 0.008259f}, target);
        }
        finally {
            if (target != null) {
                target.dispose();
            }
        }
    }

    private void assertCorrectBand(String bandName, float[] data, Product savedProduct) {
        Band brr_1 = savedProduct.getBand(bandName);
        Assert.assertNotNull((Object)brr_1);
        Assert.assertEquals((double)data[0], (double)brr_1.getSampleFloat(0, 0), (double)1.0E-8);
        Assert.assertEquals((double)data[1], (double)brr_1.getSampleFloat(1, 0), (double)1.0E-8);
    }

    private HashMap<String, Object> createParameter() {
        HashMap<String, Object> parametermap = new HashMap<String, Object>();
        parametermap.put("correctWater", "true");
        return parametermap;
    }
}

