/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

import java.io.File;
import java.text.DateFormat;
import org.esa.s3tbx.meris.aerosol.MOD08FileFactory;
import org.esa.s3tbx.meris.aerosol.TemporalFile;
import org.esa.s3tbx.meris.aerosol.UTCTest;
import org.junit.Assert;
import org.junit.Test;

public class MOD08FileFactoryTest {
    @Test
    public void testCreateTemporalFile() {
        DateFormat dateFormat = UTCTest.getDateTimeFormat();
        MOD08FileFactory ff = new MOD08FileFactory();
        File f = new File("MOD08_E3.A2003001.004.2003337033342.hdf_FUB.hdf");
        TemporalFile tf = ff.createTemporalFile(f);
        Assert.assertNotNull((Object)tf);
        Assert.assertEquals((Object)"01.01.2003 00:00:00", (Object)dateFormat.format(tf.getStartDate()));
        Assert.assertEquals((Object)"08.01.2003 23:59:59", (Object)dateFormat.format(tf.getEndDate()));
        f = new File("MOD08_E3.A2003169.004.2003343085247.hdf_FUB.hdf");
        tf = ff.createTemporalFile(f);
        Assert.assertNotNull((Object)tf);
        Assert.assertEquals((Object)"18.06.2003 00:00:00", (Object)dateFormat.format(tf.getStartDate()));
        Assert.assertEquals((Object)"25.06.2003 23:59:59", (Object)dateFormat.format(tf.getEndDate()));
        f = new File("MOD08_E3.A2003365.004.2003343085247.hdf_FUB.hdf");
        tf = ff.createTemporalFile(f);
        Assert.assertNotNull((Object)tf);
        Assert.assertEquals((Object)"31.12.2003 00:00:00", (Object)dateFormat.format(tf.getStartDate()));
        Assert.assertEquals((Object)"07.01.2004 23:59:59", (Object)dateFormat.format(tf.getEndDate()));
        f = new File("MOD08PSMOD08_E3.A2005001.004.2005011171600.hdf");
        tf = ff.createTemporalFile(f);
        Assert.assertNotNull((Object)tf);
        Assert.assertEquals((Object)"01.01.2005 00:00:00", (Object)dateFormat.format(tf.getStartDate()));
        f = new File("MOD08_E3_MOD08SUB.A2006025.0000.001.2006038141658.hdf");
        tf = ff.createTemporalFile(f);
        Assert.assertNotNull((Object)tf);
        Assert.assertEquals((Object)"25.01.2006 00:00:00", (Object)dateFormat.format(tf.getStartDate()));
    }
}

