/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

import java.io.File;
import java.text.DateFormat;
import org.esa.s3tbx.meris.aerosol.ClimFileFactory;
import org.esa.s3tbx.meris.aerosol.TemporalFile;
import org.esa.s3tbx.meris.aerosol.UTCTest;
import org.junit.Assert;
import org.junit.Test;

public class ClimFileFactoryTest {
    @Test
    public void testCreateTemporalFile() {
        DateFormat dateFormat = UTCTest.getDateTimeFormat();
        ClimFileFactory ff = new ClimFileFactory();
        File f = new File("CLIM_GADS_200310_200403_FUB.hdf");
        TemporalFile tf = ff.createTemporalFile(f);
        Assert.assertNotNull((Object)tf);
        Assert.assertEquals((Object)"01.10.2003 00:00:00", (Object)dateFormat.format(tf.getStartDate()));
        Assert.assertEquals((Object)"31.03.2004 23:59:59", (Object)dateFormat.format(tf.getEndDate()));
        f = new File("CLIM_GADS_200304_200309_FUB.hdf");
        tf = ff.createTemporalFile(f);
        Assert.assertNotNull((Object)tf);
        Assert.assertEquals((Object)"01.04.2003 00:00:00", (Object)dateFormat.format(tf.getStartDate()));
        Assert.assertEquals((Object)"30.09.2003 23:59:59", (Object)dateFormat.format(tf.getEndDate()));
    }
}

