/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.sdr;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.jnn.Jnn;
import com.bc.jnn.JnnException;
import com.bc.jnn.JnnNet;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Map;
import org.esa.s3tbx.meris.AlbedoUtils;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.s3tbx.meris.sdr.SdrAlgorithm;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;

@OperatorMetadata(alias="Meris.Sdr", internal=true)
public class SdrOp
extends MerisBasisOp {
    private static final String DEFAULT_OUTPUT_PRODUCT_NAME = "MER_SDR";
    private static final String SDR_PRODUCT_TYPE = "MER_L2_SDR";
    private static final String SDR_BAND_NAME_PREFIX = "sdr_";
    private static final String SDR_FLAGS_BAND_NAME = "sdr_flags";
    private static final String SDR_INVALID_FLAG_NAME = "INVALID_SDR";
    private static final int SDR_INVALID_FLAG_VALUE = 1;
    private static final float SCALING_FACTOR = 1.0E-4f;
    private static final int[] sdrBandNo = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14};
    private SdrAlgorithm algorithm;
    private Band[] reflectanceBands;
    private Band[] sdrBands;
    private Band sdrFlagBand;
    private Band validBand;
    @SourceProduct(alias="l1b")
    private Product l1bProduct;
    @SourceProduct(alias="brr")
    private Product brrProduct;
    @SourceProduct(alias="aerosol")
    private Product aerosolProduct;
    @SourceProduct(alias="mask")
    private Product maskProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter
    private String neuralNetFile;
    @Parameter
    private String validBandName;
    @Parameter
    private String aot470Name;
    @Parameter
    private String angName;
    @Parameter
    private double angValue;

    public void initialize() throws OperatorException {
        if (StringUtils.isNullOrEmpty((String)this.neuralNetFile)) {
            throw new OperatorException("No neural net specified.");
        }
        if (StringUtils.isNullOrEmpty((String)this.aot470Name)) {
            throw new OperatorException("No aot470 band specified.");
        }
        try {
            this.loadNeuralNet();
        }
        catch (Exception e) {
            throw new OperatorException("Failed to load neural net " + this.neuralNetFile + ":\n" + e.getMessage());
        }
        this.createTargetProduct();
    }

    private void createTargetProduct() {
        this.targetProduct = this.createCompatibleProduct(this.l1bProduct, DEFAULT_OUTPUT_PRODUCT_NAME, SDR_PRODUCT_TYPE);
        this.reflectanceBands = new Band[sdrBandNo.length];
        this.sdrBands = new Band[sdrBandNo.length];
        for (int i = 0; i < sdrBandNo.length; ++i) {
            this.reflectanceBands[i] = this.brrProduct.getBand("brr_" + Integer.toString(sdrBandNo[i]));
            Band band = this.l1bProduct.getBand("radiance_" + Integer.toString(sdrBandNo[i]));
            Band sdrOutputBand = this.targetProduct.addBand(SDR_BAND_NAME_PREFIX + Integer.toString(sdrBandNo[i]), 11);
            sdrOutputBand.setDescription("Surface directional reflectance at " + band.getSpectralWavelength() + " nm");
            sdrOutputBand.setUnit("1");
            sdrOutputBand.setScalingFactor((double)1.0E-4f);
            ProductUtils.copySpectralBandProperties((Band)band, (Band)sdrOutputBand);
            sdrOutputBand.setNoDataValueUsed(true);
            sdrOutputBand.setGeophysicalNoDataValue(-1.0);
            this.sdrBands[i] = sdrOutputBand;
        }
        FlagCoding sdiFlagCoding = this.createSdiFlagCoding(this.targetProduct);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)sdiFlagCoding);
        this.sdrFlagBand = this.targetProduct.addBand(SDR_FLAGS_BAND_NAME, 21);
        this.sdrFlagBand.setDescription("SDR specific flags");
        this.sdrFlagBand.setSampleCoding((SampleCoding)sdiFlagCoding);
        this.validBand = this.maskProduct.getBand(this.validBandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        pm.beginTask("Processing frame...", rectangle.height);
        try {
            Tile sza = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("sun_zenith"), rectangle);
            Tile saa = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("sun_azimuth"), rectangle);
            Tile vza = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("view_zenith"), rectangle);
            Tile vaa = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("view_azimuth"), rectangle);
            Tile ang = null;
            if (StringUtils.isNotNullAndNotEmpty((String)this.angName)) {
                ang = this.getSourceTile((RasterDataNode)this.aerosolProduct.getBand(this.angName), rectangle);
            }
            Tile aot470 = this.getSourceTile((RasterDataNode)this.aerosolProduct.getBand(this.aot470Name), rectangle);
            Tile[] reflectance = new Tile[sdrBandNo.length];
            Tile[] sdr = new Tile[sdrBandNo.length];
            for (int i = 0; i < sdrBandNo.length; ++i) {
                reflectance[i] = this.getSourceTile((RasterDataNode)this.reflectanceBands[i], rectangle);
            }
            Tile isValidPixel = this.getSourceTile((RasterDataNode)this.validBand, rectangle);
            for (int i = 0; i < this.sdrBands.length; ++i) {
                sdr[i] = targetTiles.get(this.sdrBands[i]);
            }
            Tile sdrFlag = targetTiles.get(this.sdrFlagBand);
            SdrAlgorithm clonedAlgorithm = this.algorithm.clone();
            double[] sdrAlgoInput = new double[9];
            double[] sdrAlgoOutput = new double[1];
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    if (isValidPixel.getSampleBoolean(x, y)) {
                        double t_sza = sza.getSampleDouble(x, y) * (Math.PI / 180);
                        double t_vza = vza.getSampleDouble(x, y) * (Math.PI / 180);
                        double ada = AlbedoUtils.computeAzimuthDifference(vaa.getSampleDouble(x, y), saa.getSampleDouble(x, y)) * (Math.PI / 180);
                        double mueSun = Math.cos(t_sza);
                        double geomX = Math.sin(t_vza) * Math.cos(ada);
                        double geomY = Math.sin(t_vza) * Math.sin(ada);
                        double geomZ = Math.cos(t_vza);
                        short sdrFlags = 0;
                        for (int bandId = 0; bandId < this.reflectanceBands.length; ++bandId) {
                            Band reflInputBand = this.reflectanceBands[bandId];
                            double rhoNorm = reflectance[bandId].getSampleDouble(x, y) / Math.PI;
                            double wavelength = reflInputBand.getSpectralWavelength();
                            sdrAlgoInput[0] = rhoNorm;
                            sdrAlgoInput[1] = wavelength;
                            sdrAlgoInput[2] = mueSun;
                            sdrAlgoInput[3] = geomX;
                            sdrAlgoInput[4] = geomY;
                            sdrAlgoInput[5] = geomZ;
                            sdrAlgoInput[6] = aot470.getSampleDouble(x, y);
                            sdrAlgoInput[7] = 0.0;
                            sdrAlgoInput[8] = ang != null ? ang.getSampleDouble(x, y) : this.angValue;
                            clonedAlgorithm.computeSdr(sdrAlgoInput, sdrAlgoOutput);
                            double t_sdr = sdrAlgoOutput[0];
                            if (Double.isInfinite(t_sdr) || Double.isNaN(t_sdr)) {
                                t_sdr = 0.0;
                                sdrFlags = (short)(sdrFlags | 1 << reflInputBand.getSpectralBandIndex() + 1);
                            } else if (t_sdr < 0.0) {
                                t_sdr = 0.0;
                                sdrFlags = (short)(sdrFlags | 1 << reflInputBand.getSpectralBandIndex() + 1);
                            } else if (t_sdr > 1.0) {
                                t_sdr = 1.0;
                                sdrFlags = (short)(sdrFlags | 1 << reflInputBand.getSpectralBandIndex() + 1);
                            }
                            sdr[bandId].setSample(x, y, (float)t_sdr);
                        }
                        sdrFlags = (short)(sdrFlags | (sdrFlags != 0 ? 1 : 0));
                        sdrFlag.setSample(x, y, (int)sdrFlags);
                        continue;
                    }
                    for (int j = 0; j < this.reflectanceBands.length; ++j) {
                        sdr[j].setSample(x, y, -1);
                    }
                    sdrFlag.setSample(x, y, 1);
                }
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    private void loadNeuralNet() throws IOException, JnnException {
        JnnNet neuralNet;
        Path auxdataDirPath = SystemUtils.getAuxDataPath().resolve("ctp").toAbsolutePath();
        File auxdataTargetDir = auxdataDirPath.toFile();
        Path sourcePath = ResourceInstaller.findModuleCodeBasePath(((Object)((Object)this)).getClass()).resolve("auxdata");
        try {
            new ResourceInstaller(sourcePath, auxdataDirPath).install(".*", ProgressMonitor.NULL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File nnFile = new File(auxdataTargetDir, this.neuralNetFile);
        try (FileReader reader = new FileReader(nnFile);){
            Jnn.setOptimizing((boolean)true);
            neuralNet = Jnn.readNna((Reader)reader);
        }
        this.algorithm = new SdrAlgorithm(neuralNet);
    }

    private FlagCoding createSdiFlagCoding(Product outputProduct) {
        double rf1 = 0.3;
        double gf1 = 1.0;
        double bf1 = 0.5;
        FlagCoding flagCoding = new FlagCoding(SDR_FLAGS_BAND_NAME);
        flagCoding.setDescription("SDR Flag Coding");
        MetadataAttribute invAttr = new MetadataAttribute(SDR_INVALID_FLAG_NAME, 12);
        invAttr.getData().setElemInt(1);
        invAttr.setDescription("SDR spectrum is invalid");
        flagCoding.addAttribute(invAttr);
        int index = 0;
        int w = outputProduct.getSceneRasterWidth();
        int h = outputProduct.getSceneRasterHeight();
        double a = 0.0;
        Color color = new Color((float)(0.5 + 0.5 * Math.sin(a + 0.9424777960769379)), (float)(0.5 + 0.5 * Math.sin(a + Math.PI)), (float)(0.5 + 0.5 * Math.sin(a + 1.5707963267948966)));
        Mask mask = Mask.BandMathsType.create((String)invAttr.getName(), (String)invAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + invAttr.getName()), (Color)color, (double)0.5);
        outputProduct.getMaskGroup().add(index++, (ProductNode)mask);
        for (int i = 0; i < this.sdrBands.length; ++i) {
            Band sdrBand = this.sdrBands[i];
            String flagName = "INVALID_" + sdrBand.getName().toUpperCase();
            String flagDesc = "Invalid " + sdrBand.getDescription();
            flagCoding.addFlag(flagName, 1 << sdrBand.getSpectralBandIndex() + 1, flagDesc);
            a = Math.PI * 2 * ((double)i + 0.03225806451612903);
            color = new Color((float)(0.5 + 0.5 * Math.sin(a + 0.9424777960769379)), (float)(0.5 + 0.5 * Math.sin(a + Math.PI)), (float)(0.5 + 0.5 * Math.sin(a + 1.5707963267948966)));
            mask = Mask.BandMathsType.create((String)flagName, (String)flagDesc, (int)w, (int)h, (String)(flagCoding.getName() + "." + flagName), (Color)color, (double)0.4f);
            outputProduct.getMaskGroup().add(index++, (ProductNode)mask);
        }
        return flagCoding;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SdrOp.class);
        }
    }
}

