/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.sdr;

import com.bc.jnn.JnnNet;

public final class SdrAlgorithm
implements Cloneable {
    public final JnnNet _neuralNet;

    public SdrAlgorithm(JnnNet neuralNet) {
        if (neuralNet == null) {
            throw new IllegalArgumentException("neuralNet == null");
        }
        this._neuralNet = neuralNet;
    }

    public double computeSdr(double rhoNorm, double wavelength, double vza, double sza, double ada, double aot470, double aot660, double ang) {
        double[] input = new double[9];
        double[] output = new double[1];
        input[0] = rhoNorm;
        input[1] = wavelength;
        input[2] = Math.cos(sza *= Math.PI / 180);
        input[3] = Math.sin(vza *= Math.PI / 180) * Math.cos(ada *= Math.PI / 180);
        input[4] = Math.sin(vza) * Math.sin(ada);
        input[5] = Math.cos(vza);
        input[6] = aot470;
        input[7] = aot660;
        input[8] = ang;
        this.computeSdr(input, output);
        return output[0];
    }

    public void computeSdr(double[] inputVector, double[] outputVector) {
        this._neuralNet.process(inputVector, outputVector);
    }

    protected SdrAlgorithm clone() {
        return new SdrAlgorithm(this._neuralNet.clone());
    }
}

