/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import java.io.File;
import java.io.IOException;
import org.esa.s3tbx.meris.l2auxdata.AuxFile;
import org.esa.s3tbx.meris.l2auxdata.DpmConfig;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataException;
import org.esa.s3tbx.util.math.LUT;
import org.esa.snap.core.datamodel.ProductData;

public class L2CloudAuxData {
    public LUT surfAlb;
    private static final int SA_NUM_LON = 3600;
    private static final int SA_NUM_LAT = 1800;
    private int month;

    public L2CloudAuxData(DpmConfig config, int month) throws IOException, L2AuxDataException {
        this.month = month;
        this.loadAuxdata(config);
    }

    private void loadAuxdata(DpmConfig config) throws IOException, L2AuxDataException {
        try (AuxFile auxFileO = AuxFile.open((char)'V', (File)config.getAuxDatabaseFile("cloud", null));){
            this.loadCloudFile(auxFileO);
        }
    }

    private void loadCloudFile(AuxFile auxFileO) throws IOException {
        double[] latTab = auxFileO.readDoubleArray("V200", -1);
        double[] lonTab = auxFileO.readDoubleArray("V201", -1);
        float surfalbScale = auxFileO.readFloat("V206");
        ProductData data = auxFileO.readRecord("V300", this.month, -1, 30, null);
        float[] tmpAlb = (float[])data.getElems();
        float[][] surfAlb_LUT = new float[1800][3600];
        for (int i = 0; i < 1800; ++i) {
            for (int j = 0; j < 3600; ++j) {
                surfAlb_LUT[i][j] = surfalbScale * tmpAlb[i * 3600 + j];
            }
        }
        this.surfAlb = new LUT((Object)surfAlb_LUT);
        this.surfAlb.setTab(0, latTab);
        this.surfAlb.setTab(1, lonTab);
    }
}

