/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.BitSetter;

@OperatorMetadata(alias="Meris.CombinedCloud", internal=true)
public class CombinedCloudOp
extends MerisBasisOp {
    public static final String FLAG_BAND_NAME = "combined_cloud";
    public static final int FLAG_INVALID = 0;
    public static final int FLAG_CLEAR = 1;
    public static final int FLAG_CLOUD = 2;
    public static final int FLAG_SNOW = 4;
    public static final int FLAG_CLOUD_EDGE = 8;
    public static final int FLAG_CLOUD_SHADOW = 16;
    @SourceProduct(alias="cloudProb")
    private Product cloudProduct;
    @SourceProduct(alias="blueBand")
    private Product blueBandProduct;
    @TargetProduct
    private Product targetProduct;

    public void initialize() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.cloudProduct, "MER_COMBINED_CLOUD", "MER_L2");
        FlagCoding flagCoding = CombinedCloudOp.createFlagCoding();
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        Band combinedCloudBand = this.targetProduct.addBand(FLAG_BAND_NAME, 20);
        combinedCloudBand.setDescription("combined cloud flags");
        combinedCloudBand.setSampleCoding((SampleCoding)flagCoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle rectangle = targetTile.getRectangle();
        int size = rectangle.height * rectangle.width;
        pm.beginTask("Processing frame...", size + 1);
        try {
            byte[] cloudProbData = (byte[])this.getSourceTile((RasterDataNode)this.cloudProduct.getBand("cloud_flag"), rectangle).getRawSamples().getElems();
            byte[] blueBandData = (byte[])this.getSourceTile((RasterDataNode)this.blueBandProduct.getBand("blue_cloud"), rectangle).getRawSamples().getElems();
            ProductData flagData = targetTile.getRawSamples();
            byte[] combinedCloudData = (byte[])flagData.getElems();
            pm.worked(1);
            for (int i = 0; i < size; ++i) {
                int result;
                byte cloudProb = cloudProbData[i];
                if (cloudProb == 0) {
                    result = 0;
                } else {
                    int combined = 1;
                    byte blueBand = blueBandData[i];
                    if (cloudProb == 1 || BitSetter.isFlagSet((int)blueBand, (int)2) || BitSetter.isFlagSet((int)blueBand, (int)3)) {
                        combined = 2;
                    }
                    if (BitSetter.isFlagSet((int)blueBand, (int)1)) {
                        combined = 4;
                    }
                    boolean snowPlausible = BitSetter.isFlagSet((int)blueBand, (int)5);
                    boolean snowIndex = BitSetter.isFlagSet((int)blueBand, (int)4);
                    boolean brightLand = BitSetter.isFlagSet((int)blueBand, (int)6);
                    result = snowPlausible && (snowIndex || combined == 4) ? 4 : (!snowPlausible && (snowIndex || combined == 4) ? 2 : (brightLand && !snowPlausible && (snowIndex && combined != 2 || combined == 4) ? 2 : (combined == 2 && !snowIndex ? 2 : 1)));
                    if (combined == 1) {
                        result = 1;
                    }
                }
                combinedCloudData[i] = result;
                pm.worked(1);
            }
            targetTile.setRawSamples(flagData);
        }
        finally {
            pm.done();
        }
    }

    public static FlagCoding createFlagCoding() {
        FlagCoding flagCoding = new FlagCoding(FLAG_BAND_NAME);
        flagCoding.setDescription("Combined CLoud Band Flag Coding");
        MetadataAttribute cloudAttr = new MetadataAttribute("clear", 20);
        cloudAttr.getData().setElemInt(1);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("cloud", 20);
        cloudAttr.getData().setElemInt(2);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("snow", 20);
        cloudAttr.getData().setElemInt(4);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("cloud_edge", 20);
        cloudAttr.getData().setElemInt(8);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("cloud_shadow", 20);
        cloudAttr.getData().setElemInt(16);
        flagCoding.addAttribute(cloudAttr);
        return flagCoding;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CombinedCloudOp.class);
        }
    }
}

