/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.jnn.Jnn;
import com.bc.jnn.JnnException;
import com.bc.jnn.JnnNet;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.s3tbx.meris.cloud.L2CloudAuxData;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataProvider;
import org.esa.s3tbx.util.math.FractIndex;
import org.esa.s3tbx.util.math.Interp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.BandMathsOp;

@OperatorMetadata(alias="Meris.CloudTopPressureOp", version="2.3.4", internal=true, authors="Marco Z\u00fchlke", copyright="(c) 2007-2009 by Brockmann Consult", description="Computes cloud top pressure with FUB NN.")
public class CloudTopPressureOp
extends MerisBasisOp {
    private static final String INVALID_EXPRESSION = "l1_flags.INVALID";
    private static final String LAND_EXPRESSION = "l1_flags.LAND_OCEAN";
    private static final String STRAYLIGHT_COEFF_FILE_NAME = "stray_ratio.d";
    private static final String STRAYLIGHT_CORR_WAVELENGTH_FILE_NAME = "lambda.d";
    private static final int BB760 = 10;
    private static final int DETECTOR_LENGTH_RR = 925;
    private float[] straylightCoefficients = new float[925];
    private float[] straylightCorrWavelengths = new float[925];
    @SourceProduct(alias="input")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="If 'true' the algorithm will apply straylight correction.", defaultValue="false")
    private boolean straylightCorr = false;
    private L2AuxData auxData;
    private L2CloudAuxData cloudAuxData;
    private ThreadLocal<JnnNet> waterNet;
    private ThreadLocal<JnnNet> landNet;
    private Band invalidBand;
    private RasterDataNode szaNode;
    private RasterDataNode saaNode;
    private RasterDataNode vzaNode;
    private RasterDataNode vaaNode;

    public void initialize() throws OperatorException {
        try {
            this.loadNeuralNet();
        }
        catch (Exception e) {
            throw new OperatorException("Failed to load neural net ctp.nna:\n" + e.getMessage());
        }
        this.initAuxData();
        try {
            if (this.straylightCorr) {
                this.readStraylightCoeff();
                this.readStraylightCorrWavelengths();
            }
        }
        catch (Exception e) {
            throw new OperatorException("Failed to load straylight correction auxdata:\n" + e.getMessage());
        }
        this.createTargetProduct();
        this.szaNode = this.sourceProduct.getTiePointGrid("sun_zenith");
        this.saaNode = this.sourceProduct.getTiePointGrid("sun_azimuth");
        this.vzaNode = this.sourceProduct.getTiePointGrid("view_zenith");
        this.vaaNode = this.sourceProduct.getTiePointGrid("view_azimuth");
    }

    private void loadNeuralNet() throws IOException, JnnException {
        InputStream neuralNetLandIS = ((Object)((Object)this)).getClass().getResourceAsStream("ctp_NN_1.nna");
        InputStream neuralNetWaterIS = ((Object)((Object)this)).getClass().getResourceAsStream("ctp_NN_2.nna");
        final JnnNet neuralNetLand = this.readNeuralNetFromStream(neuralNetLandIS);
        final JnnNet neuralNetWater = this.readNeuralNetFromStream(neuralNetWaterIS);
        this.landNet = new ThreadLocal<JnnNet>(){

            @Override
            protected JnnNet initialValue() {
                return neuralNetLand.clone();
            }
        };
        this.waterNet = new ThreadLocal<JnnNet>(){

            @Override
            protected JnnNet initialValue() {
                return neuralNetWater.clone();
            }
        };
    }

    private void createTargetProduct() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.sourceProduct, "MER_CTP", "MER_L2");
        if (this.straylightCorr) {
            this.targetProduct.addBand("cloud_top_press_straylight_corr", 30);
        } else {
            this.targetProduct.addBand("cloud_top_press", 30);
        }
        this.invalidBand = CloudTopPressureOp.createBooleanExpressionBand(INVALID_EXPRESSION, this.sourceProduct);
    }

    private void initAuxData() throws OperatorException {
        try {
            L2AuxDataProvider auxdataProvider = L2AuxDataProvider.getInstance();
            this.auxData = auxdataProvider.getAuxdata(this.sourceProduct);
            int month = this.sourceProduct.getStartTime().getAsCalendar().get(2);
            this.cloudAuxData = new L2CloudAuxData(auxdataProvider.getDpmConfig(), month);
        }
        catch (Exception e) {
            throw new OperatorException("Failed to load L2AuxData:\n" + e.getMessage(), (Throwable)e);
        }
    }

    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle rectangle = targetTile.getRectangle();
        Tile detector = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("detector_index"), rectangle);
        Tile sza = this.getSourceTile(this.szaNode, rectangle);
        Tile saa = this.getSourceTile(this.saaNode, rectangle);
        Tile vza = this.getSourceTile(this.vzaNode, rectangle);
        Tile vaa = this.getSourceTile(this.vaaNode, rectangle);
        Tile toar10 = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("radiance_10"), rectangle);
        Tile toar11 = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("radiance_11"), rectangle);
        Tile isInvalid = this.getSourceTile((RasterDataNode)this.invalidBand, rectangle);
        Tile l1bFlags = this.getSourceTile((RasterDataNode)this.sourceProduct.getBand("l1_flags"), rectangle);
        double[] nnInWater = new double[6];
        double[] nnInLand = new double[7];
        double[] nnOut = new double[1];
        JnnNet nnLand = this.landNet.get();
        JnnNet nnWater = this.waterNet.get();
        for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
            this.checkForCancellation();
            for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                if (isInvalid.getSampleBoolean(x, y)) {
                    targetTile.setSample(x, y, 0);
                    continue;
                }
                double szaRad = (double)sza.getSampleFloat(x, y) * (Math.PI / 180);
                double vzaRad = (double)vza.getSampleFloat(x, y) * (Math.PI / 180);
                double stray = 0.0;
                double lambda = this.auxData.central_wavelength[10][detector.getSampleInt(x, y)];
                if (this.straylightCorr) {
                    stray = (double)this.straylightCoefficients[detector.getSampleInt(x, y)] * toar10.getSampleDouble(x, y);
                    lambda = this.straylightCorrWavelengths[detector.getSampleInt(x, y)];
                }
                double toar11XY_corrected = toar11.getSampleDouble(x, y) + stray;
                if (l1bFlags.getSampleBit(x, y, 4)) {
                    GeoPos geoPos = this.sourceProduct.getSceneGeoCoding().getGeoPos(new PixelPos((double)x, (double)y), null);
                    nnInLand[0] = this.computeSurfAlbedo((float)geoPos.getLat(), (float)geoPos.getLon());
                    nnInLand[1] = toar10.getSampleDouble(x, y);
                    nnInLand[2] = toar11XY_corrected / toar10.getSampleDouble(x, y);
                    nnInLand[3] = Math.cos(szaRad);
                    nnInLand[4] = Math.cos(vzaRad);
                    nnInLand[5] = Math.sin(vzaRad) * Math.cos(Math.PI / 180 * (double)(vaa.getSampleFloat(x, y) - saa.getSampleFloat(x, y)));
                    nnInLand[6] = lambda;
                    nnLand.process(nnInLand, nnOut);
                } else {
                    nnInWater[0] = toar10.getSampleDouble(x, y);
                    nnInWater[1] = toar11XY_corrected / toar10.getSampleDouble(x, y);
                    nnInWater[2] = Math.cos(szaRad);
                    nnInWater[3] = Math.cos(vzaRad);
                    nnInWater[4] = Math.sin(vzaRad) * Math.cos(Math.PI / 180 * (double)(vaa.getSampleFloat(x, y) - saa.getSampleFloat(x, y)));
                    nnInWater[5] = lambda;
                    nnWater.process(nnInWater, nnOut);
                }
                targetTile.setSample(x, y, nnOut[0]);
            }
        }
    }

    private static Band createBooleanExpressionBand(String expression, Product sourceProduct) {
        BandMathsOp.BandDescriptor bandDescriptor = new BandMathsOp.BandDescriptor();
        bandDescriptor.name = "band1";
        bandDescriptor.expression = expression;
        bandDescriptor.type = "int8";
        BandMathsOp bandMathsOp = new BandMathsOp();
        bandMathsOp.setParameterDefaultValues();
        bandMathsOp.setSourceProduct(sourceProduct);
        bandMathsOp.setTargetBandDescriptors(new BandMathsOp.BandDescriptor[]{bandDescriptor});
        return bandMathsOp.getTargetProduct().getBandAt(0);
    }

    private double computeSurfAlbedo(float latitude, float longitude) {
        FractIndex[] SaIndex = FractIndex.createArray((int)2);
        Interp.interpCoord((double)latitude, (double[])this.cloudAuxData.surfAlb.getTab(0), (FractIndex)SaIndex[0]);
        Interp.interpCoord((double)longitude, (double[])this.cloudAuxData.surfAlb.getTab(1), (FractIndex)SaIndex[1]);
        return Interp.interpolate((Object)this.cloudAuxData.surfAlb.getJavaArray(), (FractIndex[])SaIndex);
    }

    private void readStraylightCoeff() throws IOException {
        this.readAuxdataArray(STRAYLIGHT_COEFF_FILE_NAME, this.straylightCoefficients);
    }

    private void readStraylightCorrWavelengths() throws IOException {
        this.readAuxdataArray(STRAYLIGHT_CORR_WAVELENGTH_FILE_NAME, this.straylightCorrWavelengths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAuxdataArray(String fileName, float[] array) throws IOException {
        InputStream inputStream = CloudTopPressureOp.class.getResourceAsStream(fileName);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            for (int i = 0; i < array.length; ++i) {
                String line = bufferedReader.readLine();
                line = line.trim();
                array[i] = Float.parseFloat(line);
            }
        }
    }

    private JnnNet readNeuralNetFromFile(File nnFile) throws IOException, JnnException {
        FileReader reader = new FileReader(nnFile);
        return this.getJnnNet(reader);
    }

    private JnnNet readNeuralNetFromStream(InputStream neuralNetStream) throws IOException, JnnException {
        InputStreamReader reader = new InputStreamReader(neuralNetStream);
        return this.getJnnNet(reader);
    }

    private JnnNet getJnnNet(InputStreamReader reader) throws IOException, JnnException {
        try {
            Jnn.setOptimizing((boolean)true);
            JnnNet jnnNet = Jnn.readNna((Reader)reader);
            return jnnNet;
        }
        finally {
            reader.close();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CloudTopPressureOp.class);
        }
    }
}

