/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;
import org.esa.snap.core.util.math.MathUtils;

@OperatorMetadata(alias="Meris.CloudShadow", internal=true)
public class CloudShadowOp
extends MerisBasisOp {
    private static final int MEAN_EARTH_RADIUS = 6372000;
    private static final int MAX_ITER = 5;
    private static final double DIST_THRESHOLD = 0.0013513513513513514;
    private RectangleExtender rectCalculator;
    private GeoCoding geoCoding;
    private RasterDataNode altitudeRDN;
    @SourceProduct(alias="l1b")
    private Product l1bProduct;
    @SourceProduct(alias="cloud")
    private Product cloudProduct;
    @SourceProduct(alias="ctp")
    private Product ctpProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter
    private int shadowWidth;

    public void initialize() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.cloudProduct, "MER_CLOUD_SHADOW", "MER_L2");
        ProductUtils.copyBand((String)"combined_cloud", (Product)this.cloudProduct, (Product)this.targetProduct, (boolean)false);
        if (this.l1bProduct.getProductType().equals("MER_FSG_1P")) {
            if (this.shadowWidth == 0) {
                this.shadowWidth = 16;
            }
            this.altitudeRDN = this.l1bProduct.getBand("altitude");
        } else {
            if (this.shadowWidth == 0) {
                this.shadowWidth = 64;
            }
            this.altitudeRDN = this.l1bProduct.getTiePointGrid("dem_alt");
        }
        this.rectCalculator = new RectangleExtender(new Rectangle(this.l1bProduct.getSceneRasterWidth(), this.l1bProduct.getSceneRasterHeight()), this.shadowWidth, this.shadowWidth);
        this.geoCoding = this.l1bProduct.getSceneGeoCoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        Rectangle sourceRectangle = this.rectCalculator.extend(targetRectangle);
        pm.beginTask("Processing frame...", sourceRectangle.height);
        try {
            int x;
            int y;
            Tile szaTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("sun_zenith"), sourceRectangle);
            Tile saaTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("sun_azimuth"), sourceRectangle);
            Tile vzaTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("view_zenith"), sourceRectangle);
            Tile vaaTile = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("view_azimuth"), sourceRectangle);
            Tile cloudTile = this.getSourceTile((RasterDataNode)this.cloudProduct.getBand("combined_cloud"), sourceRectangle);
            Tile ctpTile = this.getSourceTile((RasterDataNode)this.ctpProduct.getBand("cloud_top_press"), sourceRectangle);
            Tile altTile = this.getSourceTile(this.altitudeRDN, sourceRectangle);
            for (y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                for (x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    targetTile.setSample(x, y, cloudTile.getSampleInt(x, y));
                }
            }
            for (y = sourceRectangle.y; y < sourceRectangle.y + sourceRectangle.height; ++y) {
                for (x = sourceRectangle.x; x < sourceRectangle.x + sourceRectangle.width; ++x) {
                    int pixelY;
                    int pixelX;
                    int flagValue;
                    float cloudAlt;
                    GeoPos shadowPos;
                    if ((cloudTile.getSampleInt(x, y) & 2) == 0) continue;
                    float sza = szaTile.getSampleFloat(x, y) * ((float)Math.PI / 180);
                    float saa = saaTile.getSampleFloat(x, y) * ((float)Math.PI / 180);
                    float vza = vzaTile.getSampleFloat(x, y) * ((float)Math.PI / 180);
                    float vaa = vaaTile.getSampleFloat(x, y) * ((float)Math.PI / 180);
                    PixelPos pixelPos = new PixelPos((double)x, (double)y);
                    GeoPos geoPos = this.geoCoding.getGeoPos(pixelPos, null);
                    float ctp = ctpTile.getSampleFloat(x, y);
                    if (!(ctp > 0.0f) || (shadowPos = this.getCloudShadow2(altTile, sza, saa, vza, vaa, cloudAlt = this.computeHeightFromPressure(ctp), geoPos)) == null || !targetRectangle.contains((Point2D)(pixelPos = this.geoCoding.getPixelPos(shadowPos, pixelPos))) || ((flagValue = cloudTile.getSampleInt(pixelX = MathUtils.floorInt((double)pixelPos.x), pixelY = MathUtils.floorInt((double)pixelPos.y))) & 0x10) != 0) continue;
                    targetTile.setSample(pixelX, pixelY, flagValue += 16);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private float computeHeightFromPressure(float pressure) {
        return (float)(-8000.0 * Math.log(pressure / 1013.0f));
    }

    private GeoPos getCloudShadow2(Tile altTile, float sza, float saa, float vza, float vaa, float cloudAlt, GeoPos appCloud) {
        int iter;
        double surfaceAlt = this.getAltitude(altTile, appCloud);
        double deltaX = -((double)cloudAlt - surfaceAlt) * Math.tan(vza) * Math.sin(vaa);
        double deltaY = -((double)cloudAlt - surfaceAlt) * Math.tan(vza) * Math.cos(vaa);
        double distLat = -(deltaY / 6372000.0) * 57.29577951308232;
        double distLon = -(deltaX / (6372000.0 * Math.cos(appCloud.getLat() * (Math.PI / 180)))) * 57.29577951308232;
        double latCloud = appCloud.getLat() + distLat;
        double lonCloud = appCloud.getLon() + distLon;
        double dist = 0.002702702702702703;
        surfaceAlt = 0.0;
        double lat = latCloud;
        double lon = lonCloud;
        GeoPos pos = new GeoPos();
        for (iter = 0; iter < 5 && dist > 0.0013513513513513514 && surfaceAlt < (double)cloudAlt; ++iter) {
            double lat0 = lat;
            double lon0 = lon;
            pos.setLocation((double)((float)lat), (double)((float)lon));
            PixelPos pixelPos = this.geoCoding.getPixelPos(pos, null);
            if (!pixelPos.isValid() || !altTile.getRectangle().contains((Point2D)pixelPos)) {
                return null;
            }
            surfaceAlt = this.getAltitude(altTile, pos);
            double deltaProjX = ((double)cloudAlt - surfaceAlt) * Math.tan(sza) * Math.sin(saa);
            double deltaProjY = ((double)cloudAlt - surfaceAlt) * Math.tan(sza) * Math.cos(saa);
            distLat = -(deltaProjY / 6372000.0) * 57.29577951308232;
            lat = latCloud + distLat;
            distLon = -(deltaProjX / (6372000.0 * Math.cos(lat * (Math.PI / 180)))) * 57.29577951308232;
            lon = lonCloud + distLon;
            dist = Math.max(Math.abs(lat - lat0), Math.abs(lon - lon0));
        }
        if (surfaceAlt < (double)cloudAlt && iter < 5 && dist < 0.0013513513513513514) {
            return new GeoPos((double)((float)lat), (double)((float)lon));
        }
        return null;
    }

    private float getAltitude(Tile altTile, GeoPos geoPos) {
        PixelPos pixelPos = this.geoCoding.getPixelPos(geoPos, null);
        Rectangle rectangle = altTile.getRectangle();
        int x = (int)MathUtils.roundAndCrop((double)pixelPos.x, (long)rectangle.x, (long)(rectangle.x + rectangle.width - 1));
        int y = (int)MathUtils.roundAndCrop((double)pixelPos.y, (long)rectangle.y, (long)(rectangle.y + rectangle.height - 1));
        return altTile.getSampleFloat(x, y);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CloudShadowOp.class);
        }
    }
}

