/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.esa.s3tbx.meris.AlbedoUtils;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.s3tbx.meris.cloud.CentralWavelengthProvider;
import org.esa.s3tbx.meris.cloud.CloudAlgorithm;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.BandMathsOp;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.envisat.EnvisatConstants;

@OperatorMetadata(alias="Meris.CloudProbability", internal=true)
public class CloudProbabilityOp
extends MerisBasisOp {
    public static final String CLOUD_AUXDATA_DIR_PROPERTY = "cloud.auxdata.dir";
    public static final String CONFIG_FILE_NAME = "config_file_name";
    public static final String INVALID_EXPRESSION = "invalid_expression";
    public static final String CLOUD_PROP_BAND = "cloud_prob";
    public static final String CLOUD_FLAG_BAND = "cloud_flag";
    public static final int FLAG_INVALID = 0;
    public static final int FLAG_CLOUDY = 1;
    public static final int FLAG_CLOUDFREE = 2;
    public static final int FLAG_UNCERTAIN = 4;
    private static final String DEFAULT_OUTPUT_PRODUCT_NAME = "MER_CLOUD";
    private static final String PRODUCT_TYPE = "MER_L2_CLOUD";
    private static final String DEFAULT_CONFIG_FILE = "cloud_config.txt";
    private static final String DEFAULT_VALID_LAND_EXP = "not l1_flags.INVALID and dem_alt > -50";
    private static final String DEFAULT_VALID_OCEAN_EXP = "not l1_flags.INVALID and dem_alt <= -50";
    private static final float SCALING_FACTOR = 0.001f;
    private static final String PRESS_SCALE_HEIGHT_KEY = "press_scale_height";
    private float[] centralWavelenth;
    private CentralWavelengthProvider centralWavelengthProvider;
    private Band cloudBand;
    private Band cloudFlagBand;
    private Band[] radianceBands;
    private Band validLandBand;
    private Band validOceanBand;
    private Band landBand;
    private CloudAlgorithm landAlgo;
    private CloudAlgorithm oceanAlgo;
    private int pressScaleHeight;
    @SourceProduct(alias="input")
    private Product l1bProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter
    private String configFile = "cloud_config.txt";
    @Parameter
    private String validLandExpression = "not l1_flags.INVALID and dem_alt > -50";
    @Parameter
    private String validOceanExpression = "not l1_flags.INVALID and dem_alt <= -50";
    private File auxdataTargetDir;
    private Properties configProperties;

    public void initialize() throws OperatorException {
        try {
            this.loadAuxdata();
        }
        catch (IOException e) {
            throw new OperatorException("Could not load auxdata", (Throwable)e);
        }
        this.centralWavelenth = this.centralWavelengthProvider.getCentralWavelength(this.l1bProduct.getProductType());
        this.targetProduct = this.createCompatibleProduct(this.l1bProduct, DEFAULT_OUTPUT_PRODUCT_NAME, PRODUCT_TYPE);
        this.cloudBand = this.targetProduct.addBand(CLOUD_PROP_BAND, 11);
        this.cloudBand.setDescription("Probability of clouds");
        this.cloudBand.setScalingFactor((double)0.001f);
        this.cloudBand.setNoDataValueUsed(true);
        this.cloudBand.setGeophysicalNoDataValue(-1.0);
        FlagCoding cloudFlagCoding = CloudProbabilityOp.createCloudFlagCoding(this.targetProduct);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)cloudFlagCoding);
        this.cloudFlagBand = this.targetProduct.addBand(CLOUD_FLAG_BAND, 20);
        this.cloudFlagBand.setDescription("Cloud specific flags");
        this.cloudFlagBand.setSampleCoding((SampleCoding)cloudFlagCoding);
        String[] radianceBandNames = EnvisatConstants.MERIS_L1B_SPECTRAL_BAND_NAMES;
        this.radianceBands = new Band[radianceBandNames.length];
        for (int bandIndex = 0; bandIndex < radianceBandNames.length; ++bandIndex) {
            String bandName = radianceBandNames[bandIndex];
            this.radianceBands[bandIndex] = this.l1bProduct.getBand(bandName);
            if (this.radianceBands[bandIndex] != null) continue;
            throw new IllegalArgumentException("Source product does not contain band " + bandName);
        }
        this.createBooleanBands();
    }

    private void createBooleanBands() throws OperatorException {
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[3];
        bandDescriptors[0] = new BandMathsOp.BandDescriptor();
        bandDescriptors[0].name = "validLand";
        bandDescriptors[0].expression = this.validLandExpression;
        bandDescriptors[0].type = "int8";
        bandDescriptors[1] = new BandMathsOp.BandDescriptor();
        bandDescriptors[1].name = "validOcean";
        bandDescriptors[1].expression = this.validOceanExpression;
        bandDescriptors[1].type = "int8";
        bandDescriptors[2] = new BandMathsOp.BandDescriptor();
        bandDescriptors[2].name = "land";
        bandDescriptors[2].expression = "l1_flags.LAND_OCEAN";
        bandDescriptors[2].type = "int8";
        parameters.put("targetBands", bandDescriptors);
        Product expProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)this.l1bProduct);
        this.validLandBand = expProduct.getBand("validLand");
        this.validOceanBand = expProduct.getBand("validOcean");
        this.landBand = expProduct.getBand("land");
    }

    private void loadAuxdata() throws IOException {
        Path auxdataDirPath = SystemUtils.getAuxDataPath().resolve("cloudprob").toAbsolutePath();
        this.auxdataTargetDir = auxdataDirPath.toFile();
        Path sourcePath = ResourceInstaller.findModuleCodeBasePath(((Object)((Object)this)).getClass()).resolve("auxdata");
        try {
            new ResourceInstaller(sourcePath, auxdataDirPath).install(".*", ProgressMonitor.NULL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File configPropFile = new File(this.auxdataTargetDir, this.configFile);
        FileInputStream propertiesStream = new FileInputStream(configPropFile);
        this.configProperties = new Properties();
        this.configProperties.load(propertiesStream);
        this.pressScaleHeight = Integer.parseInt(this.configProperties.getProperty(PRESS_SCALE_HEIGHT_KEY));
        this.centralWavelengthProvider = new CentralWavelengthProvider();
        this.centralWavelengthProvider.readAuxData(this.auxdataTargetDir);
        try {
            this.landAlgo = new CloudAlgorithm(this.auxdataTargetDir, this.configProperties.getProperty("land"));
            this.oceanAlgo = new CloudAlgorithm(this.auxdataTargetDir, this.configProperties.getProperty("ocean"));
        }
        catch (IOException e) {
            throw new OperatorException("Could not load auxdata", (Throwable)e);
        }
    }

    public static FlagCoding createCloudFlagCoding(Product outputProduct) {
        FlagCoding flagCoding = new FlagCoding(CLOUD_FLAG_BAND);
        flagCoding.setDescription("Cloud Flag Coding");
        int index = 0;
        int w = outputProduct.getSceneRasterWidth();
        int h = outputProduct.getSceneRasterHeight();
        MetadataAttribute cloudAttr = new MetadataAttribute("cloudy", 20);
        cloudAttr.getData().setElemInt(1);
        cloudAttr.setDescription("is with more than 80% cloudy");
        flagCoding.addAttribute(cloudAttr);
        Mask mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)CloudProbabilityOp.createBitmaskColor(1, 3), (double)0.5);
        outputProduct.getMaskGroup().add(index++, (ProductNode)mask);
        cloudAttr = new MetadataAttribute("cloudfree", 20);
        cloudAttr.getData().setElemInt(2);
        cloudAttr.setDescription("is with less than 20% cloudy");
        flagCoding.addAttribute(cloudAttr);
        mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)CloudProbabilityOp.createBitmaskColor(2, 3), (double)0.5);
        outputProduct.getMaskGroup().add(index++, (ProductNode)mask);
        cloudAttr = new MetadataAttribute("cloud_uncertain", 20);
        cloudAttr.getData().setElemInt(4);
        cloudAttr.setDescription("is with between 20% and 80% cloudy");
        flagCoding.addAttribute(cloudAttr);
        mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)CloudProbabilityOp.createBitmaskColor(3, 3), (double)0.5);
        outputProduct.getMaskGroup().add(index, (ProductNode)mask);
        return flagCoding;
    }

    private static Color createBitmaskColor(int index, int maxIndex) {
        double rf1 = 0.0;
        double gf1 = 0.5;
        double bf1 = 1.0;
        double a = Math.PI * 2 * (double)index / (double)maxIndex;
        return new Color((float)(0.5 + 0.5 * Math.sin(a + 0.0)), (float)(0.5 + 0.5 * Math.sin(a + 1.5707963267948966)), (float)(0.5 + 0.5 * Math.sin(a + Math.PI)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        pm.beginTask("Processing frame...", rectangle.height);
        try {
            Tile[] radiance = new Tile[this.radianceBands.length];
            for (int i1 = 0; i1 < this.radianceBands.length; ++i1) {
                radiance[i1] = this.getSourceTile((RasterDataNode)this.radianceBands[i1], rectangle);
            }
            Tile detector = this.getSourceTile((RasterDataNode)this.l1bProduct.getBand("detector_index"), rectangle);
            Tile sza = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("sun_zenith"), rectangle);
            Tile saa = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("sun_azimuth"), rectangle);
            Tile vza = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("view_zenith"), rectangle);
            Tile vaa = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("view_azimuth"), rectangle);
            Tile pressure = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("atm_press"), rectangle);
            Tile altitude = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("dem_alt"), rectangle);
            Tile isValidLand = this.getSourceTile((RasterDataNode)this.validLandBand, rectangle);
            Tile isValidOcean = this.getSourceTile((RasterDataNode)this.validOceanBand, rectangle);
            Tile isLand = this.getSourceTile((RasterDataNode)this.landBand, rectangle);
            Tile cloudTile = targetTiles.get(this.cloudBand);
            Tile flagTile = targetTiles.get(this.cloudFlagBand);
            CloudAlgorithm cloneLandAlgo = null;
            CloudAlgorithm cloneOceanAlgo = null;
            try {
                cloneLandAlgo = this.landAlgo.clone();
                cloneOceanAlgo = this.oceanAlgo.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            double[] cloudIn = new double[15];
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                for (int x = rectangle.x; x < rectangle.x + rectangle.width && !pm.isCanceled(); ++x) {
                    flagTile.setSample(x, y, 0);
                    if (!isValidLand.getSampleBoolean(x, y) && !isValidOcean.getSampleBoolean(x, y)) {
                        cloudTile.setSample(x, y, -1);
                        continue;
                    }
                    double aziDiff = AlbedoUtils.computeAzimuthDifference(vaa.getSampleFloat(x, y), saa.getSampleFloat(x, y)) * (Math.PI / 180);
                    double szaCos = Math.cos((double)sza.getSampleFloat(x, y) * (Math.PI / 180));
                    cloudIn[0] = this.calculateI(radiance[0].getSampleDouble(x, y), this.radianceBands[0].getSolarFlux(), szaCos);
                    cloudIn[1] = this.calculateI(radiance[1].getSampleDouble(x, y), this.radianceBands[1].getSolarFlux(), szaCos);
                    cloudIn[2] = this.calculateI(radiance[2].getSampleDouble(x, y), this.radianceBands[2].getSolarFlux(), szaCos);
                    cloudIn[3] = this.calculateI(radiance[3].getSampleDouble(x, y), this.radianceBands[3].getSolarFlux(), szaCos);
                    cloudIn[4] = this.calculateI(radiance[4].getSampleDouble(x, y), this.radianceBands[4].getSolarFlux(), szaCos);
                    cloudIn[5] = this.calculateI(radiance[5].getSampleDouble(x, y), this.radianceBands[5].getSolarFlux(), szaCos);
                    cloudIn[6] = this.calculateI(radiance[8].getSampleDouble(x, y), this.radianceBands[8].getSolarFlux(), szaCos);
                    cloudIn[7] = this.calculateI(radiance[9].getSampleDouble(x, y), this.radianceBands[9].getSolarFlux(), szaCos);
                    cloudIn[8] = this.calculateI(radiance[12].getSampleDouble(x, y), this.radianceBands[12].getSolarFlux(), szaCos);
                    cloudIn[9] = radiance[10].getSampleDouble(x, y) * (double)this.radianceBands[9].getSolarFlux() / (radiance[9].getSampleDouble(x, y) * (double)this.radianceBands[10].getSolarFlux());
                    cloudIn[10] = this.altitudeCorrectedPressure(pressure.getSampleFloat(x, y), altitude.getSampleFloat(x, y), isLand.getSampleBoolean(x, y));
                    cloudIn[11] = this.centralWavelenth[detector.getSampleInt(x, y)];
                    cloudIn[12] = szaCos;
                    double vzaRad = (double)vza.getSampleFloat(x, y) * (Math.PI / 180);
                    cloudIn[13] = Math.cos(vzaRad);
                    cloudIn[14] = Math.cos(aziDiff) * Math.sin(vzaRad);
                    double cloudProbability = 0.0;
                    if (isValidLand.getSampleBoolean(x, y)) {
                        cloudProbability = cloneLandAlgo.computeCloudProbability(cloudIn);
                    } else if (isValidOcean.getSampleBoolean(x, y)) {
                        cloudProbability = cloneOceanAlgo.computeCloudProbability(cloudIn);
                    }
                    if (cloudProbability > 0.8) {
                        flagTile.setSample(x, y, 1);
                    } else if (cloudProbability < 0.2) {
                        flagTile.setSample(x, y, 2);
                    } else if (cloudProbability >= 0.2 && cloudProbability <= 0.8) {
                        flagTile.setSample(x, y, 4);
                    }
                    cloudTile.setSample(x, y, cloudProbability);
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    protected double calculateI(double rad, float sunSpectralFlux, double sunZenithCos) {
        return rad / ((double)sunSpectralFlux * sunZenithCos);
    }

    protected double altitudeCorrectedPressure(double press, double alt, boolean isLandPixel) {
        double correctedPressure;
        if (isLandPixel) {
            double f = Math.exp(-Math.max(0.0, alt) / (double)this.pressScaleHeight);
            correctedPressure = press * f;
        } else {
            correctedPressure = press;
        }
        return correctedPressure;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CloudProbabilityOp.class);
        }
    }
}

