/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.RectangleExtender;

@OperatorMetadata(alias="Meris.CloudEdge", internal=true)
public class CloudEdgeOp
extends MerisBasisOp {
    private RectangleExtender rectCalculator;
    private Band sourceBand;
    @SourceProduct(alias="input")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter
    private int cloudWidth;

    public void initialize() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.sourceProduct, "cloude_edge", "MER_L2");
        this.sourceBand = this.sourceProduct.getBand("combined_cloud");
        ProductUtils.copyBand((String)"combined_cloud", (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
        if (this.cloudWidth == 0) {
            this.cloudWidth = 1;
        }
        this.rectCalculator = new RectangleExtender(new Rectangle(this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight()), this.cloudWidth, this.cloudWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRectangle = targetTile.getRectangle();
        Rectangle sourceRectangle = this.rectCalculator.extend(targetRectangle);
        int size = sourceRectangle.height * sourceRectangle.width;
        pm.beginTask("Processing frame...", size + 1);
        try {
            int x;
            int y;
            Tile cloudSource = this.getSourceTile((RasterDataNode)this.sourceBand, sourceRectangle);
            for (y = targetRectangle.y; y < targetRectangle.y + targetRectangle.height; ++y) {
                for (x = targetRectangle.x; x < targetRectangle.x + targetRectangle.width; ++x) {
                    targetTile.setSample(x, y, cloudSource.getSampleInt(x, y));
                }
            }
            for (y = sourceRectangle.y; y < sourceRectangle.y + sourceRectangle.height; ++y) {
                for (x = sourceRectangle.x; x < sourceRectangle.x + sourceRectangle.width; ++x) {
                    int cloudFlag = cloudSource.getSampleInt(x, y);
                    if ((cloudFlag & 2) == 0 && (cloudFlag & 0x10) == 0) continue;
                    this.markEdgeAround(x, y, cloudSource, targetTile);
                }
            }
        }
        finally {
            pm.done();
        }
    }

    private void markEdgeAround(int xi, int yi, Tile cloudSource, Tile cloudTarget) {
        int yEnd;
        int yStart;
        int xEnd;
        Rectangle targetRectangle = cloudTarget.getRectangle();
        int xStart = xi - this.cloudWidth;
        if (xStart < targetRectangle.x) {
            xStart = targetRectangle.x;
        }
        if ((xEnd = xi + this.cloudWidth) > targetRectangle.x + targetRectangle.width - 1) {
            xEnd = targetRectangle.x + targetRectangle.width - 1;
        }
        if ((yStart = yi - this.cloudWidth) < targetRectangle.y) {
            yStart = targetRectangle.y;
        }
        if ((yEnd = yi + this.cloudWidth) > targetRectangle.y + targetRectangle.height - 1) {
            yEnd = targetRectangle.y + targetRectangle.height - 1;
        }
        for (int y = yStart; y <= yEnd; ++y) {
            for (int x = xStart; x <= xEnd; ++x) {
                int pixelValue = cloudSource.getSampleInt(x, y);
                if (pixelValue == 0 || (pixelValue & 2) != 0 || (pixelValue & 0x10) != 0 || (pixelValue & 8) != 0) continue;
                cloudTarget.setSample(x, y, pixelValue += 8);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(CloudEdgeOp.class);
        }
    }
}

